/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: ws_x11.c,v 1.2 2000/01/18 23:24:21 rich Exp $
 */

#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "xracer.h"
#include "xracer-ws.h"
#include "xracer-log.h"

/* X11- and GLUT-specific hack to warp and grab the pointer into the window. */
struct GLUTwindow
{
  int num;
  Window win;
};

extern Display *__glutDisplay;

extern Window __glutRoot;
extern struct GLUTwindow *__glutCurrentWindow;

void
xrWsWarpPointer ()
{
  Window window = __glutCurrentWindow->win;

  XWarpPointer(__glutDisplay, 0, window, 0, 0, 0, 0, xrWidth/2, xrHeight/2);
}

/* Grab the pointer. */
void
xrWsGrabPointer ()
{
  Window window = __glutCurrentWindow->win;

  if (XGrabPointer(__glutDisplay, window, True,
        ButtonReleaseMask | ButtonPressMask,
        GrabModeAsync, GrabModeAsync,
        window, None, CurrentTime) != GrabSuccess)
    xrLog (LOG_ERROR, "pointer grab failed");
}

/* Flush out the event queue. */
void
xrWsFlushEventQueue ()
{
  XSync(__glutDisplay, False);
}

/* X11 hack to give window a class, so WindowManagers can interact with it
 * (e.g. start xracer without window borders/titlebar, start fullscreen,...)
 * Why isn't this implemented in glutCreateWindow?
 */
void
xrWsFixWindowClass ()
{
   XClassHint classhint;
   Window window = __glutCurrentWindow->win;

   classhint.res_name = (char *) "xracer";
   classhint.res_class = (char *) "XRacer";
   XSetClassHint (__glutDisplay, window, &classhint);
}
