#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Segments.Integrators._Stepper import _Stepper

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1484975072.291069
__CHEETAH_genTimestamp__ = 'Sat Jan 21 16:04:32 2017'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-2.2.3/xpdeint/Segments/Integrators/RK45Stepper.tmpl'
__CHEETAH_srcLastModified__ = 'Mon Oct 21 12:39:43 2013'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class RK45Stepper(_Stepper):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(RK45Stepper, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def name(self, **KWS):



        ## Generated from @def name: RK45 at line 24, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''RK45''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def localInitialise(self, **KWS):


        """
        Initialise all of the Cash-Karp coefficients, etc.
        """

        ## CHEETAH: generated from @def localInitialise at line 33, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(RK45Stepper, self).localInitialise()
        if _v is not None: write(_filter(_v))
        # 
        write(u'''
// Cash-Karp coefficients
real _a_raw[7];
real _a[7];
real _b[7][7];
real _c[7];
real _cs[7];
// linear combinations for the (k_i)s
real _d[4];
real _e[5];
real _f[6];
real _g[7];

_a_raw[0]=0.0;
_a_raw[1]=0.0;
_a_raw[2]=1.0/5;
_a_raw[3]=3.0/10;
_a_raw[4]=3.0/5;
_a_raw[5]=1.0;
_a_raw[6]=7.0/8.0;

_a[0]=0.0;
_a[1]=0.0;
for(long _i0 = 2; _i0 < 7; _i0++)
  _a[_i0] = _a_raw[_i0] - _a_raw[_i0-1];

_b[2][1]=1.0/5;
_b[3][1]=3.0/40;
_b[3][2]=9.0/40;
_b[4][1]=3.0/10;
_b[4][2]=-9.0/10;
_b[4][3]=6.0/5;
_b[5][1]=-11.0/54;
_b[5][2]=5.0/2;
_b[5][3]=-70.0/27;
_b[5][4]=35.0/27;
_b[6][1]=1631.0/55296;
_b[6][2]=175.0/512;
_b[6][3]=575.0/13824;
_b[6][4]=44275.0/110592;
_b[6][5]=253.0/4096;

_c[0]=0.0;
_c[1]=37.0/378;
_c[2]=0.0;
_c[3]=250.0/621;
_c[4]=125.0/594;
_c[5]=0.0;
_c[6]=512.0/1771;

_cs[0]=0.0;
_cs[1]=2825.0/27648;
_cs[2]=0.0;
_cs[3]=18575.0/48384;
_cs[4]=13525.0/55296;
_cs[5]=277.0/14336;
_cs[6]=1.0/4;

_d[0]=0.0;
_d[1]=1.0-_b[3][1]/_c[1];
_d[2]=_b[3][1]/_c[1];
_d[3]=_b[3][2];

_e[0]=0.0;
_e[1]=1.0-_b[4][1]/_c[1];
_e[2]=_b[4][1]/_c[1];
_e[3]=_b[4][2];
_e[4]=_b[4][3];

_f[0]=0.0;
_f[1]=1.0-_b[5][1]/_c[1];
_f[2]=_b[5][1]/_c[1];
_f[3]=_b[5][2];
_f[4]=_b[5][3]-_b[5][1]/_c[1]*_c[3];
_f[5]=_b[5][4]-_b[5][1]/_c[1]*_c[4];

real _den=_c[1]*_cs[4]-_cs[1]*_c[4];
_g[0]=0.0;
_g[1]=( _b[6][4]*(_cs[1]-_c[1]) + _b[6][1]*(_c[4]-_cs[4]) )/_den + 1.0;
_g[2]=  _b[6][2];
_g[3]=( _b[6][4]*(_cs[1]*_c[3] - _c[1]*_cs[3]) + _b[6][1]*(_cs[3]*_c[4] - _c[3]*_cs[4]) )/_den + _b[6][3];
_g[4]=( _b[6][1]*_cs[4]-_b[6][4]*_cs[1] )/_den;
_g[5]=  _b[6][5] + _cs[5]*( _b[6][1]*_c[4]-_b[6][4]*_c[1] )/_den;
_g[6]=( -_b[6][1]*_c[4]+_b[6][4]*_c[1] )/_den;
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def singleIntegrationStep(self, function, **KWS):



        ## CHEETAH: generated from @def singleIntegrationStep($function) at line 130, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        arguments = {'_step': '_step'}
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 133, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 133, col 1.
        write(u'''
// a_k = y1
''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_akfield') # u"${copyVectors($integrationVectors, '_akfield')}" on line 136, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${copyVectors($integrationVectors, '_akfield')}")) # from line 136, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"callFunction",False)('nonconstantIPFields', arguments, _exponent = 1, parentFunction=function) # u"${callFunction('nonconstantIPFields', arguments, _exponent = 1, parentFunction=function)}" on line 138, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('nonconstantIPFields', arguments, _exponent = 1, parentFunction=function)}")) # from line 138, col 1.
        write(u'''

// a_i = D(a_2*dt)[y1]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = +1, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = +1, parentFunction=function)}" on line 141, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = +1, parentFunction=function)}")) # from line 141, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 142, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 142, col 1.
        write(u'''
// y2 = y1
''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_checkfield') # u"${copyVectors($integrationVectors, '_checkfield')}" on line 145, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${copyVectors($integrationVectors, '_checkfield')}")) # from line 145, col 1.
        write(u'''
// a_i = y1
''')
        _v = VFFSL(SL,"copyVectors",False)(VFFSL(SL,"integrationVectors",True), '_aifield') # u"${copyVectors($integrationVectors, '_aifield')}" on line 148, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${copyVectors($integrationVectors, '_aifield')}")) # from line 148, col 1.
        write(u'''
''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 150, col 3
            write(u'''_active_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 151, col 9
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 151, col 9.
            write(u''' = _akfield_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 151, col 33
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 151, col 33.
            write(u''';
''')
        write(u'''
// a_k = G[a_k, t]
''')
        _v = VFFSL(SL,"callFunction",False)('deltaA', arguments, parentFunction=function) # u"${callFunction('deltaA', arguments, parentFunction=function)}" on line 155, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('deltaA', arguments, parentFunction=function)}")) # from line 155, col 1.
        write(u'''

// a_k = D(a_2*dt)[a_k]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = +1, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = +1, parentFunction=function)}" on line 158, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = +1, parentFunction=function)}")) # from line 158, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 159, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 159, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""// y1 = y1 + c_1*a_k
_${vector.id}[$index] += _c[1]*_akfield_${vector.id}[$index];
// y2 = y2 + cs_1*a_k
_checkfield_${vector.id}[$index] += _cs[1]*_akfield_${vector.id}[$index];
// a_k = a_i + b_21*a_k
_akfield_${vector.id}[$index] = _aifield_${vector.id}[$index] + _b[2][1]*_akfield_${vector.id}[$index];
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, rawExpr=u'${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""// y1 = y1 + c_1*a_k\n_${vector.id}[$index] += _c[1]*_akfield_${vector.id}[$index];\n// y2 = y2 + cs_1*a_k\n_checkfield_${vector.id}[$index] += _cs[1]*_akfield_${vector.id}[$index];\n// a_k = a_i + b_21*a_k\n_akfield_${vector.id}[$index] = _aifield_${vector.id}[$index] + _b[2][1]*_akfield_${vector.id}[$index];\n""", basis = $homeBasis)}')) # from line 161, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 170, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 170, col 1.
        write(u''' += _a[2] * _step;

''')
        _v = VFFSL(SL,"callFunction",False)('nonconstantIPFields', arguments, _exponent = 2, parentFunction=function) # u"${callFunction('nonconstantIPFields', arguments, _exponent = 2, parentFunction=function)}" on line 172, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('nonconstantIPFields', arguments, _exponent = 2, parentFunction=function)}")) # from line 172, col 1.
        write(u'''

''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = -2, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = -2, parentFunction=function)}" on line 174, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = -2, parentFunction=function)}")) # from line 174, col 1.
        write(u'''

// a_k = G[a_k, t + aa_2*dt]
''')
        _v = VFFSL(SL,"callFunction",False)('deltaA', arguments, parentFunction=function) # u"${callFunction('deltaA', arguments, parentFunction=function)}" on line 177, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('deltaA', arguments, parentFunction=function)}")) # from line 177, col 1.
        write(u'''

''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = +2, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = +2, parentFunction=function)}" on line 179, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = +2, parentFunction=function)}")) # from line 179, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 180, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 180, col 1.
        write(u'''
// c_2 == cs_2 == 0
''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""// a_j = d_1*a_i + d_2*y1 + d_3*a_k
_ajfield_${vector.id}[$index] = _d[1]*_aifield_${vector.id}[$index] + _d[2]*_${vector.id}[$index] + _d[3]*_akfield_${vector.id}[$index];
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, rawExpr=u'${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""// a_j = d_1*a_i + d_2*y1 + d_3*a_k\n_ajfield_${vector.id}[$index] = _d[1]*_aifield_${vector.id}[$index] + _d[2]*_${vector.id}[$index] + _d[3]*_akfield_${vector.id}[$index];\n""", basis = $homeBasis)}')) # from line 183, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 188, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 188, col 1.
        write(u''' += _a[3] * _step;

''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 190, col 3
            write(u'''_active_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 191, col 9
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 191, col 9.
            write(u''' = _ajfield_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 191, col 33
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 191, col 33.
            write(u''';
''')
        write(u'''
''')
        _v = VFFSL(SL,"callFunction",False)('nonconstantIPFields', arguments, _exponent = 3, parentFunction=function) # u"${callFunction('nonconstantIPFields', arguments, _exponent = 3, parentFunction=function)}" on line 194, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('nonconstantIPFields', arguments, _exponent = 3, parentFunction=function)}")) # from line 194, col 1.
        write(u'''

// a_j = D((a_3 - a_2)*dt)[a_j]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = -3, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = -3, parentFunction=function)}" on line 197, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = -3, parentFunction=function)}")) # from line 197, col 1.
        write(u'''

// a_j = G[a_j, t + aa_3*dt]
''')
        _v = VFFSL(SL,"callFunction",False)('deltaA', arguments, parentFunction=function) # u"${callFunction('deltaA', arguments, parentFunction=function)}" on line 200, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('deltaA', arguments, parentFunction=function)}")) # from line 200, col 1.
        write(u'''

// a_j = D(-(a_3 - a_2)*dt)[a_j]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = +3, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = +3, parentFunction=function)}" on line 203, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = +3, parentFunction=function)}")) # from line 203, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 204, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 204, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""// a_l = e_1*a_i + e_2*y1 + e_3*a_k + e_4*a_j
_alfield_${vector.id}[$index] = _e[1]*_aifield_${vector.id}[$index] + _e[2]*_${vector.id}[$index] + _e[3]*_akfield_${vector.id}[$index] + _e[4]*_ajfield_${vector.id}[$index];
// y1 = y1 + c_3*a_j
_${vector.id}[$index] += _c[3]*_ajfield_${vector.id}[$index];
// y2 = y2 + cs_3*a_j
_checkfield_${vector.id}[$index] += _cs[3]*_ajfield_${vector.id}[$index];
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, rawExpr=u'${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""// a_l = e_1*a_i + e_2*y1 + e_3*a_k + e_4*a_j\n_alfield_${vector.id}[$index] = _e[1]*_aifield_${vector.id}[$index] + _e[2]*_${vector.id}[$index] + _e[3]*_akfield_${vector.id}[$index] + _e[4]*_ajfield_${vector.id}[$index];\n// y1 = y1 + c_3*a_j\n_${vector.id}[$index] += _c[3]*_ajfield_${vector.id}[$index];\n// y2 = y2 + cs_3*a_j\n_checkfield_${vector.id}[$index] += _cs[3]*_ajfield_${vector.id}[$index];\n""", basis = $homeBasis)}')) # from line 206, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 215, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 215, col 1.
        write(u''' += _a[4] * _step;

''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 217, col 3
            write(u'''_active_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 218, col 9
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 218, col 9.
            write(u''' = _alfield_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 218, col 33
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 218, col 33.
            write(u''';
''')
        write(u'''
''')
        _v = VFFSL(SL,"callFunction",False)('nonconstantIPFields', arguments, _exponent = 4, parentFunction=function) # u"${callFunction('nonconstantIPFields', arguments, _exponent = 4, parentFunction=function)}" on line 221, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('nonconstantIPFields', arguments, _exponent = 4, parentFunction=function)}")) # from line 221, col 1.
        write(u'''

// a_l = D((a_4 - a_2)*dt)[a_l]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = -4, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = -4, parentFunction=function)}" on line 224, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = -4, parentFunction=function)}")) # from line 224, col 1.
        write(u'''

// a_l = G[a_l, t + aa_4*dt]
''')
        _v = VFFSL(SL,"callFunction",False)('deltaA', arguments, parentFunction=function) # u"${callFunction('deltaA', arguments, parentFunction=function)}" on line 227, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('deltaA', arguments, parentFunction=function)}")) # from line 227, col 1.
        write(u'''

// a_l = D(-(a_4 - a_2)*dt)[a_l]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = +4, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = +4, parentFunction=function)}" on line 230, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = +4, parentFunction=function)}")) # from line 230, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 231, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 231, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""// y1 = y1 + c_4*a_l
_${vector.id}[$index] += _c[4]*_alfield_${vector.id}[$index];
// y2 = y2 + cs_4*a_l
_checkfield_${vector.id}[$index] += _cs[4]*_alfield_${vector.id}[$index];
// a_l = f_1*a_i + f_2*y1 + f_3*a_k + f_4*a_j + f_5*a_l
_alfield_${vector.id}[$index] = _f[1]*_aifield_${vector.id}[$index] + _f[2]*_${vector.id}[$index] + _f[3]*_akfield_${vector.id}[$index] + _f[4]*_ajfield_${vector.id}[$index] + _f[5]*_alfield_${vector.id}[$index];
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, rawExpr=u'${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""// y1 = y1 + c_4*a_l\n_${vector.id}[$index] += _c[4]*_alfield_${vector.id}[$index];\n// y2 = y2 + cs_4*a_l\n_checkfield_${vector.id}[$index] += _cs[4]*_alfield_${vector.id}[$index];\n// a_l = f_1*a_i + f_2*y1 + f_3*a_k + f_4*a_j + f_5*a_l\n_alfield_${vector.id}[$index] = _f[1]*_aifield_${vector.id}[$index] + _f[2]*_${vector.id}[$index] + _f[3]*_akfield_${vector.id}[$index] + _f[4]*_ajfield_${vector.id}[$index] + _f[5]*_alfield_${vector.id}[$index];\n""", basis = $homeBasis)}')) # from line 233, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 242, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 242, col 1.
        write(u''' += _a[5] * _step;

// a_l = G[a_l, t + aa_5*dt]
''')
        _v = VFFSL(SL,"callFunction",False)('deltaA', arguments, parentFunction=function) # u"${callFunction('deltaA', arguments, parentFunction=function)}" on line 245, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('deltaA', arguments, parentFunction=function)}")) # from line 245, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 246, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 246, col 1.
        write(u'''
// c_5 == 0
''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""// y2 = y2 + cs_5*a_l
_checkfield_${vector.id}[$index] += _cs[5]*_alfield_${vector.id}[$index];
// a_l = g_1*a_i + g_2*a_k + g_3*a_j + g_4*y_1 + g_5*a_l + g_6*y2
_alfield_${vector.id}[$index] = _g[1]*_aifield_${vector.id}[$index] + _g[2]*_akfield_${vector.id}[$index] + _g[3]*_ajfield_${vector.id}[$index] + _g[4]*_${vector.id}[$index] + _g[5]*_alfield_${vector.id}[$index] + _g[6]*_checkfield_${vector.id}[$index];
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, rawExpr=u'${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""// y2 = y2 + cs_5*a_l\n_checkfield_${vector.id}[$index] += _cs[5]*_alfield_${vector.id}[$index];\n// a_l = g_1*a_i + g_2*a_k + g_3*a_j + g_4*y_1 + g_5*a_l + g_6*y2\n_alfield_${vector.id}[$index] = _g[1]*_aifield_${vector.id}[$index] + _g[2]*_akfield_${vector.id}[$index] + _g[3]*_ajfield_${vector.id}[$index] + _g[4]*_${vector.id}[$index] + _g[5]*_alfield_${vector.id}[$index] + _g[6]*_checkfield_${vector.id}[$index];\n""", basis = $homeBasis)}')) # from line 249, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 256, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 256, col 1.
        write(u''' += _a[6] * _step;

''')
        _v = VFFSL(SL,"callFunction",False)('nonconstantIPFields', arguments, _exponent = 5, parentFunction=function) # u"${callFunction('nonconstantIPFields', arguments, _exponent = 5, parentFunction=function)}" on line 258, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('nonconstantIPFields', arguments, _exponent = 5, parentFunction=function)}")) # from line 258, col 1.
        write(u'''

// a_l = D((a_6 - a_2)*dt)[a_l]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = -5, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = -5, parentFunction=function)}" on line 261, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = -5, parentFunction=function)}")) # from line 261, col 1.
        write(u'''

// a_l = G[a_l, t + aa_6*dt]
''')
        _v = VFFSL(SL,"callFunction",False)('deltaA', arguments, parentFunction=function) # u"${callFunction('deltaA', arguments, parentFunction=function)}" on line 264, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('deltaA', arguments, parentFunction=function)}")) # from line 264, col 1.
        write(u'''

// a_l = D(-(a_6 - a_2)*dt)[a_l]
''')
        _v = VFFSL(SL,"callFunction",False)('ipEvolve', arguments, _exponent = +5, parentFunction=function) # u"${callFunction('ipEvolve', arguments, _exponent = +5, parentFunction=function)}" on line 267, col 1
        if _v is not None: write(_filter(_v, rawExpr=u"${callFunction('ipEvolve', arguments, _exponent = +5, parentFunction=function)}")) # from line 267, col 1.
        write(u'''
''')
        _v = VFFSL(SL,"transformVectorsToBasis",False)(VFFSL(SL,"integrationVectors",True), VFFSL(SL,"homeBasis",True)) # u'${transformVectorsToBasis($integrationVectors, $homeBasis)}' on line 268, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${transformVectorsToBasis($integrationVectors, $homeBasis)}')) # from line 268, col 1.
        write(u'''
// c_5 == 0
''')
        _v = VFFSL(SL,"loopOverVectorsWithInnerContentTemplate",False)(VFFSL(SL,"integrationVectors",True),
"""// y1 = y1 + c_6*a_l
_${vector.id}[$index] += _c[6]*_alfield_${vector.id}[$index];
// y2 = y2 + cs_6*a_l
_checkfield_${vector.id}[$index] += _cs[6]*_alfield_${vector.id}[$index];
""", basis = VFFSL(SL,"homeBasis",True))
        if _v is not None: write(_filter(_v, rawExpr=u'${loopOverVectorsWithInnerContentTemplate($integrationVectors,\n"""// y1 = y1 + c_6*a_l\n_${vector.id}[$index] += _c[6]*_alfield_${vector.id}[$index];\n// y2 = y2 + cs_6*a_l\n_checkfield_${vector.id}[$index] += _cs[6]*_alfield_${vector.id}[$index];\n""", basis = $homeBasis)}')) # from line 271, col 1.
        write(u'''
// t -> t + dt
''')
        _v = VFFSL(SL,"propagationDimension",True) # u'${propagationDimension}' on line 279, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${propagationDimension}')) # from line 279, col 1.
        write(u''' -= _a[6]*_step;

''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 281, col 3
            write(u'''_active_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 282, col 9
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 282, col 9.
            write(u''' = _checkfield_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 282, col 36
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 282, col 36.
            write(u''';
''')
        write(u'''
''')
        for vector in VFFSL(SL,"integrationVectors",True): # generated from line 285, col 3
            write(u'''_active_''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 286, col 9
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 286, col 9.
            write(u''' = _''')
            _v = VFFSL(SL,"vector.id",True) # u'${vector.id}' on line 286, col 25
            if _v is not None: write(_filter(_v, rawExpr=u'${vector.id}')) # from line 286, col 25.
            write(u''';
''')
        write(u'''
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # RK45Stepper.tmpl
        # 
        # Created by Graham Dennis on 2007-11-16.
        # 
        # Copyright (c) 2007-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''




''')
        # 
        #   Single integration step (ARK45)
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    ipPropagationStepFractions = ['1.0', '4.0/5.0', '7.0/10.0', '2.0/5.0', '1.0/8.0']

    extraIntegrationArrayNames = ['akfield', 'aifield', 'ajfield', 'alfield', 'checkfield']

    errorFieldName = 'checkfield'

    resetFieldName = 'aifield'

    integrationOrder = 5.0

    _mainCheetahMethod_for_RK45Stepper= 'writeBody'

## END CLASS DEFINITION

if not hasattr(RK45Stepper, '_initCheetahAttributes'):
    templateAPIClass = getattr(RK45Stepper, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(RK45Stepper)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=RK45Stepper()).run()


