/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xfce-notify-log-gbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.xfce.Notifyd.Log
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XfceNotifyLogGBus
 * @title: XfceNotifyLogGBus
 * @short_description: Generated C code for the org.xfce.Notifyd.Log D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.xfce.Notifyd.Log ---- */

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_get_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_get_IN_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_get_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_get_OUT_ARG_entry =
{
  {
    -1,
    (gchar *) "entry",
    (gchar *) "(sxssssssa(ss)ib)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_get_OUT_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_get_OUT_ARG_entry.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_get =
{
  {
    -1,
    (gchar *) "Get",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_get_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_get_OUT_ARG_pointers,
    NULL
  },
  "handle-get",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_list_IN_ARG_start_after_id =
{
  {
    -1,
    (gchar *) "start_after_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_list_IN_ARG_count =
{
  {
    -1,
    (gchar *) "count",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_list_IN_ARG_only_unread =
{
  {
    -1,
    (gchar *) "only_unread",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_list_IN_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_list_IN_ARG_start_after_id.parent_struct,
  &_xfce_notify_log_gbus_method_info_list_IN_ARG_count.parent_struct,
  &_xfce_notify_log_gbus_method_info_list_IN_ARG_only_unread.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_list_OUT_ARG_entries =
{
  {
    -1,
    (gchar *) "entries",
    (gchar *) "a(sxssssssa(ss)ib)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_list_OUT_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_list_OUT_ARG_entries.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_list_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_has_unread_OUT_ARG_has_unread =
{
  {
    -1,
    (gchar *) "has_unread",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_has_unread_OUT_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_has_unread_OUT_ARG_has_unread.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_has_unread =
{
  {
    -1,
    (gchar *) "HasUnread",
    NULL,
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_has_unread_OUT_ARG_pointers,
    NULL
  },
  "handle-has-unread",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_get_app_id_counts_OUT_ARG_app_id_counts =
{
  {
    -1,
    (gchar *) "app_id_counts",
    (gchar *) "a{su}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_get_app_id_counts_OUT_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_get_app_id_counts_OUT_ARG_app_id_counts.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_get_app_id_counts =
{
  {
    -1,
    (gchar *) "GetAppIdCounts",
    NULL,
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_get_app_id_counts_OUT_ARG_pointers,
    NULL
  },
  "handle-get-app-id-counts",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_mark_read_IN_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_mark_read_IN_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_mark_read_IN_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_mark_read =
{
  {
    -1,
    (gchar *) "MarkRead",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_mark_read_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-mark-read",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_mark_all_read =
{
  {
    -1,
    (gchar *) "MarkAllRead",
    NULL,
    NULL,
    NULL
  },
  "handle-mark-all-read",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_delete_IN_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_delete_IN_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_delete_IN_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_method_info_truncate_IN_ARG_entries_to_keep =
{
  {
    -1,
    (gchar *) "entries_to_keep",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_method_info_truncate_IN_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_truncate_IN_ARG_entries_to_keep.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_truncate =
{
  {
    -1,
    (gchar *) "Truncate",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_method_info_truncate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-truncate",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfce_notify_log_gbus_method_info_clear =
{
  {
    -1,
    (gchar *) "Clear",
    NULL,
    NULL,
    NULL
  },
  "handle-clear",
  FALSE
};

static const GDBusMethodInfo * const _xfce_notify_log_gbus_method_info_pointers[] =
{
  &_xfce_notify_log_gbus_method_info_get.parent_struct,
  &_xfce_notify_log_gbus_method_info_list.parent_struct,
  &_xfce_notify_log_gbus_method_info_has_unread.parent_struct,
  &_xfce_notify_log_gbus_method_info_get_app_id_counts.parent_struct,
  &_xfce_notify_log_gbus_method_info_mark_read.parent_struct,
  &_xfce_notify_log_gbus_method_info_mark_all_read.parent_struct,
  &_xfce_notify_log_gbus_method_info_delete.parent_struct,
  &_xfce_notify_log_gbus_method_info_truncate.parent_struct,
  &_xfce_notify_log_gbus_method_info_clear.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_signal_info_row_added_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_signal_info_row_added_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_signal_info_row_added_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfce_notify_log_gbus_signal_info_row_added =
{
  {
    -1,
    (gchar *) "RowAdded",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_signal_info_row_added_ARG_pointers,
    NULL
  },
  "row-added"
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_signal_info_row_changed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_signal_info_row_changed_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_signal_info_row_changed_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfce_notify_log_gbus_signal_info_row_changed =
{
  {
    -1,
    (gchar *) "RowChanged",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_signal_info_row_changed_ARG_pointers,
    NULL
  },
  "row-changed"
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_signal_info_row_deleted_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_signal_info_row_deleted_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_signal_info_row_deleted_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfce_notify_log_gbus_signal_info_row_deleted =
{
  {
    -1,
    (gchar *) "RowDeleted",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_signal_info_row_deleted_ARG_pointers,
    NULL
  },
  "row-deleted"
};

static const _ExtendedGDBusArgInfo _xfce_notify_log_gbus_signal_info_truncated_ARG_n_entries_kept =
{
  {
    -1,
    (gchar *) "n_entries_kept",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfce_notify_log_gbus_signal_info_truncated_ARG_pointers[] =
{
  &_xfce_notify_log_gbus_signal_info_truncated_ARG_n_entries_kept.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfce_notify_log_gbus_signal_info_truncated =
{
  {
    -1,
    (gchar *) "Truncated",
    (GDBusArgInfo **) &_xfce_notify_log_gbus_signal_info_truncated_ARG_pointers,
    NULL
  },
  "truncated"
};

static const _ExtendedGDBusSignalInfo _xfce_notify_log_gbus_signal_info_cleared =
{
  {
    -1,
    (gchar *) "Cleared",
    NULL,
    NULL
  },
  "cleared"
};

static const GDBusSignalInfo * const _xfce_notify_log_gbus_signal_info_pointers[] =
{
  &_xfce_notify_log_gbus_signal_info_row_added.parent_struct,
  &_xfce_notify_log_gbus_signal_info_row_changed.parent_struct,
  &_xfce_notify_log_gbus_signal_info_row_deleted.parent_struct,
  &_xfce_notify_log_gbus_signal_info_truncated.parent_struct,
  &_xfce_notify_log_gbus_signal_info_cleared.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xfce_notify_log_gbus_interface_info =
{
  {
    -1,
    (gchar *) "org.xfce.Notifyd.Log",
    (GDBusMethodInfo **) &_xfce_notify_log_gbus_method_info_pointers,
    (GDBusSignalInfo **) &_xfce_notify_log_gbus_signal_info_pointers,
    NULL,
    NULL
  },
  "notify-log-gbus",
};


/**
 * xfce_notify_log_gbus_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xfce_notify_log_gbus_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xfce_notify_log_gbus_interface_info.parent_struct;
}

/**
 * xfce_notify_log_gbus_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XfceNotifyLogGBus interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xfce_notify_log_gbus_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XfceNotifyLogGBus:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link>.
 */

/**
 * XfceNotifyLogGBusIface:
 * @parent_iface: The parent interface.
 * @handle_clear: Handler for the #XfceNotifyLogGBus::handle-clear signal.
 * @handle_delete: Handler for the #XfceNotifyLogGBus::handle-delete signal.
 * @handle_get: Handler for the #XfceNotifyLogGBus::handle-get signal.
 * @handle_get_app_id_counts: Handler for the #XfceNotifyLogGBus::handle-get-app-id-counts signal.
 * @handle_has_unread: Handler for the #XfceNotifyLogGBus::handle-has-unread signal.
 * @handle_list: Handler for the #XfceNotifyLogGBus::handle-list signal.
 * @handle_mark_all_read: Handler for the #XfceNotifyLogGBus::handle-mark-all-read signal.
 * @handle_mark_read: Handler for the #XfceNotifyLogGBus::handle-mark-read signal.
 * @handle_truncate: Handler for the #XfceNotifyLogGBus::handle-truncate signal.
 * @cleared: Handler for the #XfceNotifyLogGBus::cleared signal.
 * @row_added: Handler for the #XfceNotifyLogGBus::row-added signal.
 * @row_changed: Handler for the #XfceNotifyLogGBus::row-changed signal.
 * @row_deleted: Handler for the #XfceNotifyLogGBus::row-deleted signal.
 * @truncated: Handler for the #XfceNotifyLogGBus::truncated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link>.
 */

typedef XfceNotifyLogGBusIface XfceNotifyLogGBusInterface;
G_DEFINE_INTERFACE (XfceNotifyLogGBus, xfce_notify_log_gbus, G_TYPE_OBJECT)

static void
xfce_notify_log_gbus_default_init (XfceNotifyLogGBusIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XfceNotifyLogGBus::handle-get:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Get">Get()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_get() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_get),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XfceNotifyLogGBus::handle-list:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_start_after_id: Argument passed by remote caller.
   * @arg_count: Argument passed by remote caller.
   * @arg_only_unread: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_BOOLEAN);

  /**
   * XfceNotifyLogGBus::handle-has-unread:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.HasUnread">HasUnread()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_has_unread() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-has-unread",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_has_unread),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfceNotifyLogGBus::handle-get-app-id-counts:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.GetAppIdCounts">GetAppIdCounts()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_get_app_id_counts() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-app-id-counts",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_get_app_id_counts),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfceNotifyLogGBus::handle-mark-read:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_ids: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkRead">MarkRead()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_mark_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mark-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_mark_read),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * XfceNotifyLogGBus::handle-mark-all-read:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkAllRead">MarkAllRead()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_mark_all_read() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-mark-all-read",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_mark_all_read),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfceNotifyLogGBus::handle-delete:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_ids: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * XfceNotifyLogGBus::handle-truncate:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_entries_to_keep: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Truncate">Truncate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_truncate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-truncate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_truncate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * XfceNotifyLogGBus::handle-clear:
   * @object: A #XfceNotifyLogGBus.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Clear">Clear()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfce_notify_log_gbus_complete_clear() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clear",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, handle_clear),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * XfceNotifyLogGBus::row-added:
   * @object: A #XfceNotifyLogGBus.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Notifyd-Log.RowAdded">"RowAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("row-added",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, row_added),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * XfceNotifyLogGBus::row-changed:
   * @object: A #XfceNotifyLogGBus.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Notifyd-Log.RowChanged">"RowChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("row-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, row_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * XfceNotifyLogGBus::row-deleted:
   * @object: A #XfceNotifyLogGBus.
   * @arg_id: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Notifyd-Log.RowDeleted">"RowDeleted"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("row-deleted",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, row_deleted),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * XfceNotifyLogGBus::truncated:
   * @object: A #XfceNotifyLogGBus.
   * @arg_n_entries_kept: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Notifyd-Log.Truncated">"Truncated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("truncated",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, truncated),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UINT);

  /**
   * XfceNotifyLogGBus::cleared:
   * @object: A #XfceNotifyLogGBus.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Notifyd-Log.Cleared">"Cleared"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("cleared",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfceNotifyLogGBusIface, cleared),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * xfce_notify_log_gbus_emit_row_added:
 * @object: A #XfceNotifyLogGBus.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Notifyd-Log.RowAdded">"RowAdded"</link> D-Bus signal.
 */
void
xfce_notify_log_gbus_emit_row_added (
    XfceNotifyLogGBus *object,
    const gchar *arg_id)
{
  g_signal_emit_by_name (object, "row-added", arg_id);
}

/**
 * xfce_notify_log_gbus_emit_row_changed:
 * @object: A #XfceNotifyLogGBus.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Notifyd-Log.RowChanged">"RowChanged"</link> D-Bus signal.
 */
void
xfce_notify_log_gbus_emit_row_changed (
    XfceNotifyLogGBus *object,
    const gchar *arg_id)
{
  g_signal_emit_by_name (object, "row-changed", arg_id);
}

/**
 * xfce_notify_log_gbus_emit_row_deleted:
 * @object: A #XfceNotifyLogGBus.
 * @arg_id: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Notifyd-Log.RowDeleted">"RowDeleted"</link> D-Bus signal.
 */
void
xfce_notify_log_gbus_emit_row_deleted (
    XfceNotifyLogGBus *object,
    const gchar *arg_id)
{
  g_signal_emit_by_name (object, "row-deleted", arg_id);
}

/**
 * xfce_notify_log_gbus_emit_truncated:
 * @object: A #XfceNotifyLogGBus.
 * @arg_n_entries_kept: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Notifyd-Log.Truncated">"Truncated"</link> D-Bus signal.
 */
void
xfce_notify_log_gbus_emit_truncated (
    XfceNotifyLogGBus *object,
    guint arg_n_entries_kept)
{
  g_signal_emit_by_name (object, "truncated", arg_n_entries_kept);
}

/**
 * xfce_notify_log_gbus_emit_cleared:
 * @object: A #XfceNotifyLogGBus.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Notifyd-Log.Cleared">"Cleared"</link> D-Bus signal.
 */
void
xfce_notify_log_gbus_emit_cleared (
    XfceNotifyLogGBus *object)
{
  g_signal_emit_by_name (object, "cleared");
}

/**
 * xfce_notify_log_gbus_call_get:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Get">Get()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_get_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_get_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_get (
    XfceNotifyLogGBus *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Get",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_get_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @out_entry: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_get().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_get().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_get_finish (
    XfceNotifyLogGBus *proxy,
    GVariant **out_entry,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(sxssssssa(ss)ib))",
                 out_entry);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_get_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @out_entry: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Get">Get()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_get() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_get_sync (
    XfceNotifyLogGBus *proxy,
    const gchar *arg_id,
    GVariant **out_entry,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Get",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@(sxssssssa(ss)ib))",
                 out_entry);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_list:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_start_after_id: Argument to pass with the method invocation.
 * @arg_count: Argument to pass with the method invocation.
 * @arg_only_unread: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_list_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_list_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_list (
    XfceNotifyLogGBus *proxy,
    const gchar *arg_start_after_id,
    guint arg_count,
    gboolean arg_only_unread,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(sub)",
                   arg_start_after_id,
                   arg_count,
                   arg_only_unread),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_list_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @out_entries: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_list_finish (
    XfceNotifyLogGBus *proxy,
    GVariant **out_entries,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sxssssssa(ss)ib))",
                 out_entries);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_list_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_start_after_id: Argument to pass with the method invocation.
 * @arg_count: Argument to pass with the method invocation.
 * @arg_only_unread: Argument to pass with the method invocation.
 * @out_entries: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_list_sync (
    XfceNotifyLogGBus *proxy,
    const gchar *arg_start_after_id,
    guint arg_count,
    gboolean arg_only_unread,
    GVariant **out_entries,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(sub)",
                   arg_start_after_id,
                   arg_count,
                   arg_only_unread),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(sxssssssa(ss)ib))",
                 out_entries);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_has_unread:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.HasUnread">HasUnread()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_has_unread_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_has_unread_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_has_unread (
    XfceNotifyLogGBus *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HasUnread",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_has_unread_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @out_has_unread: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_has_unread().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_has_unread().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_has_unread_finish (
    XfceNotifyLogGBus *proxy,
    gboolean *out_has_unread,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_has_unread);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_has_unread_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @out_has_unread: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.HasUnread">HasUnread()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_has_unread() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_has_unread_sync (
    XfceNotifyLogGBus *proxy,
    gboolean *out_has_unread,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HasUnread",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_has_unread);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_get_app_id_counts:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.GetAppIdCounts">GetAppIdCounts()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_get_app_id_counts_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_get_app_id_counts_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_get_app_id_counts (
    XfceNotifyLogGBus *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAppIdCounts",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_get_app_id_counts_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @out_app_id_counts: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_get_app_id_counts().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_get_app_id_counts().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_get_app_id_counts_finish (
    XfceNotifyLogGBus *proxy,
    GVariant **out_app_id_counts,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{su})",
                 out_app_id_counts);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_get_app_id_counts_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @out_app_id_counts: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.GetAppIdCounts">GetAppIdCounts()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_get_app_id_counts() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_get_app_id_counts_sync (
    XfceNotifyLogGBus *proxy,
    GVariant **out_app_id_counts,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAppIdCounts",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{su})",
                 out_app_id_counts);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_mark_read:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkRead">MarkRead()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_mark_read_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_mark_read_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_mark_read (
    XfceNotifyLogGBus *proxy,
    const gchar *const *arg_ids,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MarkRead",
    g_variant_new ("(^as)",
                   arg_ids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_mark_read_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_mark_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_mark_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_mark_read_finish (
    XfceNotifyLogGBus *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_mark_read_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkRead">MarkRead()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_mark_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_mark_read_sync (
    XfceNotifyLogGBus *proxy,
    const gchar *const *arg_ids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MarkRead",
    g_variant_new ("(^as)",
                   arg_ids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_mark_all_read:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkAllRead">MarkAllRead()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_mark_all_read_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_mark_all_read_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_mark_all_read (
    XfceNotifyLogGBus *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MarkAllRead",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_mark_all_read_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_mark_all_read().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_mark_all_read().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_mark_all_read_finish (
    XfceNotifyLogGBus *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_mark_all_read_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkAllRead">MarkAllRead()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_mark_all_read() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_mark_all_read_sync (
    XfceNotifyLogGBus *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MarkAllRead",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_delete:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_delete_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_delete (
    XfceNotifyLogGBus *proxy,
    const gchar *const *arg_ids,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(^as)",
                   arg_ids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_delete_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_delete_finish (
    XfceNotifyLogGBus *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_delete_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_ids: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_delete_sync (
    XfceNotifyLogGBus *proxy,
    const gchar *const *arg_ids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(^as)",
                   arg_ids),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_truncate:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_entries_to_keep: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Truncate">Truncate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_truncate_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_truncate_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_truncate (
    XfceNotifyLogGBus *proxy,
    guint arg_entries_to_keep,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Truncate",
    g_variant_new ("(u)",
                   arg_entries_to_keep),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_truncate_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_truncate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_truncate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_truncate_finish (
    XfceNotifyLogGBus *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_truncate_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @arg_entries_to_keep: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Truncate">Truncate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_truncate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_truncate_sync (
    XfceNotifyLogGBus *proxy,
    guint arg_entries_to_keep,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Truncate",
    g_variant_new ("(u)",
                   arg_entries_to_keep),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_clear:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Clear">Clear()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_call_clear_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_call_clear_sync() for the synchronous, blocking version of this method.
 */
void
xfce_notify_log_gbus_call_clear (
    XfceNotifyLogGBus *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Clear",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfce_notify_log_gbus_call_clear_finish:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_call_clear().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfce_notify_log_gbus_call_clear().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_clear_finish (
    XfceNotifyLogGBus *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_call_clear_sync:
 * @proxy: A #XfceNotifyLogGBusProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Clear">Clear()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_call_clear() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfce_notify_log_gbus_call_clear_sync (
    XfceNotifyLogGBus *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Clear",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfce_notify_log_gbus_complete_get:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @entry: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Get">Get()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_get (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *entry)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@(sxssssssa(ss)ib))",
                   entry));
}

/**
 * xfce_notify_log_gbus_complete_list:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @entries: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_list (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *entries)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(sxssssssa(ss)ib))",
                   entries));
}

/**
 * xfce_notify_log_gbus_complete_has_unread:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @has_unread: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.HasUnread">HasUnread()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_has_unread (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean has_unread)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   has_unread));
}

/**
 * xfce_notify_log_gbus_complete_get_app_id_counts:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @app_id_counts: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.GetAppIdCounts">GetAppIdCounts()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_get_app_id_counts (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *app_id_counts)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{su})",
                   app_id_counts));
}

/**
 * xfce_notify_log_gbus_complete_mark_read:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkRead">MarkRead()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_mark_read (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfce_notify_log_gbus_complete_mark_all_read:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.MarkAllRead">MarkAllRead()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_mark_all_read (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfce_notify_log_gbus_complete_delete:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_delete (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfce_notify_log_gbus_complete_truncate:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Truncate">Truncate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_truncate (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfce_notify_log_gbus_complete_clear:
 * @object: A #XfceNotifyLogGBus.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Notifyd-Log.Clear">Clear()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfce_notify_log_gbus_complete_clear (
    XfceNotifyLogGBus *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XfceNotifyLogGBusProxy:
 *
 * The #XfceNotifyLogGBusProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfceNotifyLogGBusProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfceNotifyLogGBusProxy.
 */

struct _XfceNotifyLogGBusProxyPrivate
{
  GData *qdata;
};

static void xfce_notify_log_gbus_proxy_iface_init (XfceNotifyLogGBusIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfceNotifyLogGBusProxy, xfce_notify_log_gbus_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XfceNotifyLogGBusProxy)
                         G_IMPLEMENT_INTERFACE (XFCE_TYPE_NOTIFY_LOG_GBUS, xfce_notify_log_gbus_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfceNotifyLogGBusProxy, xfce_notify_log_gbus_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XFCE_TYPE_NOTIFY_LOG_GBUS, xfce_notify_log_gbus_proxy_iface_init))

#endif
static void
xfce_notify_log_gbus_proxy_finalize (GObject *object)
{
  XfceNotifyLogGBusProxy *proxy = XFCE_NOTIFY_LOG_GBUS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xfce_notify_log_gbus_proxy_parent_class)->finalize (object);
}

static void
xfce_notify_log_gbus_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfce_notify_log_gbus_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfce_notify_log_gbus_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xfce_notify_log_gbus_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XFCE_TYPE_NOTIFY_LOG_GBUS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFCE_TYPE_NOTIFY_LOG_GBUS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xfce_notify_log_gbus_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XfceNotifyLogGBusProxy *proxy = XFCE_NOTIFY_LOG_GBUS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfce_notify_log_gbus_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfce_notify_log_gbus_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xfce_notify_log_gbus_proxy_init (XfceNotifyLogGBusProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xfce_notify_log_gbus_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XFCE_TYPE_NOTIFY_LOG_GBUS_PROXY, XfceNotifyLogGBusProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xfce_notify_log_gbus_interface_info ());
}

static void
xfce_notify_log_gbus_proxy_class_init (XfceNotifyLogGBusProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xfce_notify_log_gbus_proxy_finalize;
  gobject_class->get_property = xfce_notify_log_gbus_proxy_get_property;
  gobject_class->set_property = xfce_notify_log_gbus_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xfce_notify_log_gbus_proxy_g_signal;
  proxy_class->g_properties_changed = xfce_notify_log_gbus_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfceNotifyLogGBusProxyPrivate));
#endif
}

static void
xfce_notify_log_gbus_proxy_iface_init (XfceNotifyLogGBusIface *iface G_GNUC_UNUSED)
{
}

/**
 * xfce_notify_log_gbus_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_proxy_new_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xfce_notify_log_gbus_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFCE_TYPE_NOTIFY_LOG_GBUS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Notifyd.Log", NULL);
}

/**
 * xfce_notify_log_gbus_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfce_notify_log_gbus_proxy_new().
 *
 * Returns: (transfer full) (type XfceNotifyLogGBusProxy): The constructed proxy object or %NULL if @error is set.
 */
XfceNotifyLogGBus *
xfce_notify_log_gbus_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFCE_NOTIFY_LOG_GBUS (ret);
  else
    return NULL;
}

/**
 * xfce_notify_log_gbus_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfceNotifyLogGBusProxy): The constructed proxy object or %NULL if @error is set.
 */
XfceNotifyLogGBus *
xfce_notify_log_gbus_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFCE_TYPE_NOTIFY_LOG_GBUS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Notifyd.Log", NULL);
  if (ret != NULL)
    return XFCE_NOTIFY_LOG_GBUS (ret);
  else
    return NULL;
}


/**
 * xfce_notify_log_gbus_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xfce_notify_log_gbus_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfce_notify_log_gbus_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xfce_notify_log_gbus_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xfce_notify_log_gbus_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFCE_TYPE_NOTIFY_LOG_GBUS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Notifyd.Log", NULL);
}

/**
 * xfce_notify_log_gbus_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfce_notify_log_gbus_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfce_notify_log_gbus_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XfceNotifyLogGBusProxy): The constructed proxy object or %NULL if @error is set.
 */
XfceNotifyLogGBus *
xfce_notify_log_gbus_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFCE_NOTIFY_LOG_GBUS (ret);
  else
    return NULL;
}

/**
 * xfce_notify_log_gbus_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xfce_notify_log_gbus_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfce_notify_log_gbus_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfceNotifyLogGBusProxy): The constructed proxy object or %NULL if @error is set.
 */
XfceNotifyLogGBus *
xfce_notify_log_gbus_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFCE_TYPE_NOTIFY_LOG_GBUS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Notifyd.Log", NULL);
  if (ret != NULL)
    return XFCE_NOTIFY_LOG_GBUS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XfceNotifyLogGBusSkeleton:
 *
 * The #XfceNotifyLogGBusSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfceNotifyLogGBusSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfceNotifyLogGBusSkeleton.
 */

struct _XfceNotifyLogGBusSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xfce_notify_log_gbus_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XFCE_TYPE_NOTIFY_LOG_GBUS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFCE_TYPE_NOTIFY_LOG_GBUS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xfce_notify_log_gbus_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfce_notify_log_gbus_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xfce_notify_log_gbus_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfce_notify_log_gbus_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xfce_notify_log_gbus_skeleton_vtable =
{
  _xfce_notify_log_gbus_skeleton_handle_method_call,
  _xfce_notify_log_gbus_skeleton_handle_get_property,
  _xfce_notify_log_gbus_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xfce_notify_log_gbus_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xfce_notify_log_gbus_interface_info ();
}

static GDBusInterfaceVTable *
xfce_notify_log_gbus_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xfce_notify_log_gbus_skeleton_vtable;
}

static GVariant *
xfce_notify_log_gbus_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xfce_notify_log_gbus_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xfce_notify_log_gbus_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xfce_notify_log_gbus_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xfce_notify_log_gbus_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Notifyd.Log", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xfce_notify_log_gbus_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xfce_notify_log_gbus_on_signal_row_added (
    XfceNotifyLogGBus *object,
    const gchar *arg_id)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Notifyd.Log", "RowAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfce_notify_log_gbus_on_signal_row_changed (
    XfceNotifyLogGBus *object,
    const gchar *arg_id)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Notifyd.Log", "RowChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfce_notify_log_gbus_on_signal_row_deleted (
    XfceNotifyLogGBus *object,
    const gchar *arg_id)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_id));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Notifyd.Log", "RowDeleted",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfce_notify_log_gbus_on_signal_truncated (
    XfceNotifyLogGBus *object,
    guint arg_n_entries_kept)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u)",
                   arg_n_entries_kept));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Notifyd.Log", "Truncated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfce_notify_log_gbus_on_signal_cleared (
    XfceNotifyLogGBus *object)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Notifyd.Log", "Cleared",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xfce_notify_log_gbus_skeleton_iface_init (XfceNotifyLogGBusIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfceNotifyLogGBusSkeleton, xfce_notify_log_gbus_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XfceNotifyLogGBusSkeleton)
                         G_IMPLEMENT_INTERFACE (XFCE_TYPE_NOTIFY_LOG_GBUS, xfce_notify_log_gbus_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfceNotifyLogGBusSkeleton, xfce_notify_log_gbus_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XFCE_TYPE_NOTIFY_LOG_GBUS, xfce_notify_log_gbus_skeleton_iface_init))

#endif
static void
xfce_notify_log_gbus_skeleton_finalize (GObject *object)
{
  XfceNotifyLogGBusSkeleton *skeleton = XFCE_NOTIFY_LOG_GBUS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xfce_notify_log_gbus_skeleton_parent_class)->finalize (object);
}

static void
xfce_notify_log_gbus_skeleton_init (XfceNotifyLogGBusSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xfce_notify_log_gbus_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XFCE_TYPE_NOTIFY_LOG_GBUS_SKELETON, XfceNotifyLogGBusSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xfce_notify_log_gbus_skeleton_class_init (XfceNotifyLogGBusSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xfce_notify_log_gbus_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xfce_notify_log_gbus_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xfce_notify_log_gbus_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xfce_notify_log_gbus_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xfce_notify_log_gbus_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfceNotifyLogGBusSkeletonPrivate));
#endif
}

static void
xfce_notify_log_gbus_skeleton_iface_init (XfceNotifyLogGBusIface *iface)
{
  iface->row_added = _xfce_notify_log_gbus_on_signal_row_added;
  iface->row_changed = _xfce_notify_log_gbus_on_signal_row_changed;
  iface->row_deleted = _xfce_notify_log_gbus_on_signal_row_deleted;
  iface->truncated = _xfce_notify_log_gbus_on_signal_truncated;
  iface->cleared = _xfce_notify_log_gbus_on_signal_cleared;
}

/**
 * xfce_notify_log_gbus_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Notifyd-Log.top_of_page">org.xfce.Notifyd.Log</link>.
 *
 * Returns: (transfer full) (type XfceNotifyLogGBusSkeleton): The skeleton object.
 */
XfceNotifyLogGBus *
xfce_notify_log_gbus_skeleton_new (void)
{
  return XFCE_NOTIFY_LOG_GBUS (g_object_new (XFCE_TYPE_NOTIFY_LOG_GBUS_SKELETON, NULL));
}

