/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.draw;

import edu.hws.jcm.awt.Controller;
import edu.hws.jcm.awt.InputObject;
import edu.hws.jcm.awt.Tie;
import edu.hws.jcm.awt.Tieable;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Value;
import edu.hws.jcm.data.ValueMath;
import edu.hws.jcm.data.Variable;
import edu.hws.jcm.draw.Draggable;
import edu.hws.jcm.draw.Drawable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class DraggablePoint
extends Drawable
implements InputObject,
Draggable {
    public static final int DISK = 0;
    public static final int SQUARE = 1;
    public static final int CROSS = 2;
    private int radius;
    private Color color;
    private Color ghostColor;
    private int style;
    private double xLoc;
    private double yLoc;
    private int xPosition;
    private int yPosition;
    private boolean useGhost;
    private DPV xVar;
    private DPV yVar;
    private Controller onUserAction;
    private Value clampX;
    private Value clampY;
    private boolean dragging;

    public DraggablePoint() {
        this(0);
    }

    public DraggablePoint(int n) {
        if (n >= 0 && n <= 2) {
            this.style = n;
        }
        this.setColor(Color.darkGray);
        this.setGhostColor(Color.lightGray);
        this.radius = 4;
        this.xPosition = -10000;
        this.xLoc = Double.NaN;
        this.yLoc = Double.NaN;
        this.xVar = new DPV(true);
        this.yVar = new DPV(false);
    }

    public void clampX(Value value) {
        this.clampX = value;
        if (value != null) {
            this.clampY = null;
        }
        this.checkClamp();
        this.needsRedraw();
    }

    public void clampY(Value value) {
        this.clampY = value;
        if (value != null) {
            this.clampX = null;
        }
        this.checkClamp();
        this.needsRedraw();
    }

    public void clampX(double d) {
        this.clampX(new Constant(d));
    }

    public void clampY(double d) {
        this.clampY(new Constant(d));
    }

    public void clampX(Function function) {
        if (function != null) {
            this.clampX(new ValueMath(function, this.xVar));
        }
    }

    public void clampY(Function function) {
        if (function != null) {
            this.clampY(new ValueMath(function, this.xVar));
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        if (n > 0) {
            this.radius = n;
            this.needsRedraw();
        }
    }

    public void setStyle(int n) {
        if (n >= 0 && n <= 2) {
            this.style = n;
            this.needsRedraw();
        }
    }

    public int getStyle() {
        return this.style;
    }

    public Variable getXVar() {
        return this.xVar;
    }

    public Variable getYVar() {
        return this.yVar;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
            this.needsRedraw();
        }
    }

    public Color getGhostColor() {
        return this.ghostColor;
    }

    public void setGhostColor(Color color) {
        if (color != null) {
            this.ghostColor = color;
            this.needsRedraw();
        }
    }

    public void setOnUserAction(Controller controller) {
        this.onUserAction = controller;
    }

    public void notifyControllerOnChange(Controller controller) {
        this.setOnUserAction(controller);
    }

    public Controller getOnUserAction(Controller controller) {
        return this.onUserAction;
    }

    public void setLocation(double d, double d2) {
        this.xLoc = d;
        this.yLoc = d2;
        this.xVar.setVariableValue(d);
        this.yVar.setVariableValue(d2);
        ++this.xVar.serialNumber;
        ++this.yVar.serialNumber;
        this.checkClamp();
        this.needsRedraw();
    }

    private void checkClamp() {
        if (this.clampX != null) {
            this.xLoc = this.clampX.getVal();
            this.xVar.setVariableValue(this.xLoc);
        } else if (this.clampY != null) {
            this.yLoc = this.clampY.getVal();
            this.yVar.setVariableValue(this.yLoc);
        }
    }

    public void checkInput() {
        this.xVar.needsClamp = true;
        this.yVar.needsClamp = true;
    }

    public void draw(Graphics graphics, boolean bl) {
        if (this.coords == null) {
            return;
        }
        this.checkPosition();
        if (this.useGhost) {
            graphics.setColor(this.getGhostColor());
        } else {
            graphics.setColor(this.color);
        }
        switch (this.style) {
            case 0: {
                graphics.fillOval(this.xPosition - this.radius, this.yPosition - this.radius, 2 * this.radius + 1, 2 * this.radius + 1);
                break;
            }
            case 1: {
                graphics.fillRect(this.xPosition - this.radius, this.yPosition - this.radius, 2 * this.radius + 1, 2 * this.radius + 1);
                break;
            }
            case 2: {
                graphics.drawLine(this.xPosition - this.radius, this.yPosition, this.xPosition + this.radius, this.yPosition);
                graphics.drawLine(this.xPosition, this.yPosition - this.radius, this.xPosition, this.yPosition + this.radius);
            }
        }
    }

    private void checkPosition() {
        this.useGhost = false;
        this.xVar.getVal();
        this.yVar.getVal();
        if (Double.isNaN(this.xLoc) || Double.isNaN(this.yLoc)) {
            if (this.xPosition == -10000) {
                this.xPosition = this.coords.getLeft() + this.coords.getWidth() / 2;
                this.yPosition = this.coords.getTop() + this.coords.getHeight() / 2;
            }
            this.useGhost = true;
        } else {
            this.xPosition = this.coords.xToPixel(this.xLoc);
            this.yPosition = this.coords.yToPixel(this.yLoc);
        }
        if (this.xPosition <= this.coords.getLeft()) {
            this.useGhost = true;
            this.xPosition = this.coords.getLeft() + 1;
        } else if (this.xPosition >= this.coords.getLeft() + this.coords.getWidth()) {
            this.useGhost = true;
            this.xPosition = this.coords.getLeft() + this.coords.getWidth() - 1;
        }
        if (this.yPosition <= this.coords.getTop()) {
            this.useGhost = true;
            this.yPosition = this.coords.getTop() + 1;
        } else if (this.yPosition >= this.coords.getTop() + this.coords.getHeight()) {
            this.useGhost = true;
            this.yPosition = this.coords.getTop() + this.coords.getHeight() - 1;
        }
    }

    public boolean startDrag(MouseEvent mouseEvent) {
        this.dragging = false;
        if (mouseEvent.isConsumed() || !this.getVisible() || this.coords == null) {
            return false;
        }
        this.checkPosition();
        if (mouseEvent.getX() < this.xPosition - this.radius || mouseEvent.getX() >= this.xPosition + this.radius || mouseEvent.getY() < this.yPosition - this.radius || mouseEvent.getY() >= this.yPosition + this.radius) {
            return false;
        }
        this.dragging = true;
        mouseEvent.consume();
        return true;
    }

    public void continueDrag(MouseEvent mouseEvent) {
        if (!this.dragging) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        double d = this.coords.pixelToX(mouseEvent.getX());
        double d2 = this.coords.pixelToY(mouseEvent.getY());
        if (d < this.coords.getXmin()) {
            d = this.coords.getXmin();
        } else if (d > this.coords.getXmax()) {
            d = this.coords.getXmax();
        }
        if (d2 < this.coords.getYmin()) {
            d2 = this.coords.getYmin();
        } else if (d2 > this.coords.getYmax()) {
            d2 = this.coords.getYmax();
        }
        this.setLocation(d, d2);
        if (Double.isNaN(this.xLoc) || Double.isNaN(this.yLoc)) {
            this.xPosition = n;
            this.yPosition = n2;
        }
        if (this.onUserAction != null) {
            this.onUserAction.compute();
        }
    }

    public void finishDrag(MouseEvent mouseEvent) {
        this.dragging = false;
    }

    private class DPV
    extends Variable
    implements Tieable {
        private boolean isXVar;
        long serialNumber;
        boolean needsClamp;

        DPV(boolean bl) {
            super(bl ? "xDrag" : "yDrag");
            this.isXVar = bl;
            super.setVal(Double.NaN);
        }

        public double getVal() {
            if (this.needsClamp) {
                if (this.isXVar) {
                    if (DraggablePoint.this.clampX != null) {
                        DraggablePoint.this.xLoc = DraggablePoint.this.clampX.getVal();
                        this.setVariableValue(DraggablePoint.this.xLoc);
                    }
                } else if (DraggablePoint.this.clampY != null) {
                    DraggablePoint.this.yLoc = DraggablePoint.this.clampY.getVal();
                    this.setVariableValue(DraggablePoint.this.yLoc);
                }
                this.needsClamp = false;
            }
            return super.getVal();
        }

        public void setVal(double d) {
            if (this.isXVar) {
                DraggablePoint.this.setLocation(d, DraggablePoint.this.yVar.getVal());
            } else {
                DraggablePoint.this.setLocation(DraggablePoint.this.xVar.getVal(), d);
            }
        }

        void setVariableValue(double d) {
            super.setVal(d);
            this.needsClamp = false;
        }

        public long getSerialNumber() {
            return this.serialNumber;
        }

        public void sync(Tie tie, Tieable tieable) {
            if (!(tieable instanceof Value)) {
                throw new IllegalArgumentException("Internal Error:  A MouseTracker variable can only be tied to a Value object.");
            }
            if (tieable != this) {
                this.setVal(((Value)((Object)tieable)).getVal());
                this.serialNumber = tieable.getSerialNumber();
            }
        }
    }
}

