/**
 * Sum.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente le quotient de deux fonctions.
 *
 * @author Nicolae
 */
public class Quotient extends DefaultMap {

	private Map f;
	private Map g;

	private double[] v1 = new double[2]; 
	private double[] v2 = new double[2]; 
	
	/**
	 * Cache le constructor standard.
	 */
	private Quotient() {}
	
	/**
	 * Constructor qui initialise les deux applications.
	 *
	 * @param f application.
	 * @param f application.
	 */
	public Quotient(Map f, Map g) {
		this.f = f;
		this.g = g;
	}

	/* (non-Javadoc)
	 * @see maths.DefaultMap#apply()
	 * (a+ib)/(c+id)=(ac+bd+i(bc-ad))/(c^2+d^2)
	 */
	protected void apply() {
		f.value(x, y, v1);
		g.value(x, y, v2);
		double r = v2[0] * v2[0] + v2[1] * v2[1];		

		fx = v1[0] * v2[0] + v1[1] * v2[1];
		fy = v1[1] * v2[0] - v1[0] * v2[1];
		
		if(r > 0) {
			fx /= r;
			fy /= r;
		} else {
			fx = inf(v1[0]);
			fy = inf(v1[1]);
		}
	}

	private double inf(double fx) {		
		return fx < 0 ? Double.NEGATIVE_INFINITY : 
			            fx > 0 ? Double.POSITIVE_INFINITY : 0;
	}

	/* (non-Javadoc)
	 * @see maths.DefaultMap#inverse()
	 */
	public Map[] inverse() {
		return null;
	}

	public void compDiff() {
		Map df = f.differential();
		Map dg = g.differential();
		
		if(df == null || dg == null)
			der = null;
		else {		
			Map fdg = new Product(f, dg);
			Map dfg = new Product(df, g);
			Map up = new Diff(dfg, fdg);
			Map down = new Product(g, g);
			
			der = new Quotient(up, down);
		}
	}
}
