/*
 * Copyright (C) 2009, 2012 by the Widelands Development Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef EDITOR_SET_ORIGIN_TOOL_H
#define EDITOR_SET_ORIGIN_TOOL_H

#include "editor/tools/editor_tool.h"
#include "logic/widelands.h"

/// Sets the starting position of players.
struct Editor_Set_Origin_Tool : public Editor_Tool {
	Editor_Set_Origin_Tool() : Editor_Tool(*this, *this) {}

	int32_t handle_click_impl
		(Widelands::Map & map, Widelands::Node_and_Triangle<> center,
		 Editor_Interactive & eia, Editor_Action_Args & args);

	int32_t handle_undo_impl
		(Widelands::Map & map, Widelands::Node_and_Triangle<> center,
		 Editor_Interactive & parent, Editor_Action_Args & args);

	Editor_Action_Args format_args_impl(Editor_Interactive & parent);

	char const * get_sel_impl() const {return "pics/fsel.png";}

	bool has_size_one() const {return true;}
};

#endif
