
//! @file vtcore.h
//! @ingroup InternalAPI
//! @brief @c %VTCore @c HostDSP implementation

/*---------------------------------------------------------------------------*\

    AUTHOR..: Ben Kramer
    DATE....: 01/12/2005
    AUTHOR..: Ron Lee
    DATE....: 11/11/2006


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __VTCORE_H__
#define __VTCORE_H__

#include "vpbreg.h"
#include "generic.h"
#include <sys/types.h>

//! @defgroup VTCoreAPI VTCore HostDSP implementation
//! @ingroup InternalAPI
//! @brief @c HostDSP implementation for devices using the @c vtcore driver.
//!@{
//{{{

// XXX make this a nested class of VTCore (or part of it?)
struct vtcore_chan {
	int state;
	int run;
	VPB_PORT interface;	// FXO/FXS
	int encoding;		// Encoding
	int chan_num;		// vpb channel number
	void *dtmf_dec;		// Pointer to dtmf states
	void *vox_states;	// Pointer to VOX detection states
	//XXX void *agc_states;	// Pointer to AGC states
	int fxs_ohms;           // ProSLIC impedance override.
	int fxo_ohms;           // VDAA impedance override.
	VPBREG *v;
};


//! Support for cards using the @c vtcore driver.
class VTCore : public HostDSP
{ //{{{
    private:

	pthread_t   m_dspthread;
	pthread_t   m_playthread;
	pthread_t   m_recordthread;


	static void *SimulateDSP(void *p);
	static void *PlayThread(void *p);
	static void *RecordThread(void *p);


	void config_bals( int port, int *bals );
	void config_logging( int port, int logging );
	void Configure();

	void HostDSPOpen();
	void HostDSPClose();

	bool ProcessCommands();
	void CheckMsgQ();

	int prepare_play_buf(int16_t *buf, int ch);
	void prepare_rec_buf(int16_t *buf, int ch);


    public:

	//! Constructor
	VTCore(VPBREG &reg);

	//! Destructor
	~VTCore();


	// base class implementation
	void Reset( unsigned int port );
	void SetCountry( int port, const Country *country );

	void SetHookState( int port, HookState hookstate );
        void SetFlashTime( int port, uint16_t min, uint16_t max);

	void PadTxFrame( int port );
	void WaitForTxEmpty( int port );

	void SetPSImpedance( int port, int impedance );
	void SetVDAAImpedance( int port, int impedance );

	float GetHWPlayGain( unsigned int port );
	float GetHWRecordGain( unsigned int port );

	void TapListen( unsigned int port, unsigned int srcboard, unsigned int srcport );
	void UNListen( unsigned int port );


	//! Get the current state of a port.
	int chan_state(int ch);

	//! Get the type of a port.
	VPB_PORT chan_type(int ch);

	//! Get the hook state of a port.
	HookState hook_state(int ch);

}; //}}}

//!@} //}}}  group VTCoreAPI

#endif

