/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.util.Iterator;
import spec.jbb.JBBDataStorage;
import spec.jbb.JBBSortedStorage;
import spec.jbb.MapDataStorage;
import spec.jbb.TreeMapDataStorage;

class Infrastructure {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";

    Infrastructure() {
    }

    private static JBBDataStorage synchStorage(JBBDataStorage jBBDataStorage) {
        return new SynchronizedJBBDataStorage(jBBDataStorage);
    }

    public static JBBDataStorage createStorage() {
        return new MapDataStorage();
    }

    public static JBBDataStorage createStorage(boolean bl) {
        JBBDataStorage jBBDataStorage = Infrastructure.createStorage();
        if (bl) {
            jBBDataStorage = Infrastructure.synchStorage(jBBDataStorage);
        }
        return jBBDataStorage;
    }

    public static JBBSortedStorage createSortedStorage() {
        return new TreeMapDataStorage();
    }

    private static class SynchronizedJBBSortedStorage
    extends SynchronizedJBBDataStorage
    implements JBBSortedStorage {
        SynchronizedJBBSortedStorage(JBBSortedStorage jBBSortedStorage) {
            super(jBBSortedStorage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeFirstElem() {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return ((JBBSortedStorage)this.s).removeFirstElem();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deleteFirstEntities(int n) {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return ((JBBSortedStorage)this.s).deleteFirstEntities(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deleteFirstEntities() {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return ((JBBSortedStorage)this.s).deleteFirstEntities();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getMedianValue(Object object, Object object2) {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return ((JBBSortedStorage)this.s).getMedianValue(object, object2);
            }
        }
    }

    private static class SynchronizedJBBDataStorage
    implements JBBDataStorage {
        JBBDataStorage s;

        SynchronizedJBBDataStorage(JBBDataStorage jBBDataStorage) {
            this.s = jBBDataStorage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsKey(Object object) {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return this.s.containsKey(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(Object object) {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return this.s.get(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object put(Object object, Object object2) {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return this.s.put(object, object2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(Object object) {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return this.s.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return this.s.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator elements() {
            JBBDataStorage jBBDataStorage = this.s;
            synchronized (jBBDataStorage) {
                return this.s.elements();
            }
        }
    }
}

