/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.stringifier;

import com.sun.appserv.management.util.stringifier.IteratorStringifier;
import com.sun.appserv.management.util.stringifier.SmartStringifier;
import com.sun.appserv.management.util.stringifier.Stringifier;
import java.util.Arrays;
import java.util.Iterator;

public final class ArrayStringifier
implements Stringifier {
    final String mDelim;
    final Stringifier mElementStringifier;
    boolean mAddBraces;
    static final char LEFT_BRACE = '{';
    static final char RIGHT_BRACE = '}';
    static final String DEFAULT_DELIM = ",";
    public static final ArrayStringifier DEFAULT = new ArrayStringifier(",");

    public ArrayStringifier() {
        this(SmartStringifier.DEFAULT);
        this.mAddBraces = false;
    }

    public ArrayStringifier(boolean addBraces) {
        this(DEFAULT_DELIM, SmartStringifier.DEFAULT, addBraces);
    }

    public ArrayStringifier(String delim) {
        this(delim, false);
    }

    public ArrayStringifier(String delim, boolean addBraces) {
        this(delim, SmartStringifier.DEFAULT, addBraces);
    }

    public ArrayStringifier(Stringifier elementStringifier) {
        this(DEFAULT_DELIM, elementStringifier);
    }

    public ArrayStringifier(String delim, Stringifier elementStringifier) {
        this(delim, elementStringifier, false);
    }

    public ArrayStringifier(String delim, Stringifier elementStringifier, boolean addBraces) {
        this.mDelim = delim;
        this.mElementStringifier = elementStringifier;
        this.mAddBraces = addBraces;
    }

    static String addBraces(boolean add, String s) {
        String out = s;
        if (add) {
            out = '{' + s + '}';
        }
        return out;
    }

    @Override
    public String stringify(Object o) {
        String s = ArrayStringifier.stringify((Object[])o, this.mDelim, this.mElementStringifier);
        return ArrayStringifier.addBraces(this.mAddBraces, s);
    }

    public static String stringify(Object[] o, String delim, Stringifier stringifier) {
        Iterator<Object> iter = Arrays.asList(o).iterator();
        IteratorStringifier iterStringifier = new IteratorStringifier(delim, stringifier);
        String s = iterStringifier.stringify(iter);
        return s;
    }

    public static String stringify(Object[] o, String delim) {
        return ArrayStringifier.stringify(o, delim, SmartStringifier.DEFAULT);
    }
}

