/*
  testxdb Plain VDK Application
  Main unit header file: testxdb.h
*/
#ifndef _testxdb_main_form_h_
#define _testxdb_main_form_h_
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// vdkxdb support
#ifdef VDKXDB_SUPPORT
#include <vdkxdb2/vdkxdb_support.h>
/*
  Note: all tables and indexes files names
  are relative to XDB_DATA_PATH symbolic constant,
  change it if you need a path other than default ,
  however all data and index files should be
  contained into a single directory
*/

#define XDB_DATA_PATH "./"
#endif
// vdk support
#include <vdk/vdk.h>
// typdefs a VDKXControl list.
typedef VDKList<VDKXControl> ControlList;
typedef VDKListIterator<VDKXControl> ControlListIterator;

// Testxdb FORM  CLASS
class TestxdbForm: public VDKForm
{
  // gui object declarations
  VDKXTable* table;
private:
  // gui object declarations
  void GUISetup(void);
  void Read();
  void Write();
  void EnableControls(bool flag);
  ControlList cList;
public:
  TestxdbForm(VDKApplication* app, char* title);
  ~TestxdbForm();
  void Setup(void);
/*
 gui setup include
 do not patch below here
*/
#include <testxdb_gui.h>
};


// Testxdb APPLICATION  CLASS
class TestxdbApp: public VDKApplication
{
#ifdef VDKXDB_SUPPORT
  VDKXDatabase* xdb;
#endif
  void SetupDatabase(void);
public:
  TestxdbApp(int* argc, char** argv);
  ~TestxdbApp();
#ifdef VDKXDB_SUPPORT
  void XDBSetup(void);
  VDKXDatabase* TheXdb() { return xdb; }
#endif
  void Setup(void);
};

#endif
// do not remove this mark: #!#
// end of file:testxdb.h

