/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#include <vdkb2/vdkb_spinbutton.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb2/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit 
================================
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
//#define _(str) gettext(str)
#define _(str) \
    ( g_utf8_validate(gettext(str),-1,NULL) ? \
    gettext(str) : \
    g_locale_to_utf8(gettext(str),-1,NULL,NULL,NULL) )
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif
// for methods and other stuff
#define CLASS VDKBSpinButton
// put here vdk class name string
#define VDK_CLASS "VDKSpinButton"
// put here vdk class name 
#define VDK_ANCESTOR  VDKSpinButton
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "spinbutton"
extern void strreplace(char* s, char sep1, char sep2);
extern char* wi_widget_prompts[];
static char buff[128];

// used to autogenerate default
// button  names and captions

int CLASS::Counter = 0;
/* 
 label button properties names
 */
char* vdkspinbutton_props[] =
{ 
SLIDER_DIGITS,SLIDER_DEFVALUE,
SLIDER_LOWER,SLIDER_UPPER,
SLIDER_STEP,SPIN_CLIMB,0
};
/*
button signals names && nicknames
Default response method name will be made by:
On<object name><nickname>.
For instance if object name = <Abutton> and nickname = <Click>
default response method name will be: <OnAbuttonClick>
*/
char* vdkspinbutton_signals[] =
{
SIGNAL_VALUE_CHANGED,SIGNAL_FOCUS_OUT, 0
};
char* vdkspinbutton_nicknames[] =
{
NICK_VALUE_CHANGED,NICK_FOCUS_OUT,0
};
//////////////////////////////////////////////////
// dynamic tables
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, 
			       VDKForm* owner,
			       float defValue,
			       float lower,
			       float upper,
			       float step,
			       float climb):
  VDK_ANCESTOR(owner,defValue,lower,upper,step, climb),
  VDKBObject(name)
{
  int t;
  // newly constructed widget counter is incremented
  // each time 
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add to VDKBObject properties list 
  // (Others props are prepended  by VDKBObject constructor)
  for(t=0; vdkspinbutton_props[t]; t++)
    proplist.add(VDKBProperty(vdkspinbutton_props[t]));
  SetPropValue(SLIDER_DIGITS,"2");
  sprintf(buff,"%.1f",0.0);
  SetPropValue(SLIDER_DEFVALUE,buff);
  sprintf(buff,"%.1f",0.0);
  SetPropValue(SLIDER_LOWER,buff);
  sprintf(buff,"%.1f",1.0);
  SetPropValue(SLIDER_UPPER ,buff);
  sprintf(buff,"%.1f",0.05);
  SetPropValue(SLIDER_STEP,buff);
  sprintf(buff,"%.1f",0.0);
  SetPropValue(SPIN_CLIMB,buff);
  // add to VDKBObject signal list label button signals
  for(t=0; vdkspinbutton_signals[t]; t++)
    siglist.add(VDKBSignal(vdkspinbutton_signals[t],
			   this,
			   vdkspinbutton_nicknames[t]));
  // connects events.
  CONNECT_COMMON_EVENTS;

  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_DIGITS,(char*) GetProp(SLIDER_DIGITS));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_DEFVALUE,(char*) GetProp(SLIDER_DEFVALUE));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_LOWER,(char*) GetProp(SLIDER_LOWER));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_UPPER,(char*) GetProp(SLIDER_UPPER));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SLIDER_STEP,(char*) GetProp(SLIDER_STEP));
  fprintf(fp,"\n\t%s%s;",
	  PROP_SPIN_CLIMB,(char*) GetProp(SPIN_CLIMB));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* button = NULL;
  // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2; 
  else
    button = new CLASS(buff,owner);
  // add widget to form
  return owner->AddToSelf(button,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char appo[128];
  double defvalue = 0.0,
    lower = 0.0,
    upper = 1.0,
    step = 0.05,
    climb = 0.0;
  int digits = 2;

// gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  // get default values
  if(parser.GetParam(arg,buffer,PROP_SLIDER_DIGITS))
    digits = atoi(arg);

  if(parser.GetParam(arg,buffer,PROP_SLIDER_DEFVALUE))
    defvalue = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_LOWER))
    lower = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_UPPER))
    upper = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_STEP))
    step = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SPIN_CLIMB))
    climb = atof(arg);
  source = new char[4096];
  sprintf(appo,"%f-%f-%f-%f-%f",defvalue,lower,upper,step,climb);
  strreplace(appo,',','.');
  strreplace(appo,'-',','); 
  sprintf(tmp,"\n%s = new %s(this,%s);",obj_name,VDK_CLASS,appo);
  strcpy(source,tmp);
  sprintf(tmp,"\n%s->Digits = %d;",obj_name,digits);
  strcat(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
// get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner, 
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  double defvalue = 0.0,
    lower = 0.0,
    upper = 1.0,
    step = 0.05,
    climb = 0.0;
  int digits = 2;
  char arg[64];
  CLASS* button;
  // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return false;
  // get default values
  if(parser.GetParam(arg,buffer,PROP_SLIDER_DIGITS))
    digits = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_DEFVALUE))
    defvalue = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_LOWER))
    lower = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_UPPER))
    upper = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SLIDER_STEP))
    step = atof(arg);
  if(parser.GetParam(arg,buffer,PROP_SPIN_CLIMB))
    climb = atof(arg);
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ? 
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      button = new CLASS(obj_name,owner,defvalue,
				  lower,upper,step,climb);
      button->Digits = digits;
      sprintf(buff,"%d",digits);
      button->SetPropValue(SLIDER_DIGITS,buff);

      sprintf(buff,"%f",defvalue);
      button->SetPropValue(SLIDER_DEFVALUE,buff);

      sprintf(buff,"%f",lower);
      button->SetPropValue(SLIDER_LOWER,buff);

      sprintf(buff,"%f",upper);
      button->SetPropValue(SLIDER_UPPER,buff);

      sprintf(buff,"%f",step);

      button->SetPropValue(SLIDER_STEP,buff);

      sprintf(buff,"%f",climb);
      button->SetPropValue(SPIN_CLIMB,buff);

      // pack widget to container
      return owner->PackToSelf(button, container, buffer, parser);
    }
  else
    return false;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
 */
VDKObjectContainer* 
CLASS::ExtraWidget(VDKBObjectInspector* isp) 
{ 
  inspector = isp;
  VDKFrame* bframe = new VDKFrame(inspector,NULL,
				  v_box,shadow_etched_in);

  VDKTable *table = new VDKTable(inspector,6,2);
  table->SetSize(219,-1);

  table->AddToCell(new VDKLabel(inspector,_("Default value")),0,0);
  defvalue = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_DEFVALUE));
  defvalue->SetSize(100,-1);
  table->AddToCell(defvalue,0,1);
  defvalue->Parent(this);
  SignalConnect(defvalue,"activate",&CLASS::OnSetDefValue);

  table->AddToCell(new VDKLabel(inspector,_("Lower range value")),1,0);
  lower = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_LOWER));
  lower->SetSize(100,-1);
  table->AddToCell(lower,1,1);
  lower->Parent(this);
  SignalConnect(lower,"activate",&CLASS::OnSetLower);

  table->AddToCell(new VDKLabel(inspector,_("Upper range value")),2,0);
  upper = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_UPPER));
  upper->SetSize(100,-1);
  table->AddToCell(upper,2,1);
  upper->Parent(this);
  SignalConnect(upper,"activate",&CLASS::OnSetUpper);

  table->AddToCell(new VDKLabel(inspector,_("Step increment")),3,0);
  step = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_STEP));
  step->SetSize(100,-1);
  table->AddToCell(step,3,1);
  step->Parent(this);
  SignalConnect(step,"activate",&CLASS::OnSetStep);

  table->AddToCell(new VDKLabel(inspector,_("Climb rate")),4,0);
  climb = new VDKEntry(inspector,0,(char*) GetProp(SPIN_CLIMB));
  climb->SetSize(100,-1);
  table->AddToCell(climb,4,1);
  climb->Parent(this);
  SignalConnect(climb,"activate",&CLASS::OnSetClimb);

  table->AddToCell(new VDKLabel(inspector,_("Precision")),5,0);
  digits = new VDKEntry(inspector,0,(char*) GetProp(SLIDER_DIGITS));
  digits->SetSize(100,-1);
  table->AddToCell(digits,5,1);
  digits->Parent(this);
  SignalConnect(digits,"activate",&CLASS::OnSetDigits);

  bframe->Add(table,l_justify,false,false,false);
  return bframe; 
}
//////////////////////////////////////////////////////
// These response methods actually change both 
// properties on widget and gui widget properties
//////////////////////////////////////////////////////
/*
 */
bool
CLASS::OnSetDefValue(VDKObject*)
{
  if(strlen(defvalue->Text) > 0)
    {
      sprintf(buff,"%s",(char*) defvalue->Text);
      SetPropValue(SLIDER_DEFVALUE,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetLower(VDKObject*)
{
  if(strlen(lower->Text) > 0)
    {
      sprintf(buff,"%s",(char*) lower->Text);
      SetPropValue(SLIDER_LOWER,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetUpper(VDKObject*)
{
  if(strlen(upper->Text) > 0)
    {
      sprintf(buff,"%s",(char*) upper->Text);
      SetPropValue(SLIDER_UPPER,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetStep(VDKObject*)
{
  if(strlen(step->Text) > 0)
    {
      sprintf(buff,"%s",(char*) step->Text);
      SetPropValue(SLIDER_STEP ,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetClimb(VDKObject*)
{
  if(strlen(climb->Text) > 0)
    {
      sprintf(buff,"%s",(char*) climb->Text);
      SetPropValue(SPIN_CLIMB,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}
/*
 */
bool
CLASS::OnSetDigits(VDKObject*)
{
  if(strlen(digits->Text) > 0)
    {
      sprintf(buff,"%s",(char*) digits->Text);
      SetPropValue(SLIDER_DIGITS,buff);
      inspector->FormNeedToBeChanged();
    }
  return true;
}





