/***************************************************************************
                          dcclient.h  -  description
                             -------------------
    begin                : Thu Oct 4 2001
    copyright            : (C) 2001-2005 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCCLIENT_H
#define DCCLIENT_H

/**
  *@author Mathias Küster
  */

#include <qtimer.h>
#include <qstringlist.h>
#include <QList>
#include <QHash>
#include <QMap>
#include <QMdiSubWindow>
#include <QMutex>

#include "DCDialogClient.h"

#include <dclib/cclient.h>

class DCChat;
class QListWidgetItem;
class QEvent;
class QShowEvent;
class DC_UserMenuCommand;
class UserListModel;
class FilterOnlyProxy;

class DCClient : public QWidget, private Ui::DCDialogClient, public CClient {
Q_OBJECT

public:
	/** construtor */
	DCClient( QWidget * parent = 0, CString remoteEncoding = CString() );
	/** destructor */
	virtual ~DCClient();

	/** */
	void InitDocument();
	/** */
	void DeInitDocument();

	/** chat */
	void DC_Chat( CMessageChat * MessageChat );
	/** myinfo */
	void DC_MyInfo( CMessageMyInfo * MessageMyInfo );
	/** nicklist */
	void DC_NickList( CMessageNickList * MessageNickList );
	/** oplist */
	void DC_OpList( CMessageOpList * MessageOpList );
	/** hello */
	void DC_Hello( CMessageHello * MessageHello );
	/** quit */        	
	void DC_Quit( CMessageQuit * MessageQuit );
	/** */
	void DC_PrivateChat( CMessagePrivateChat * msg, bool bLocal = false );
	/** */
	void DC_PrivateChat( QString nick, QString fromnick, QString message, bool bLocal = false );
	/** usercommand */
	void DC_UserCommand( CMessageUserCommand * MessageUserCommand );

	/** */
	static bool GetOPKickMessage( QString & message, QWidget * parent = 0 );
	/** */
	static bool GetOPForceMoveMessage( QString & message, QString & host, QWidget * parent = 0 );

	/** */
	bool OPKick( QString nick, QString message );
	/** */
	bool OPForceMove( QString nick, QString message, QString host );

	/** */
	void UpdateStatusBar();

	/** */
	void CloseChat( DCChat * chat );
	/** */
	void CloseAllChats( bool onlyOffline );

	/** callback function */
	virtual int DC_CallBack( CDCMessage * DCMessage );

	/** */
	QString findNick( QString part, int which );
	
	/** Replaces the %[tag] s in the menu command with their values */
	QString replaceCommandTags( QString & command, QString remotenick );
	
	/** Checks for and sends auto responses */
	void doAutoResponse( QString nick, QString message, DCChat * chatobject );
	
	/** Jump to the nick in the userlist */
	bool jumpToNick( const QString & nick );
	
	/** Enable userlist sorting */
	void enableUserListSorting();
	
	/** Disable userlist sorting */
	void disableUserListSorting();
	
	/** Centre on MDI area */
	void centreOnMdiArea();
	/** Get our mdi sub window */
	QMdiSubWindow * GetMdiSubWindow() { return m_pContainerWindow; };
	
	/**
	 * Adds all custom (from hub or settings) menu commands to menu.
	 * Returns a map of commands added which are pointers to the
	 * objects stored in DCConfig and must not be deleted.
	 */
	QMap<QAction*, DC_UserMenuCommand*> AddMenuCommands( QMenu * menu, int context );

private:
	/** */
	void addUser( QString nick );
	/** */
	void UpdateCaption();
	/** */
	void SetCrypt( bool b );
	/** */
	void SetConnection( bool b );
	/** deletes all cached MyInfo objects in the hash and empties the hash */
	void clearMyInfoCache();
	/**
	 * Moved out of InitDocument so it can be called by DCConnectionManager after
	 * the widget is visible, otherwise things are not sized properly
	 */
	void InitSizes();
	/**
	 * For saving the settings so new hubs will use them
	 * without closing this hubs.
	 */
	void saveColumns();
	
	/** the private chat widgets */
	QMap<QString, DCChat*> m_ChatMap;
	/** */
	CMessageChat m_ChatFloodMessage;
	/** */
	long m_nChatFloodCounter;
	/** */
	bool m_bUserPassword;
	/** the hubchat widget */
	DCChat * m_pHubChat;
	/** */
	bool m_bUseTabWidget;
	/** Nick of last auto response trigger */
	QString lastAutoNick;
	/** Time of last auto response trigger */
	long lastAutoResponseTime;
	/** Userlist model */
	UserListModel * m_pUserListModel;
	/** Filtering model */
	FilterOnlyProxy * m_pProxyModel;
	/** The MDI window that contains us */
	QMdiSubWindow * m_pContainerWindow;
	/** Last part of a nick for which tab completion requested */
	QString lastPart;
	/** List of nicks matching lastpart */
	QStringList lastMatches;
	/** List of menu commands from the hub */
	QList<DC_UserMenuCommand*> hubcommands;
	/** */
	bool m_bInitSizesDone;

protected:
	/** */
	QMutex m_Mutex;
	/** */
	QTimer m_Timer;
	/** */
	QList<CDCMessage*> * m_pMessageList;
	/** */
	QHash<QString, CMessageMyInfo*> * m_pMyInfoHash;

	/** event filter */
	virtual bool eventFilter( QObject * object, QEvent * event );
	/** close event handler */
	virtual void closeEvent( QCloseEvent * closeevent );
	/** overridden so that sizes are initialized on first show() */
	virtual void showEvent( QShowEvent * event );

private slots:
	/** */
	void timerDone();
	/** */
	void slotDoubleClickedUserList( const QModelIndex & index );
	/** */
	void slotDoubleClickedChatUserList( QListWidgetItem * item );
	/** */
	void slotContextMenuUserList( const QPoint & );
	/** */
	void slotDoubleClickedUserChat( QListWidgetItem * item );
	/** */
	void slotHubConnect();
	/** */
	void slotSSLInfo();
	/** current tab widget change slot */
	void slotTabWidgetChatCurrentChange(QWidget*);
	/** */
	void slotTabCornerCloseWidgetClicked();
	/** */
	void slotContextMenuTabWidgetChat( const QPoint & pos );
	/** */
	void slotFilterToggled( bool enabled );
	/** */
	void slotFilterColumn( int column );
	/** */
	void slotFilterString( const QString & text );
	/** context menu for the QHeaderView */
	void slotContextMenuHeader( const QPoint & );
	/** */
	void slotAltRowColors( bool enable );
};

#endif
