#!/usr/bin/python

## Generates the reference pot file based on the chromium's extension locale content
## Expects to be called w/ locale folder, e.g.:
## 
## ./generate_reference_pot_file.py ./chromium-extension/_locales

import sys

def exit_with_error(msg):
    sys.stderr.write("*** Error: " + msg + "\n")
    sys.exit(1)

if len(sys.argv) != 2:
    exit_with_error("Invalid usage")

locales_folder = sys.argv[1]
import os
thispath = os.path.dirname(os.path.realpath(__file__))

# validation
if not os.path.exists(locales_folder):
    exit_with_error("Invalid locale folder, does not exist")

if not os.path.isabs(locales_folder):
    locales_folder = os.path.join (thispath, locales_folder)

messages_json_reference_filename = os.path.join(locales_folder, "en/messages.json")
if not os.path.exists(messages_json_reference_filename):
    exit_with_error("Invalid locale folder structure: no messages.json found for 'en' reference")

# go
def save_pot_file_for(filename, messages):
    import polib
    po = polib.POFile()
    po.metadata = {
        'Project-Id-Version': 'PACKAGE VERSION',
        'Report-Msgid-Bugs-To': 'you@example.com',
        
        'POT-Creation-Date': '2007-10-18 14:00+0100',
        
    'PO-Revision-Date': 'YEAR-MO-DA HO:MI+ZONE',
        'Last-Translator': 'FULL NAME <EMAIL@ADDRESS>',
        'Language-Team': 'LANGUAGE <LL@li.org>',
        'Language': '',
        'MIME-Version': '1.0',
        'Content-Type': 'text/plain; charset=utf-8',
        'Content-Transfer-Encoding': '8bit',
    }
    for i, message in enumerate(messages):
        entry = polib.POEntry(msgid=message,
                              msgstr=u'',
                              occurrences=[('messages.json', str(i))]
                          )
        po.append(entry)
    po.save(filename)

def generate_pot(json_filename):
    import json
    pot_messages = []
    try:
        content = json.loads(open(json_filename).read())
        for k, v in content.iteritems():
            if v.__class__ is type({}) and v.has_key('message'):
                pot_messages.append(v['message'])
        save_pot_file_for('unity_chromium_extension.pot', pot_messages)
    except Exception, e:
        exit_with_error("Cannot read & import messages.json file, " + str(e))

if __name__ == "__main__":
    generate_pot(messages_json_reference_filename)
