/*
 * unity-npapi-plugin.h
 * Copyright (C) Canonical LTD 2012
 * 
 * Author: Alexandre Abreu <alexandre.abreu@canonical.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#if ! defined (UNITY_NPAPI_PLUGIN_H)
#define UNITY_NPAPI_PLUGIN_H

#include <glib.h>

#include "npapi-headers/headers/npapi.h"
#include "npapi-headers/headers/npfunctions.h"


/**
 * Basic struct for a npapi plugin
 * 
 */

typedef struct unity_npapi_plugin_t_
{
  NPPluginFuncs * 	pPluginFuncs;

  // the plugin global instance
  NPP npp;

  // we do create a few objects on the fly, need to keep track of them
  // to properly clean them on a per-context basis
  GHashTable * retained_objects;

} unity_npapi_plugin_t;


void unity_npapi_add_retained_objects_for_context (unity_npapi_plugin_t * plugin
                                                   , gpointer context
                                                   , NPObject *);

void unity_npapi_free_retained_objects_for_context (unity_npapi_plugin_t * plugin
                                                    , gpointer context);

void unity_npapi_free_all_retained_objects (unity_npapi_plugin_t * plugin);

/**
 * 
 * 
 */
int unity_npapi_initialize_plugin (NPNetscapeFuncs  * pBrowserFuncs
                                   , NPPluginFuncs * pPluginFuncs);

/**
 * 
 * 
 */
int unity_npapi_cleanup_plugin (void);


#endif // UNITY_NPAPI_PLUGIN_H
