/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.Popups 0.1
import QtWebKit 3.0
import Ubuntu.Purchase 0.1


MainView {
    id: main
    // objectName for functional testing purposes (autopilot-qt5)
    objectName: "mainView"

    applicationName: "com.ubuntu.purchase.UbuntuPurchase"
    
    /* 
     This property enables the application to change orientation 
     when the device is rotated. The default is false.
    */
    automaticOrientation: true
    
    width: units.gu(80)
    height: units.gu(71)

    function purchaseCompleted() {
        purchase.purchaseSucceeded();
        Qt.quit();
    }

    function closePurchase() {
        purchase.purchaseCanceled();
        Qt.quit();
    }

    function parseQuery(url) {
        var argsParsed = {};
        var vars = url.split('?');
        if(vars.length == 1) {
            return argsParsed;
        }

        var args = vars[1].split('&');
        for (var i=0; i < args.length; i++) {
            var arg = decodeURI(args[i]);
            if (arg.indexOf('=') == -1) {
                argsParsed[arg.trim()] = true;
            } else {
                var keyvalue = arg.split('=');
                argsParsed[keyvalue[0].trim()] = keyvalue[1].trim();
            }
        }

        return argsParsed;
    }

    UbuntuPurchase {
        id: purchase
    }

    Component.onCompleted: {
        PopupUtils.open(loadingDialogContainer);
        purchase.launchService();
    }

    Component {
         id: loadingDialogContainer
         Dialog {
             id: loadingDialog
             title: i18n.tr("Loading")
             text: i18n.tr("please wait...")
             ActivityIndicator {
                 running: webView.loading ? true : false
                 width: parent.width

                 onRunningChanged: {
                     if(!running) {
                         PopupUtils.close(loadingDialog);
                     }
                 }
             }

             Button {
                 text: i18n.tr("Cancel")
                 color: UbuntuColors.orange
                 onClicked: {
                     PopupUtils.close(loadingDialog);
                     main.closePurchase();
                 }
             }
         }
    }
    
    Flickable {
        id: webViewFlickable
        anchors.fill: parent
        
        WebView {
            id: webView
            objectName: "webView"
            anchors.fill: parent
            url: purchase.url

            onLoadingChanged: {
                if(webView.loading) {
                    PopupUtils.open(loadingDialogContainer);
                }
            }

            onNavigationRequested: {
                if (/^(purchase):\/\/succeeded/.test(request.url)) {
                    request.action = WebView.IgnoreRequest;
                    var args = main.parseQuery(request.url.toString());
                    main.purchaseCompleted();
                    return;
                } else if(/^(purchase):\/\/failed/.test(request.url)) {
                    request.action = WebView.IgnoreRequest;
                    var args = main.parseQuery(request.url.toString());
                    main.closePurchase();
                    return;
                }

                request.action = WebView.AcceptRequest;
            }
        }
    }
}
