/*
*         OpenPBS (Portable Batch System) v2.3 Software License
*
* Copyright (c) 1999-2000 Veridian Information Solutions, Inc.
* All rights reserved.
*
* ---------------------------------------------------------------------------
* For a license to use or redistribute the OpenPBS software under conditions
* other than those described below, or to purchase support for this software,
* please contact Veridian Systems, PBS Products Department ("Licensor") at:
*
*    www.OpenPBS.org  +1 650 967-4675                  sales@OpenPBS.org
*                        877 902-4PBS (US toll-free)
* ---------------------------------------------------------------------------
*
* This license covers use of the OpenPBS v2.3 software (the "Software") at
* your site or location, and, for certain users, redistribution of the
* Software to other sites and locations.  Use and redistribution of
* OpenPBS v2.3 in source and binary forms, with or without modification,
* are permitted provided that all of the following conditions are met.
* After December 31, 2001, only conditions 3-6 must be met:
*
* 1. Commercial and/or non-commercial use of the Software is permitted
*    provided a current software registration is on file at www.OpenPBS.org.
*    If use of this software contributes to a publication, product, or
*    service, proper attribution must be given; see www.OpenPBS.org/credit.html
*
* 2. Redistribution in any form is only permitted for non-commercial,
*    non-profit purposes.  There can be no charge for the Software or any
*    software incorporating the Software.  Further, there can be no
*    expectation of revenue generated as a consequence of redistributing
*    the Software.
*
* 3. Any Redistribution of source code must retain the above copyright notice
*    and the acknowledgment contained in paragraph 6, this list of conditions
*    and the disclaimer contained in paragraph 7.
*
* 4. Any Redistribution in binary form must reproduce the above copyright
*    notice and the acknowledgment contained in paragraph 6, this list of
*    conditions and the disclaimer contained in paragraph 7 in the
*    documentation and/or other materials provided with the distribution.
*
* 5. Redistributions in any form must be accompanied by information on how to
*    obtain complete source code for the OpenPBS software and any
*    modifications and/or additions to the OpenPBS software.  The source code
*    must either be included in the distribution or be available for no more
*    than the cost of distribution plus a nominal fee, and all modifications
*    and additions to the Software must be freely redistributable by any party
*    (including Licensor) without restriction.
*
* 6. All advertising materials mentioning features or use of the Software must
*    display the following acknowledgment:
*
*     "This product includes software developed by NASA Ames Research Center,
*     Lawrence Livermore National Laboratory, and Veridian Information
*     Solutions, Inc.
*     Visit www.OpenPBS.org for OpenPBS software support,
*     products, and information."
*
* 7. DISCLAIMER OF WARRANTY
*
* THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND. ANY EXPRESS
* OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT
* ARE EXPRESSLY DISCLAIMED.
*
* IN NO EVENT SHALL VERIDIAN CORPORATION, ITS AFFILIATED COMPANIES, OR THE
* U.S. GOVERNMENT OR ANY OF ITS AGENCIES BE LIABLE FOR ANY DIRECT OR INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* PBS_rdrpy

 Read the reply to a batch request.
 A reply structure is allocated and cleared.
 The reply is read and decoded into the structure.
 The reply structure is returned.

 The caller MUST free the reply structure by calling
 PBS_FreeReply().
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "libpbs.h"
#include "dis.h"



struct batch_reply *PBSD_rdrpy(

        int c)  /* I */

  {
  int      rc;

  struct batch_reply *reply;
  int      sock;

  /* clear any prior error message */

  if (connection[c].ch_errtxt != NULL)
    {
    free(connection[c].ch_errtxt);

    connection[c].ch_errtxt = NULL;
    }

  if ((reply = (struct batch_reply *)calloc(1, sizeof(struct batch_reply))) == NULL)
    {
    connection[c].ch_errno = PBSE_SYSTEM;
    pbs_errno = PBSE_SYSTEM;

    return(NULL);
    }

  sock = connection[c].ch_socket;

  DIS_tcp_setup(sock);

  if ((rc = decode_DIS_replyCmd(sock, reply)))
    {
    free(reply);

    if (DIS_tcp_istimeout(sock) == TRUE)
      {
      pbs_errno = PBSE_TIMEOUT;
      }
    else
      {
      pbs_errno = PBSE_PROTOCOL;
      }

    connection[c].ch_errno = pbs_errno;

    connection[c].ch_errtxt = strdup(dis_emsg[rc]);

    return(NULL);
    }

  DIS_tcp_reset(sock, 0); /* reset DIS read buffer */

  connection[c].ch_errno = reply->brp_code;

  pbs_errno = reply->brp_code;

  if (reply->brp_choice == BATCH_REPLY_CHOICE_Text)
    {
    connection[c].ch_errtxt = strdup(reply->brp_un.brp_txt.brp_str);
    }

  return(reply);
  }  /* END PBSD_rdrpy() */





/*
 * PBS_FreeReply - Free a batch_reply structure allocated in PBS_rdrpy()
 *
 * Any additional allocated substructures pointed to from the
 * reply structure are freed, then the base struture itself is gone.
 */

void PBSD_FreeReply(

  struct batch_reply *reply)

  {

  struct brp_select   *psel;

  struct brp_select   *pselx;

  struct brp_cmdstat  *pstc;

  struct brp_cmdstat  *pstcx;

  struct attrl        *pattrl;

  struct attrl     *pattrx;

  if (reply == 0)
    {
    return;
    }

  if (reply->brp_choice == BATCH_REPLY_CHOICE_Text)
    {
    if (reply->brp_un.brp_txt.brp_str)
      {
      (void)free(reply->brp_un.brp_txt.brp_str);
      reply->brp_un.brp_txt.brp_str = (char *)0;
      reply->brp_un.brp_txt.brp_txtlen = 0;
      }

    }
  else if (reply->brp_choice == BATCH_REPLY_CHOICE_Select)
    {
    psel = reply->brp_un.brp_select;

    while (psel)
      {
      pselx = psel->brp_next;
      (void)free(psel);
      psel = pselx;
      }

    }
  else if (reply->brp_choice == BATCH_REPLY_CHOICE_Status)
    {
    pstc = reply->brp_un.brp_statc;

    while (pstc)
      {
      pstcx = pstc->brp_stlink;
      pattrl = pstc->brp_attrl;

      while (pattrl)
        {
        pattrx = pattrl->next;

        if (pattrl->name)
          (void)free(pattrl->name);

        if (pattrl->resource)
          (void)free(pattrl->resource);

        if (pattrl->value)
          (void)free(pattrl->value);

        (void)free(pattrl);

        pattrl = pattrx;
        }

      (void)free(pstc);
      pstc = pstcx;
      }
    }
  else if (reply->brp_choice == BATCH_REPLY_CHOICE_RescQuery)
    {
    (void)free(reply->brp_un.brp_rescq.brq_avail);
    (void)free(reply->brp_un.brp_rescq.brq_alloc);
    (void)free(reply->brp_un.brp_rescq.brq_resvd);
    (void)free(reply->brp_un.brp_rescq.brq_down);
    }

  free(reply);

  return;
  }   /* END PBSD_FreeReply() */
