[comment {-*- tcl -*- doctools manpage}]
[manpage_begin namespacex n 0.1]
[copyright {200? Neil Madden (http://wiki.tcl.tk/12790)}]
[copyright {200? Various (http://wiki.tcl.tk/1489)}]
[copyright {2010 Documentation, Andreas Kupries}]
[moddesc   {Namespace utility commands}]
[titledesc {Namespace utility commands}]
[require Tcl 8.5]
[require namespacex [opt 0.1]]
[description]

This package provides a number of utility commands for working with
namespaces.

[section API]

[list_begin definitions]

[call [cmd {::namespacex hook add}]  [opt [arg namespace]] [arg cmdprefix]]
[call [cmd {::namespacex hook proc}] [opt [arg namespace]] [arg arguments] [arg body]]
[call [cmd {::namespacex hook on}]   [opt [arg namespace]] [arg guardcmdprefix] [arg actioncmdprefix]]
[call [cmd {::namespacex hook next}] [arg arg]...]


[call [cmd {::namespacex info allchildren}] [arg namespace]]

This command returns a list containing the names of all child
namespaces in the specified [arg namespace] and its children. The
names are all fully qualified.


[call [cmd {::namespacex info allvars}] [arg namespace]]

This command returns a list containing the names of all variables in
the specified [arg namespace] and its children. The names are all
relative to [arg namespace], and [emph not] fully qualified.


[call [cmd {::namespacex info vars}] [arg namespace] [opt [arg pattern]]]

This command returns a list containing the names of all variables in
the specified [arg namespace].


[call [cmd {::namespacex state get}] [arg namespace]]

This command returns a dictionary holding the names and values of all
variables in the specified [arg namespace] and its child namespaces.

[para]
Note that the names are all relative to [arg namespace],
and [emph not] fully qualified.


[call [cmd {::namespacex state set}] [arg namespace] [arg dict]]

This command takes a dictionary holding the names and values for a set
of variables and replaces the current state of the specified
[arg namespace] and its child namespaces with this state.

The result of the command is the empty string.


[call [cmd {::namespacex state drop}] [arg namespace]]

This command unsets all variables in the specified [arg namespace] and
its child namespaces.

The result of the command is the empty string.

[list_end]

[keywords {extended namespace} {namespace utilities} utilities {namespace unknown}]
[keywords {unknown hooking} {state (de)serialization} info]
[manpage_end]

