from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


absolute_import = _Mock()

combine_paths = _Mock()

copy_file = _Mock()

division = _Mock()

exec_command = _Mock()

filter_sources = _Mock()

get_build_architecture = _Mock()

get_ext_source_files = _Mock()

get_numpy_include_dirs = _Mock()

glob = _Mock()

has_cxx_sources = _Mock()

has_f_sources = _Mock()

is_sequence = _Mock()

log = _Mock()

msvc_version = _Mock()

newer_group = _Mock()

os = _Mock()

print_function = _Mock()

show_fortran_compilers = _Mock()

sys = _Mock()



class DistutilsError(_Mock):
  pass


class DistutilsFileError(_Mock):
  pass


class DistutilsSetupError(_Mock):
  pass


class build_ext(_Mock):
  pass
  description = 'build C/C++/F extensions (compile/link to build directory)'
  sep_by = " (separated by ':')"

class old_build_ext(_Mock):
  pass
  description = 'build C/C++ extensions (compile/link to build directory)'
  sep_by = " (separated by ':')"

