from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


UnixCCompiler__compile = _Mock()

UnixCCompiler_create_static_lib = _Mock()

absolute_import = _Mock()

division = _Mock()

gen_lib_options = _Mock()

gen_preprocess_options = _Mock()

get_exception = _Mock()

log = _Mock()

newer = _Mock()

os = _Mock()

print_function = _Mock()

re = _Mock()

replace_method = _Mock()

sys = _Mock()

sysconfig = _Mock()



class CCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'

class CompileError(_Mock):
  pass


class DistutilsExecError(_Mock):
  pass


class LibError(_Mock):
  pass


class LinkError(_Mock):
  pass


class NoneType(_Mock):
  pass


class StringType(_Mock):
  pass


class UnixCCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compiler_type = 'unix'
  dylib_lib_extension = '.dylib'
  dylib_lib_format = 'lib%s%s'
  obj_extension = '.o'
  shared_lib_extension = '.so'
  shared_lib_format = 'lib%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

