from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


DocDecorator = _Mock()

_make_exporter = _Mock()

export = _Mock()

export_by_name = _Mock()

export_custom = _Mock()

export_html = _Mock()

export_latex = _Mock()

export_markdown = _Mock()

export_python = _Mock()

export_rst = _Mock()

export_slides = _Mock()

exporter_map = _Mock()

g = _Mock()

get_export_names = _Mock()

string_types = _Mock()

undoc = _Mock()

wraps = _Mock()

name = 'custom'

class E(_Mock):
  pass
  output_mimetype = ''

class Exporter(_Mock):
  pass
  output_mimetype = ''

class ExporterNameError(_Mock):
  pass


class HTMLExporter(_Mock):
  pass
  output_mimetype = 'text/html'

class LatexExporter(_Mock):
  pass
  output_mimetype = 'text/latex'

class MarkdownExporter(_Mock):
  pass
  output_mimetype = 'text/markdown'

class NotebookNode(_Mock):
  pass
  _allownew = True

class PythonExporter(_Mock):
  pass
  output_mimetype = 'text/x-python'

class RSTExporter(_Mock):
  pass
  output_mimetype = 'text/restructuredtext'

class SlidesExporter(_Mock):
  pass
  output_mimetype = 'text/html'

class TemplateExporter(_Mock):
  pass
  output_mimetype = ''

