C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=ROTA3D,SSI=0
                        SUBROUTINE ROTA3D
C                       *****************
C
C      ----------------------------------------
     * (AKXX,AKYY,AKZZ,TETA,PHI,AKXY,AKXZ,AKYZ)
C      ----------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !           !    !    !   physol(n,2) = cp                           !
C !           !    !    !   physol(n,3) = k                            !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : CPHYSO
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C
C.. Variables externes
      DOUBLE PRECISION TETA,PHI,AKXX,AKYY,AKZZ,AKXY,AKXZ,AKYZ
C
C.. Variables internes
      DOUBLE PRECISION XXK1,XXK2,XXK3
      DOUBLE PRECISION ZCT,ZST,ZCP,ZSP,ZCT2,ZST2,ZCP2,ZSP2
C
C***********************************************************************
C
C     1- Calcul des cosinus et sinus
C     ==============================
      ZCT   = COS(TETA)
      ZST   = SIN(TETA)
      ZCP   = COS(PHI)
      ZSP   = SIN(PHI)
      ZCT2  = ZCT*ZCT
      ZST2  = ZST*ZST
      ZCP2  = ZCP*ZCP
      ZSP2  = ZSP*ZSP
C
C     2- Rotation
C     ===========
      XXK1 = AKXX*ZCT2*ZCP2 + AKYY*ZST2 + AKZZ*ZSP2*ZCT2
      XXK2 = AKXX*ZST2*ZCP2 + AKYY*ZCT2 + AKZZ*ZSP2*ZST2
      XXK3 = AKXX*ZSP2 + AKZZ*ZCP2
      AKXY = (AKXX*ZCT*ZCP2-AKYY*ZST+AKZZ*ZSP2*ZST) * ZCT
      AKXZ = (AKXX - AKZZ) * ZCT*ZSP*ZCP
      AKYZ = (AKXX - AKZZ) * ZCP*ZSP*ZST
C
      AKXX = XXK1 
      AKYY = XXK2
      AKZZ = XXK3 
C
C
C----
C FIN
C----
      END
