CHANGELOG for 3.2.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 3.2 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v3.2.0...v3.2.1

* 3.2.13 (2017-08-01)

 * bug #22244 [Console] Fix passing options with defaultCommand (Jakub Sacha)
 * bug #23684 [Debug] Missing escape in debug output (c960657)
 * bug #23654 [DI] Fix using private services in expressions (nicolas-grekas)
 * bug #23662 [VarDumper] Adapt to php 7.2 changes (nicolas-grekas)
 * bug #23649 [Form][TwigBridge] Don't render _method in form_rest() for a child form (fmarchalemisys)
 * bug #23023 [DoctrineBridge][PropertyInfo] Added support for Doctrine Embeddables (vudaltsov)
 * bug #23619 [Validator] Fix IbanValidator for ukrainian IBANs (paroe)
 * bug #23586 Fix case sensitive sameSite cookie (mikefrancis)
 * bug #23238 [Security] ensure the 'route' index is set before attempting to use it (gsdevme)
 * bug #23330 [WebProfilerBundle] Fix full sized dump hovering in toolbar (ogizanagi)
 * bug #23580 Fix login redirect when referer contains a query string (fabpot)
 * bug #23558 [FrameworkBundle] fix ValidatorCacheWarmer: use serializing ArrayAdapter (dmaicher)
 * bug #23574 [VarDumper] Move locale sniffing to dump() time (nicolas-grekas)

* 3.2.12 (2017-07-17)

 * bug #23549 [PropertyInfo] conflict for phpdocumentor/reflection-docblock 3.2 (xabbuh)
 * security #23507 [Security] validate empty passwords again (xabbuh)
 * bug #23526 [HttpFoundation] Set meta refresh time to 0 in RedirectResponse content (jnvsor)
 * bug #23540 Disable inlining deprecated services (alekitto)
 * bug #23468 [DI] Handle root namespace in service definitions (ro0NL)
 * bug #23256 [Security] Fix authentication.failure event not dispatched on AccountStatusException (chalasr)
 * bug #23461 Use rawurlencode() to transform the Cookie into a string (javiereguiluz)
 * bug #23459 [TwigBundle] allow to configure custom formats in XML configs (xabbuh)
 * bug #23460 Don't display the Symfony debug toolbar when printing the page (javiereguiluz)
 * bug #23469 [FrameworkBundle] do not wire namespaces for the ArrayAdapter (xabbuh)
 * bug #23417 [DI][Security] Prevent unwanted deprecation notices when using Expression Languages (dunglas)
 * bug #23261 Fixed absolute url generation for query strings and hash urls (alexander-schranz)
 * bug #23398 [Filesystem] Dont copy perms when origin is remote (nicolas-grekas)

* 3.2.11 (2017-07-05)

 * bug #23390 [Cache] Handle APCu failures gracefully (nicolas-grekas)
 * bug #23378 [FrameworkBundle] Do not remove files from assets dir (1ed)

* 3.2.10 (2017-07-04)

 * bug #23366 [FrameworkBundle] Don't get() private services from debug:router (chalasr)
 * bug #23341 [DoctrineBridge][Security][Validator] do not validate empty values (xabbuh)
 * bug #23274 Display a better error design when the toolbar cannot be displayed (yceruto)
 * bug #23296 [WebProfilerBundle] Fix css trick used for offsetting html anchor from fixed header (ogizanagi)
 * bug #23333 [PropertyAccess] Fix TypeError discard (dunglas)
 * bug #23326 [Cache] fix cleanup of expired items for PdoAdapter (dmaicher)
 * bug #23345 [Console] fix description of INF default values (xabbuh)
 * bug #23299 [Workflow] Added more events to the announce function (Nyholm)
 * bug #23279 Don't call count on non countable object (pierredup)
 * bug #23283 [TwigBundle] add back exception check (xabbuh)
 * bug #23268 Show exception is checked twice in ExceptionController of twig (gmponos)
 * bug #23266 Display a better error message when the toolbar cannot be displayed (javiereguiluz)
 * bug #23271 [FrameworkBundle] allow SSI fragments configuration in XML files (xabbuh)
 * bug #23254 [Form][TwigBridge] render hidden _method field in form_rest() (xabbuh)
 * bug #23250 [Translation] return fallback locales whenever possible (xabbuh)
 * bug #23240 [Console] Fix catching exception type in QuestionHelper (voronkovich)
 * bug #23229 [WebProfilerBundle] Eliminate line wrap on count column (routing) (e-moe)
 * bug #22732 [Security] fix switch user _exit without having current token (dmaicher)
 * bug #22730 [FrameworkBundle] Sessions: configurable "use_strict_mode" option for NativeSessionStorage (MacDada)
 * bug #23195 [FrameworkBundle] [Command] Clean bundle directory, fixes #23177 (NicolasPion)
 * bug #23052 [TwigBundle] Add Content-Type header for exception response (rchoquet)
 * bug #23199 Reset redirectCount when throwing exception (hvanoch)
 * bug #23186 [TwigBundle] Move template.xml loading to a compiler pass (ogizanagi)
 * bug #23130 Keep s-maxage when expiry and validation are used in combination (mpdude)
 * bug #23129 Fix two edge cases in ResponseCacheStrategy (mpdude)
 * feature #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #22636 [Routing] Expose request in route conditions, if needed and possible (ro0NL)
 * bug #22943 [SecurityBundle] Move cache of the firewall context into the request parameters (GromNaN)
 * bug #23057 [Translation][FrameworkBundle] Fix resource loading order inconsistency reported in #23034 (mpdude)
 * bug #23092 [Filesystem] added workaround in Filesystem::rename for PHP bug (VolCh)
 * bug #23128 [HttpFoundation] fix for Support for new 7.1 session options (vincentaubert)
 * bug #23176 [VarDumper] fixes (nicolas-grekas)
 * bug #23100 [PropertyAccess] Do not silence TypeErrors from client code. (tsufeki)
 * bug #23156 [PropertyAccess] Fix Usage with anonymous classes (mablae)
 * bug #23091 [Cache] ApcuAdapter::isSupported() should return true when apc.enable_cli=Off (nicolas-grekas)
 * bug #22953 #22839 - changed debug toolbar dump section to relative and use full window width (mkurzeja)
 * bug #23086 [FrameworkBundle] Fix perf issue in CacheClearCommand::warmup() (nicolas-grekas)
 * bug #23098 Cache ipCheck (2.7) (gonzalovilaseca)
 * bug #23069 [SecurityBundle] Show unique Inherited roles in profile panel (yceruto)
 * bug #23073 [TwigBridge] Fix namespaced classes (ogizanagi)
 * bug #23063 [Cache] Fix extensibility of TagAwareAdapter::TAGS_PREFIX (wucdbm)
 * bug #22936 [Form] Mix attr option between guessed options and user options (yceruto)
 * bug #22976 [DependencyInjection] Use more clear message when unused environment variables detected (voronkovich)
 * bug #23045 [Cache] fix Redis scheme detection (xabbuh)
 * bug #22988 [PropertyInfo][DoctrineBridge] The bigint Doctrine's type must be converted to string (dunglas)
 * bug #23014 Fix optional cache warmers are always instantiated whereas they should be lazy-loaded (romainneutron)
 * bug #23024 [EventDispatcher] Fix ContainerAwareEventDispatcher::hasListeners(null) (nicolas-grekas)
 * bug #22996 [Form] Fix \IntlDateFormatter timezone parameter usage to bypass PHP bug #66323 (romainneutron)
 * bug #22994 Harden the debugging of Twig filters and functions (stof)

* 3.2.9 (2017-05-29)

 * bug #22847 [Console] ChoiceQuestion must have choices (ro0NL)
 * bug #22900 [FrameworkBundle][Console] Fix the override of a command registered by the kernel (aaa2000)
 * bug #22910 [Filesystem] improve error handling in lock() (xabbuh)
 * bug #22924 [Cache] Dont use pipelining with RedisCluster (nicolas-grekas)
 * bug #22718 [Console] Fixed different behaviour of key and value user inputs in multiple choice question (borNfreee)
 * bug #22829 [Yaml] fix colon without space deprecation (xabbuh)
 * bug #22901 Fix missing abstract key in XmlDumper (weaverryan)
 * bug #22912 [DI] Avoid private call to Container::has() (ro0NL)
 * bug #22866 [DI] Check for privates before shared services (ro0NL)
 * bug #22874 [WebProfilerBundle] Fix sub-requests display in time profiler panel (nicolas-grekas)
 * bug #22817 [PhpUnitBridge] optional error handler arguments (xabbuh)
 * bug #22752 Improved how profiler errors are displayed on small screens (javiereguiluz)
 * bug #22715 [FrameworkBundle] remove Security deps from the require section (xabbuh)
 * bug #22647 [VarDumper] Fix dumping of non-nested stubs (nicolas-grekas)
 * bug #22409 [Yaml] respect inline level when dumping objects as maps (goetas, xabbuh)
 * bug #22584 [Security] Avoid unnecessary route lookup for empty logout path (ro0NL)
 * bug #22690 [Console] Fix errors not rethrown even if not handled by console.error listeners (chalasr)
 * bug #22669 [FrameworkBundle] AbstractConfigCommand: do not try registering bundles twice (ogizanagi)
 * bug #22676 [FrameworkBundle] Adding the extension XML (flug)
 * bug #22652 [Workflow] Move twig extension registration to twig bundle (ogizanagi)

* 3.2.8 (2017-05-01)

 * bug #22550 Allow Upper Case property names in ObjectNormalizer (insekticid)
 * bug #22528 [Asset] Starting slash should indicate no basePath wanted (weaverryan)
 * bug #22568 [EventDispatcher] fix getting priorities of listeners during dispatch (dmaicher)
 * bug #22541 [EventDispatcher] fix: unwrap listeners for correct info (dmaicher)
 * bug #22526 [Asset] Preventing the base path or absolute URL from being prefixed incorrectly (weaverryan)
 * bug #22523 [WebProfilerBundle] Fixed the flickering when loading complex profiler panels (javiereguiluz)
 * bug #21958 [Console] Fix bar width with multilines ProgressBar's format (maidmaid)
 * bug #22435 [Console] Fix dispatching throwables from ConsoleEvents::COMMAND (nicolas-grekas)
 * bug #22478 [Serializer] XmlEncoder: fix negative int and large numbers handling (dunglas)
 * bug #22424 [Debug] Set exit status to 255 on error (nicolas-grekas)
 * bug #22426 [PropertyInfo] Prevent returning int values in some cases (dunglas)
 * bug #22401  Prevent double registrations related to tag priorities (nicolas-grekas)
 * bug #22399  Prevent double registrations related to tag priorities (nicolas-grekas)
 * bug #22396 Prevent double registrations related to tag priorities (nicolas-grekas)
 * bug #22374 [Cache] Remove exception false-positive from FilesystemAdapterTrait (nicolas-grekas)
 * bug #22377 [Console] Allow terminal dimensions to be set to 0 (unbounded) (duncan3dc)
 * bug #22352 [HttpFoundation] Add `use_strict_mode` in validOptions for session (sstok)
 * bug #22351 [Yaml] don't keep internal state between parser runs (xabbuh)
 * bug #22304 Moved $this->setDate() before the deprecation handling. (mpdonadio)
 * bug #22307 [Debug] Fix php notice (enumag)
 * bug #22311 [DI] Fix second auto-registration (nicolas-grekas)
 * bug #22109 [Validator] check for empty host when calling checkdnsrr() (apetitpa)
 * bug #22280 [DI] Fix the xml schema (GuilhemN)
 * bug #22282 [DI] Prevent AutowirePass from triggering irrelevant deprecations (chalasr)
 * bug #22255 [Translation] avoid creating cache files for fallback locales. (aitboudad)
 * bug #22292 Fixes #22264 - add support for Chrome headless (redthor)

* 3.2.7 (2017-04-05)

 * bug #22285 [HttpKernel] Fix forward compat with Request::setTrustedProxies() (nicolas-grekas)
 * bug #22265 Allow Upper Case property names (insekticid)
 * bug #22258 [DI] Autowiring and factories are incompatible with each others (nicolas-grekas)
 * bug #22254 [DI] Don't use auto-registered services to populate type-candidates (nicolas-grekas)
 * bug #22229 [ExpressionLanguage] Provide the expression in syntax errors (k0pernikus, stof)
 * bug #22251 [PropertyInfo] Support nullable array or collection (4rthem)
 * bug #22240 [DI] Fix fatal error at ContainerBuilder::compile() if config is not installed (chalasr)
 * bug #22140 [Form] Improve the exceptions when trying to get the data in a PRE_SET_DATA listener and the data has not already been set (fancyweb)
 * bug #22217 [Console] Fix table cell styling (ro0NL)
 * bug #22194 [Console] CommandTester: disable color support detection (julienfalque)
 * bug #22188 [Console] Revised exception rendering (ro0NL)
 * bug #22154 [WebProfilerBundle] Normalize whitespace in exceptions passed in headers (curry684)
 * bug #22183 [Process] Fix bug which wiped or mangled env vars (pjcdawkins)
 * bug #22142 [Console] Escape exception messages in renderException (chalasr)
 * bug #22172 Fix port usage in server:status command (alcaeus)
 * bug #22164 [Bridge\Doctrine] Fix change breaking doctrine-bundle test suite (nicolas-grekas)
 * bug #22159 [FrameworkBundle] Cache pool clear command requires at least 1 pool (ro0NL)
 * bug #22133 [Filesystem] normalize paths before making them relative (xabbuh)
 * bug #22138 [HttpFoundation][bugfix] $bags should always be initialized (MacDada)
 * bug #21810 #21809 [SecurityBundle] bugfix: if security provider's name contains upper cases then container didn't compile (Antanas Arvasevicius)
 * bug #22123 [WebProfilerBundle] Fix for CSS attribute at Profiler Translation Page (e-moe)
 * bug #19778 [Security] Fixed roles serialization on token from user object (eko)
 * bug #22036 Set Date header in Response constructor already (mpdude)
 * bug #22022 [Validator] fix URL validator to detect non supported chars according to RFC 3986 (e-moe)
 * bug #21849 [HttpFoundation] Fix missing handling of for/host/proto info from "Forwarded" header (nicolas-grekas)
 * bug #21968 Fixed pathinfo calculation for requests starting with a question mark. (syzygymsu)
 * bug #22027 Revert "bug #21841 [Console] Do not squash input changes made from console.command event (chalasr)" (chalasr)
 * bug #21846 [HttpFoundation] Fix Request::getHost() when having several hosts in X_FORWARDED_HOST (nicolas-grekas)
 * bug #21208 [Validator] Add object handling of invalid constraints in Composite (SenseException)
 * bug #22044 [Serializer] [XML] Ignore Process Instruction (jordscream)
 * bug #22090 [WebProfilerBundle] Fix Content-Security-Policy compatibility in case of a `style-src 'self'` policy (romainneutron)
 * bug #22079 [HttpKernel] Fixed bug with purging of HTTPS URLs (ausi)
 * bug #22045 [WebProfilerBundle] Handle Content-Security-Policy-Report-Only header correctly (romainneutron)
 * bug #21523 #20411 fix Yaml parsing for very long quoted strings (RichardBradley)
 * bug #22001 [Doctrine Bridge] fix priority for doctrine event listeners (dmaicher)
 * bug #22040 [FrameworkBundle] improve message when workflows are missing (xabbuh)
 * bug #22032 [FrameworkBundle] Fix translation dep constraint (chalasr)
 * bug #21996 [Cache] Enhance error reporting for FilesystemAdapter (nicolas-grekas)
 * bug #21981 [Console] Use proper line endings in BufferedOutput (julienfalque)
 * bug #21976 [VarDumper] Add missing isset() checks in some casters (nicolas-grekas)
 * bug #21973 [VarDumper] Add missing isset() checks in some casters (nicolas-grekas)
 * bug #21957 [Form] Choice type int values (BC Fix) (mcfedr)

* 3.2.6 (2017-03-10)

 * bug #21930 [Cache] Cached files rely on umask (4rthem)
 * bug #21946 Use PHPUnit 5.4 instead of 5.3 (j0k3r)
 * bug #21936 [PropertyAccess] Use ArrayAdapter in debug mode (chalasr)

* 3.2.5 (2017-03-09)

 * bug #21923 [travis] Test with hhvm 3.18 (nicolas-grekas)
 * bug #21793 [Workflow] Fixed marking state on leave and enter events (HeahDude)
 * bug #21912 [Yaml] dump escape sequences when possible (xabbuh)
 * bug #21908 [Cache] Fix Redis pipelining/multi-ops (nicolas-grekas)
 * bug #21823 dumpFile(), preserve existing file permissions (chs2)
 * bug #21880 [Form] Fixed overridden choices option in extended choice types (HeahDude)
 * bug #21896 [PHPunitBridge] Count @expectedDeprecation as an assertion (wouterj)
 * bug #21865 [Security] context listener: hardening user provider handling (xabbuh)
 * bug #21883 [HttpKernel] fix Kernel name when stored in a directory starting with a number (fabpot)
 * bug #21841 [Console] Do not squash input changes made from console.command event (chalasr)
 * bug #21481 [Form] Fixed empty conversion of Intl types (HeahDude)
 * bug #21671 [Serializer] Xml encoder throws exception for valid data (gr1ev0us)
 * bug #21805 Provide less state in getRequestFormat (dawehner)
 * bug #21851 Adding use statement for InvalidArgumentException (Nyholm)
 * bug #21832 [Routing] Ignore hidden directories when loading routes from annotations (jakzal)
 * bug #21769 [Form] Improve rounding precision (foaly-nr1)
 * bug #21825 [PhpUnitBridge] disable global test listener when not registered (xabbuh)
 * bug #21267 [Form] Fix ChoiceType to ensure submitted data is not nested unnecessarily (issei-m)
 * bug #21813 Update phpstorm helper to the official format (pierredup)
 * bug #21731 Fix emacs link (rubenrua)
 * bug #21802  Fix issues reported by static analyse (romainneutron)
 * bug #21800  Fix issues reported by static analyze (romainneutron)
 * bug #21782 [DependencyInjection] add missing dumped private services list in a container frozen constructor. (hhamon)
 * bug #21798 Revert "bug #21791 [SecurityBundle] only pass relevant user provider (xabbuh)" (xabbuh)
 * bug #21791 [SecurityBundle] only pass relevant user provider (xabbuh)
 * bug #21776 [Process] Fix ignoring of bad env var names (nicolas-grekas)
 * bug #21787 [PhpUnitBridge] do not register the test listener twice (xabbuh)
 * bug #21756 [Yaml] Stop replacing NULLs when merging (gadelat)
 * bug #21689 [WebServerBundle] fixed html attribute escape (Seb33300)
 * bug #21722 [ExpressionLanguage] Registering functions after calling evaluate(), compile() or parse() is not supported (maidmaid)
 * bug #21679 [SecurityBundle] fix priority ordering of security voters (xabbuh)
 * bug #21656 [DoctrineBridge] Fixed validating custom doctrine type columns (dmaicher)
 * bug #21115 [Validator] do not guess getter method names (xabbuh)
 * bug #21670 [DependencyInjection] Fix autowiring types when there are more than 2 services colliding (GuilhemN)
 * bug #21665 [DependencyInjection] Fix autowiring collisions detection (nicolas-grekas, GuilhemN)
 * bug #21661 Fix Composer constraints (fabpot)
 * bug #21582 [HttpCache] purge both http and https from http cache (dbu)
 * bug #21637 [FrameworkBundle] remove translation data collector when not usable (xabbuh)
 * bug #21647 [Yaml] consistently parse omitted keys as the colon (xabbuh)

* 3.2.4 (2017-02-16)

 * bug #21634 [VarDumper] Added missing persistent stream cast (lyrixx)
 * bug #21436 [DependencyInjection] check for circular refs caused by method calls (xabbuh)
 * bug #21400 [Serializer] fix upper camel case conversion (see #21399) (markusu49)
 * bug #21599 [Console][Table] fixed render when using multiple rowspans. (aitboudad)
 * bug #21613 [Process] Permit empty suffix on Windows (Bilge)
 * bug #21057 [DI] Auto register extension configuration classes as a resource (ro0NL)
 * bug #21607 Improve tracking of environment variables in the case of private services (tgalopin)
 * bug #21592 [Validator] property constraints can be added in child classes (angelk, xabbuh)
 * bug #21458 [Config] Early return for DirectoryResource (robfrawley)
 * bug #21562 [DoctrineBridge] make sure that null can be the invalid value (xabbuh)
 * bug #21556 [FrameworkBundle] Wire ArrayCache for annotation reader at bootstrap (nicolas-grekas)
 * bug #21584 [WebProfilerBundle] Readd Symfony version status in the toolbar (wouterj)
 * bug #21557 [VarDumper] Improve dump of AMQP* Object (lyrixx)
 * bug #21579 [Security] LdapUserProvider should not throw an exception if the UID key does not exist in an LDAP entry (csarrazi)
 * bug #21552 [FrameworkBundle] Fix annotations cache folder path (akeeman)
 * bug #21542 [VarDumper] Fixed dumping of terminated generator (lyrixx)
 * bug #21292 Ignore missing 'debug.file_link_formatter' service in Debug bundle (core23)

* 3.2.3 (2017-02-06)

 * bug #21528 [Cache] Fix class exists checks in PhpArrayAdapter (nicolas-grekas)
 * bug #20844 [Config] Fix checking cache for non existing meta file (hason)
 * bug #21063 [Form] Fixed DateType format option for single text widget (HeahDude)
 * bug #21430 Casting TableCell value to string. (jaydiablo)
 * bug #21359 [FrameworkBundle] fixed custom domain for translations in php templates (robinlehrmann)
 * bug #21485 [Process] Non ASCII characters disappearing during the escapeshellarg (GuillaumeVerdon)
 * bug #21370 [FrameworkBundle] Execute the PhpDocExtractor earlier (GuilhemN)
 * bug #21462 [BrowserKit] ignore invalid cookies expires date format (xabbuh)
 * bug #21438 [Console] Fix TableCell issues with decoration (ogizanagi)
 * bug #21431 [DoctrineBridge] always check for all fields to be mapped (xabbuh)
 * bug #21360 [PropertyAccess] Handle interfaces in the invalid argument exception (fancyweb)
 * bug #21403 [DI] Fix defaults overriding empty strings in AutowirePass (nicolas-grekas)
 * bug #21401 [Debug] Workaround "null" $context (nicolas-grekas)
 * bug #21381 [FrameworkBundle] Dont wire "annotations.cached_reader" before removing passes (nicolas-grekas)
 * bug #21387 Fix double escaping of the decision attributes in the profiler (stof)
 * bug #21372 [DependencyInjection] Fixed variadic method parameter in autowired classes (brainexe)
 * bug #21338 [Cache] Fix tags expiration (nicolas-grekas)
 * bug #21333 [HttpKernel] Fix ArgumentValueResolver for arguments default null (chalasr)
 * bug #20871 [HttpKernel] Give higher priority to adding request formats (akeeman)
 * bug #21332 [PropertyInfo] Don't try to access a property thru a static method (dunglas)
 * bug #21336 [PhpUnit] Blacklist DeprecationErrorHandler in stack traces (nicolas-grekas)
 * bug #21331 [PropertyInfo] Exclude static methods form properties guessing (dunglas)
 * bug #21280 [Workflow] Fixed support of multiple transitions with the same name. (lyrixx)
 * bug #21271 [Workflow] Added new validator to make sure each place has unique translation names (Nyholm)
 * bug #21323 [Cache] [PdoAdapter] Fix MySQL 1170 error (blob as primary key) (akeeman)
 * bug #21318 Don't add csp-headers if none are required (arjenm)
 * bug #21291 [Ldap] Ldap username case fix (quentinus95)
 * bug #21311 [Debug] Fix fatal error when changing ErrorHandler loggers if an exception is buffered (skalpa)
 * bug #21288 [Doctrine Bridge] fix UniqueEntityValidator for composite object primary keys (dmaicher, HeahDude)
 * bug #21285 [TwigBundle] do not lose already set method calls (xabbuh)
 * bug #21279 #20411 fix Yaml parsing for very long quoted strings (RichardBradley)
 * bug #21276 [Cache] Fix missing use statement in FilesystemAdapter (Lctrs)
 * bug #21269 [Cache] Using strpbrk() instead of strcspn() is faster (nicolas-grekas)

* 3.2.2 (2017-01-12)

 * bug #21257 [Profiler][Form] Fix form profiler errors profiler_dump (ogizanagi)
 * bug #21243 [FrameworkBundle] Fix class_exists() checks in PhpArrayAdapter-related cache warmers (nicolas-grekas, mpajunen)
 * bug #21218 [Form] DateTimeToLocalizedStringTransformer does not use timezone when using date only (magnetik)
 * bug #20605 [Ldap] Always have a valid connection when using the EntryManager (bobvandevijver)
 * bug #21104 [FrameworkBundle] fix IPv6 address handling in server commands (xabbuh)
 * bug #20793 [Validator] Fix caching of constraints derived from non-serializable parents (uwej711)
 * bug #19586 [TwigBundle] Fix bug where namespaced paths don't take parent bundles in account (wesleylancel)
 * bug #21237 [FrameworkBundle] Fix relative paths used as cache keys (nicolas-grekas)
 * bug #21183 [Validator] respect groups when merging constraints (xabbuh)
 * bug #21179 [TwigBundle] Fixing regression in TwigEngine exception handling (Bertalan Attila)
 * bug #21220 [DI] Fix missing new line after private alias (ogizanagi)
 * bug #21211 Classloader tmpname (lyrixx)
 * bug #21205 [TwigBundle] fixed usage when Templating is not installed (fabpot)
 * bug #21155 [Validator] Check cascasdedGroups for being countable (scaytrase)
 * bug #21200 [Filesystem] Check that directory is writable after created it in dumpFile() (chalasr)
 * bug #21186 [Bridge/PhpUnit] Relax expectedDeprecation for forward compat (nicolas-grekas)
 * bug #21184 [FrameworkBundle] Remove Response* from classes to compile (nicolas-grekas)
 * bug #21165 [Serializer] int is valid when float is expected when deserializing JSON (dunglas)
 * bug #21167 [Cache] Remove silenced warning tiggered by PhpArrayAdapter (nicolas-grekas)
 * bug #21166 [Cache] Fix order of writes in ChainAdapter (nicolas-grekas)
 * bug #21113 [FrameworkBundle][HttpKernel] Fix resources loading for bundles with custom structure (chalasr)
 * bug #20995 [DependencyInjection] Fix the priority order of compiler pass trait (francoispluchino)
 * bug #21084 [Yaml] handle empty lines inside unindented collection (xabbuh)
 * bug #21143 [PhpUnitBridge] Set COMPOSER_ROOT_VERSION while installing (nicolas-grekas)
 * bug #20925 [HttpFoundation] Validate/cast cookie expire time (ro0NL)
 * bug #21138 [PhpUnitBridge] skip tests with failure and error states too (xabbuh)
 * bug #21135 [PhpUnitBridge] hide stack trace of expected deprecation failures (xabbuh)
 * bug #21117 [Yaml] add missing indicator character (xabbuh)
 * bug #21121 [PhpUnitBridge] respect skipped and incomplete tests (xabbuh)
 * bug #21032 [SecurityBundle] Made collection of user provider unique when injecting them to the RemberMeService (lyrixx)
 * bug #21078 [Console] Escape default value when dumping help (lyrixx)
 * bug #21076 [Console] OS X Can't call cli_set_process_title php without superuser (ogizanagi)
 * bug #20900 [Console] Descriptors should use Helper::strlen (ogizanagi)
 * bug #21025 [Cache] remove is_writable check on filesystem cache (4rthem)
 * bug #21064 [Debug] Wrap call to ->log in a try catch block (lyrixx)
 * bug #21069 [Debug] Fixed cast of stream (lyrixx)
 * bug #21010 [Debug] UndefinedMethodFatalErrorHandler - Handle anonymous classes (SpacePossum)
 * bug #20991 [cache] Bump RedisAdapter default timeout to 5s (Nicofuma)
 * bug #20959 [FrameworkBundle] Ignore AnnotationException exceptions in the AnnotationsCacheWarmer (fancyweb)
 * bug #20795 [FrameworkBundle] Allow multiple transitions with the same name (Padam87)
 * bug #20859 Avoid warning in PHP 7.2 because of non-countable data (wouterj)
 * bug #21053 [Validator] override property constraints in child class (xabbuh)
 * bug #21034 [FrameworkBundle] Make TemplateController working without the Templating component (dunglas)
 * bug #20970 [Console] Fix question formatting using SymfonyStyle::ask() (chalasr, ogizanagi)
 * bug #20999 [HttpKernel] Continuation of #20599 for 3.1 (ro0NL)
 * bug #20975 [Form] fix group sequence based validation (xabbuh)
 * bug #20599 [WebProfilerBundle] Display multiple HTTP headers in WDT (ro0NL)
 * bug #20799 [TwigBundle] do not try to register incomplete definitions (xabbuh)
 * bug #20961 [Validator] phpize default option values (xabbuh)
 * bug #20934 [FrameworkBundle] Fix PHP form templates on translatable attributes (ro0NL)
 * bug #20957 [FrameworkBundle] test for the Validator component to be present (xabbuh)
 * bug #20936 [DependencyInjection] Fix on-invalid attribute type in xsd (ogizanagi)
 * bug #20931 [VarDumper] Fix dumping by-ref variadics (nicolas-grekas)
 * bug #20749 [FrameworkBundle] Smarter default for framework.annotations (ogizanagi)
 * bug #20734 [Security] AbstractVoter->supportsAttribute gives false positive if attribute is zero (0) (martynas-foodpanda)
 * bug #14082 [config] Fix issue when key removed and left value only (zerustech)
 * bug #20910 [HttpFoundation] Fix cookie to string conversion for raw cookies (ro0NL)
 * bug #20909 Fix misresolved parameters in debug:config on 3.2 (chalasr)
 * bug #20904 [TwigBundle] Config is now a hard dependency (dunglas)
 * bug #20847 [Console] fixed BC issue with static closures (araines)

* 3.2.1 (2016-12-13)

 * bug #20891 Add support for REDIS_URL environment variables. (robinvdvleuten)
 * bug #20724 [WebProfilerBundle] Fix AJAX panel with fetch requests (OnekO)
 * bug #20883 Don’t compile when Opcache is not enabled on CLI (ruudk)
 * bug #20877 DateIntervalType: 'invert' should not inherit the 'required' option (galeaspablo)
 * bug #20886 [Form] DateIntervalType: Do not try to translate choices (ogizanagi)
 * bug #20855 [Yaml] do not trigger deprecations for valid YAML (xabbuh)
 * bug #20714 [FrameworkBundle] Fix unresolved parameters from default configs in debug:config (chalasr)
 * bug #20862 Allow simple-phpunit to be used with an HTTP proxy (Cydonia7)
 * bug #20882 [TwigBridge] fix constructor args check (xabbuh)
 * bug #20860 [WebProfilerBundle] Fix a web profiler form issue with fields added to the form after the form was built (tgalopin)
 * bug #20442 [FrameworkBundle] Bundle commands are not available via find() (julienfalque)
 * bug #20840 [WebProfilerBundle] add dependency on Twig (xabbuh)
 * bug #20833 [HttpKernel] Fix open_basedir compat in DataCollector (nicolas-grekas)
 * bug #20828 [Validator] Fix init of YamlFileLoader::$classes for empty files (nicolas-grekas)
 * bug #20688 [FrameworkBundle] Resolve env params in debug:config command (nicolas-grekas)
 * bug #20725 [HttpKernel] Fix annotation cache warmer with failing or missing classes (nicolas-grekas)
 * bug #20830 [FrameworkBundle] Fix validation cache warmer with failing or missing classes (nicolas-grekas)
 * bug #20760 [FrameworkBundle] [Workflow] Fix service marking store configuration (fduch)
 * bug #20745 [Validator] add class name to the cache key (Simperfit)
 * bug #20530 [Serializer] Remove AbstractObjectNormalizer::isAttributeToNormalize (dunglas)
 * bug #19141 Throw less misleading exception when property access not found (bramtweedegolf)
 * bug #20539 Cast result to int before adding to it (alcaeus)
 * bug #20831 [Twig] Fix deprecations with Twig 1.29 (nicolas-grekas)
 * bug #20701 Ignore missing 'debug.file_link_formatter' service in Debug and Twig bundles (mbabker)
 * bug #20816 [FrameworkBundle] Removed kernel.debug from the cache pool namespace seed (Sander Toonen)
 * bug #20769 [Bridge\Twig] Trigger deprecation when using FormExtension::$renderer (nicolas-grekas)
 * bug #20646 Maintain the selected panel when redirecting to another profile (javiereguiluz)
 * bug #20767 [Cache] Fix dumping SplDoublyLinkedList iter mode (nicolas-grekas)
 * bug #20690 [Serializer] Fix argument object denormalization (ogizanagi)
 * bug #20762 [Form] Fix FormDataCollector (nicolas-grekas, Padam87)
 * bug #20747 [HttpKernel] Fixed RequestDataCollector handling of null header values. (Gabriel Moreira)
 * bug #20727 [TwigBundle] Inject project root path into twig filesystem loader (4rthem)
 * bug #20736 [Console] fixed PHP7 Errors when not using Dispatcher (keradus)
 * bug #20756 [HttpKernel] Regression test for missing controller arguments (iltar)
 * bug #20755 [HttpKernel] Regression test for missing controller arguments (iltar)
 * bug #20732 fix the inline level for dumped multi-line strings (xabbuh)
 * bug #20418 [Form][DX] FileType "multiple" fixes (yceruto)
 * bug #19902 [DependencyInjection] PhpDumper.php: hasReference() shouldn't search references in lazy service. (antanas-arvasevicius)
 * bug #20704 [Console] Fix wrong handling of multiline arg/opt descriptions (ogizanagi)
 * bug #20700 [WebProfilerBundle][Translator] Fix TranslationDataCollector should use cloneVar (ogizanagi)
 * bug #20712 [TwigBundle] Fix twig loader registered twice (ogizanagi)
 * bug #20716 [WebProfilerBundle] Fix dump block is unfairly restrained (ogizanagi)
 * bug #20717 Fix hide button in toolbar (nicolasdewez)

* 3.2.0 (2016-11-30)

 * bug #20687 [FrameworkBundle] Forbid env parameters in routing configuration (nicolas-grekas)
 * bug #20607 [Validator] Bring egulias/email-validator ~2.0 to parity with ~1.2 (Lctrs)
 * bug #20671 [Config] ConfigCache::isFresh() should return false when unserialize() fails (nicolas-grekas)
 * bug #20679 [VarDumper] Use default color for ellipsed namespaces/paths (nicolas-grekas)
 * bug #20676 [ClassLoader] Use only forward slashes in generated class map (nicolas-grekas)
 * bug #20664 [Validator] ensure the proper context for nested validations (xabbuh)
 * bug #20661 bug #20653 [WebProfilerBundle] Profiler includes ghost panels (jzawadzki)
 * bug #20652 Fixed getRouteParams() when no parameters are available (wouterj)

* 3.2.0-RC2 (2016-11-27)

 * bug #20601 [FrameworkBundle] Don't rely on any parent definition for "cache.annotations" (nicolas-grekas)
 * bug #20638 Fix legacy tests that do not trigger any depreciation (julienfalque)
 * bug #20374 [FrameworkBundle] Improve performance of ControllerNameParser (enumag)
 * bug #20474 [Routing] Fail properly when a route parameter name cannot be used as a PCRE subpattern name (fancyweb)
 * bug #20616 [Bridge/Doctrine] Use cache.prefix.seed parameter for generating cache namespace (nicolas-grekas)
 * bug #20566 [DI] Initialize properties before method calls (ro0NL)
 * bug #20583 [Workflow] Fixed graphviz dumper for state machine (lyrixx)
 * bug #20621 [HttpKernel] Fix exception when serializing request attributes (nicolas-grekas)
 * bug #20609 [DI] Fixed custom services definition BC break introduced in ec7e70fb… (kiler129)
 * bug #20598 [DI] Aliases should preserve the aliased invalid behavior (nicolas-grekas)
 * bug #20600 [Process] Fix process continuing after reached timeout using getIterator() (chalasr)
 * bug #20603 [HttpKernel] Deprecate checking for cacheable HTTP methods in Request::isMethodSafe() (nicolas-grekas)
 * bug #20602 [HttpKernel] Revert BC breaking change of Request::isMethodSafe() (nicolas-grekas)
 * bug #20610 [FrameworkBundle] Add framework.cache.prefix_seed for predictible cache key prefixes (nicolas-grekas)
 * bug #20595 [WebProfilerBundle] Fix deprecated uses of profiler_dump (nicolas-grekas)
 * bug #20589 [SecurityBundle] Fix FirewallConfig nullable arguments (ogizanagi)
 * bug #20590 [DI] Allow null as default env value (sroze)
 * bug #20499 [Doctrine][Form] support large integers (xabbuh)
 * bug #20559 [FrameworkBundle] Avoid warming up the validator cache for non-existent class (Seldaek)
 * bug #20576 [Process] Do feat test before enabling TTY mode (nicolas-grekas)
 * bug #20577 [FrameworkBundle] Mark cache.default_*_provider services private (nicolas-grekas)
 * bug #20550 [YAML] Fix processing timestamp strings with timezone (myesain)
 * bug #20543 [DI] Fix error when trying to resolve a DefinitionDecorator (nicolas-grekas)
 * bug #20544 [PhpUnitBridge] Fix time-sensitive tests that use data providers (julienfalque)

* 3.2.0-RC1 (2016-11-17)

 * feature #20533 [DI] Revert "deprecate get() for uncompiled container builders" (nicolas-grekas)
 * bug #20525 [TwigBundle] Give some love to exception pages (nicolas-grekas)
 * bug #20484 bumped min version of Twig to 1.28 (fabpot)
 * bug #20512 [DI] Fix accepting null as default env param value (nicolas-grekas)
 * bug #20519 [Debug] Remove GLOBALS from exception context to avoid endless recursion (Seldaek)
 * bug #20455 [ClassLoader] Fix ClassCollectionLoader inlining with __halt_compiler (giosh94mhz)
 * bug #20307 [Form] Fix Date\TimeType marked as invalid on request with single_text and zero seconds (LuisDeimos)
 * bug #20432 [FrameworkBundle] Add --no-prefix option to translation:update (chalasr)
 * bug #20480 [FrameworkBundle] Register the ArrayDenormalizer (dunglas)
 * bug #20286 [Serializer] Fix DataUriNormalizer's regex (dunglas)
 * bug #20466 [Translation] fixed nested fallback catalogue  using multiple locales. (aitboudad)
 * bug #20465 [#18637][TranslationDebug] workaround for getFallbackLocales. (aitboudad)
 * bug #20453 [Cache] Make directory hashing case insensitive (nicolas-grekas)
 * bug #20428 [TwigBundle] fixed template root path (fabpot)
 * feature #20447 [DI] Force env params to be string|null (nicolas-grekas)
 * feature #20451 [Workflow] Added Definition builder (Nyholm)
 * bug #20460 [FrameworkBundle] Fixed WorkflowCommand to support state machines (HeahDude)
 * bug #20440 [TwigBridge][TwigBundle][HttpKernel] prefer getSourceContext() over getSource() (xabbuh)
 * feature #19629 [Workflow] Make the Workflow support State Machines (Nyholm, lyrixx)
 * bug #20287 Properly format value in UniqueEntityValidator (alcaeus)
 * bug #20422 [Translation][fallback] add missing resources in parent catalogues. (aitboudad)
 * bug #20378 [Form] Fixed show float values as choice value in ChoiceType (yceruto)
 * feature #20416 [Bridge\Monolog][FrameworkBundle] Add & wire a DebugProcessor (nicolas-grekas)
 * bug #20415 [DI][Serializer] Add missing deprecations (nicolas-grekas)
 * bug #20294 Improved the design of the metrics in the profiler (javiereguiluz)
 * bug #20375 [HttpFoundation][Session] Fix memcache session handler (klandaika)
 * bug #20377 [Console] Fix infinite loop on missing input (chalasr)
 * feature #20232 [DependencyInjection] fixed ini file values conversion (fabpot)
 * feature #19490 [SecurityBundle] Integrate current firewall in Profiler (chalasr)
 * feature #19398 [DX][SecurityBundle] Introduce a FirewallConfig class accessible from FirewallContext (chalasr)
 * bug #20336 [HttpKernel] Base DataCollector throws warning on unsupported scheme strings (ogizanagi)
 * bug #20335 [Yaml] Fix String offset cast error in Inline parser (romainneutron)
 * bug #20372 [Console] simplified code (fabpot)
 * bug #20342 [Form] Fix UrlType transforms valid protocols (ogizanagi)
 * bug #20341 Fix YamlReferenceDumper unnamed nested prototypes (ogizanagi)
 * bug #20292 Enhance GAE compat by removing some realpath() (nicolas-grekas)
 * bug #20325 [VarDumper] Fix source links to Twig files (nicolas-grekas)
 * bug #20328 [Console] Fix empty COLUMNS/LINES env vars (nicolas-grekas)
 * bug #20326 [VarDumper] Fix dumping Twig source in stack traces (nicolas-grekas)
 * bug #20321 Compatibility with Twig 1.27 (xkobal)

* 3.2.0-BETA1 (2016-10-27)

 * feature #19973 Added a default ide file link web view (jeremyFreeAgent)
 * feature #20285 [TwigBundle] made Twig cache independent of the project root directory (fabpot)
 * feature #20266 [Console] rename Command::private to Command::hidden (xabbuh)
 * feature #20270 [PhpUnitBridge] Drop ErrorAssert (nicolas-grekas)
 * feature #20256 [PhpUnitBridge] Allow configuring removed deps and phpunit versions (nicolas-grekas)
 * feature #20255 [PhpUnitBridge] Replace ErrorAssert by `@expectedDeprecation` (nicolas-grekas)
 * feature #20047 [Form] Change FormTypeGuesserChain to accept Traversable (enumag)
 * feature #19982 [Validator] Allow validating multiple groups in one GroupSequence step (enumag)
 * feature #19741 [ExpressionLanguage] Making cache PSR6 compliant (Alexandre GESLIN)
 * feature #20217 [Serializer] Support specifying format for DateTimeNormalizer::denormalize (teohhanhui)
 * feature #19452 Remove the new SecurityUserValueResolver (weaverryan)
 * feature #15002 [DoctrineBridge] Add a way to select the repository used by the UniqueEntity validator (ogizanagi)
 * feature #20113 Use the method map as authoritative list of factories for dumped containers (stof)
 * feature #19576 [WebProfiler] added support for window.fetch calls in ajax section (ivoba)
 * feature #19991 [TwigBridge] Added access to token from twig AppVariable (HeahDude)
 * feature #20029 Hide commands from ApplicationDescriptor, but allow invoking (jwdeitch, Jordan Deitch)
 * feature #20121 Class existence resource (fabpot)
 * feature #20119 [TwigBundle] changed the runtime loader to return null if there is no match (fabpot)
 * feature #20093 Twig extensions refatoring to decouple definitions from implementations (fabpot)
 * feature #20094 added Twig runtimes for "critical" Twig extensions (fabpot)
 * feature #20097 [FrameworkBundle] removed the Doctrine Annotations lib dependency on FrameworkBundle (fabpot)
 * feature #20019 [FrameworkBundle] Add phpstorm ide (hason)
 * feature #20092 added a Twig runtime loader (fabpot)
 * feature #20075 [FrameworkBundle] removed the Security Core and Security CSRF component dependencies on FrameworkBundle (fabpot)
 * feature #20072 [FrameworkBundle] removed the Templating component dependency on FrameworkBundle (fabpot)
 * feature #20070 [FrameworkBundle] removed the Translation component dependency on FrameworkBundle (fabpot)
 * feature #20067 [FrameworkBundle] removed the Asset component dependency on FrameworkBundle (fabpot)
 * feature #20037 [Cache] Handle arbitrary key length when the backend cant using hashing (nicolas-grekas)
 * feature #20040 [Bridge/PhpUnit] Handle native E_DEPRECATED (nicolas-grekas)
 * feature #19987 [VarDumper] Use ClassStub for reflected types (nicolas-grekas)
 * feature #20012 [Translation] added Base Exception for the component. (aitboudad)
 * feature #19996 removed obsolete images (since 2.2) (fabpot)
 * feature #19997 inlined some CSS (fabpot)
 * feature #19304 [Yaml] fix parsing multi-line mapping values (xabbuh)
 * feature #19191 [DependencyInjection] Automatically detect the definitions class when possible (Ener-Getick)
 * feature #19745 [Validator] Added context object method callback to choice validator (Peter Bouwdewijn)
 * feature #19614 [HttpKernel] Use VarDumper in the profiler (wouterj, nicolas-grekas)
 * feature #19480 [Config] Fix (Yaml|Xml)ReferenceDumper for nested prototypes (ogizanagi)
 * feature #19681 [DI] Allow injecting ENV parameters at runtime using env(MY_ENV_VAR) (nicolas-grekas)
 * feature #19197 [Serializer][FrameworkBundle] Add a CSV encoder (dunglas)
 * feature #19257 [Validator][Choice] Make strict the default option for choice validation (peterrehm)
 * feature #19326 [Serializer][FrameworkBundle] Add a YAML encoder (dunglas)
 * feature #19484 [PropertyInfo] Extract the logic converting a php doc to a Type (Ener-Getick)
 * feature #19495 [master][console] Allow multiple options to be set. (SpacePossum)
 * feature #19584 [DependencyInjection] Improve ParameterNotFoundException when accessing a nested parameter (wouterj)
 * feature #19485 [FrameworkBundle] Introduce a cache warmer for Validator based on PhpArrayAdapter (tgalopin)
 * feature #19790 [FrameworkBundle] add support for prioritizing form type extension tags (dmaicher)
 * feature #19507 [FrameworkBundle] Introduce a cache warmer for Serializer based on PhpArrayAdapter (tgalopin)
 * feature #19734 [HttpFoundation] Deprecate extending some methods (Ener-Getick)
 * feature #19795 Replace count with a given number out of the box (bocharsky-bw)
 * feature #19807 [FrameworkBundle] Add debug.file_link_format with remapping for IDE links (nicolas-grekas)
 * feature #19891 [FrameworkBundle] Add cache:pool:clear command (nicolas-grekas)
 * feature #19900 [FrameworkBundle] Add CachePoolClearerPass for weak cache pool refs in cache clearers (nicolas-grekas)
 * feature #19570 [Config] Fix YamlReferenceDumper prototyped array support (ogizanagi)
 * feature #19824 [Console] Add ability to regress the ProgressBar (jameshalsall)
 * feature #19892 [DI] Add corresponding service id in some exception messages (nicolas-grekas)
 * feature #19843 [Security] Allow run-time configuration of hash algo (nicolas-grekas)
 * feature #19894 [Cache] Add "persistent_id" option to RedisAdapter::createConnection() (nicolas-grekas)
 * feature #19915 [Bridge/PhpUnit] Add bin/simple-phpunit wrapper (=phpunit - yaml - prophecy) (nicolas-grekas)
 * feature #19826 [VarDumper] Add ClassStub for clickable & shorter PHP identifiers (nicolas-grekas)
 * feature #19816 [VarDumper] Add LinkStub to create links in HTML dumps (nicolas-grekas)
 * feature #19768 [VarDumper] Enhance dumping arguments in stack traces (nicolas-grekas)
 * feature #19796 [VarDumper] Make the line clickable to toggle dumps (nicolas-grekas)
 * feature #19764 [Config] Add ExprBuilder::ifEmpty() (ogizanagi)
 * feature #19797 [VarDumper] Handle attributes in Data clones for more semantic dumps (nicolas-grekas)
 * feature #19755 [VarDumper] Get dump as string with `$dumper->dump(..., true);` (nicolas-grekas)
 * feature #19604 [Routing] Add seamless support for unicode requirements (nicolas-grekas)
 * feature #19714 [VarDumper] Handle "title" attribute on virtual properties (nicolas-grekas)
 * feature #19687 [FrameworkBundle] Use relative paths in templates paths cache (tgalopin)
 * feature #19339 [WebProfilerBundle][Form][DX] To expand the form nodes that contains children with errors (yceruto)
 * feature #19519 [Cache] Add PDO + Doctrine DBAL adapter (nicolas-grekas)
 * feature #19672 [VarDumper] Allow dumping subparts of cloned Data structures (nicolas-grekas)
 * feature #19657 [VarDumper] Add line in trace indexes (nicolas-grekas)
 * feature #19639 [Routing] Generate URLs in compliance with PHP_QUERY_RFC3986 (jameshalsall)
 * feature #19568 [Debug] Better error handling (lyrixx)
 * feature #19552 [HttpFoundation] Add named constructor on JsonResponse (tyx)
 * feature #19630 [VarDumper] Enhance dumping __PHP_Incomplete_Class objects (nicolas-grekas)
 * feature #19515 [Cache] Drop TaggedCacheItemInterface (nicolas-grekas)
 * feature #19511 Use a dedicated exception in the file locator (leofeyer)
 * feature #19529 Add Yaml::PARSE_EXCEPTION_ON_DUPLICATE to throw exceptions on duplicates (Alex Pott)
 * feature #19473 [Security] Expose the required roles in AccessDeniedException (Nicofuma)
 * feature #19524 [Cache] Add generic TagAwareAdapter wrapper (replaces TagAwareRedisAdapter) (nicolas-grekas)
 * feature #19504 [Yaml] deprecate missing space after mapping key colon (xabbuh)
 * feature #19430 [DomCrawler] Add support for XPath expression evaluation (jakzal)
 * feature #19205 [HttpKernel] Allow bundles to declare classes and annotated classes to compile using patterns (tgalopin)
 * feature #18533 [FrameworkBundle] Wire PhpArrayAdapter with a new cache warmer for annotations (tgalopin)
 * feature #17498 [Filesystem] Add a cross-platform readlink method (tgalopin)
 * feature #19289 [VarDumper] Dumping exceptions is now more compact (nicolas-grekas)
 * feature #19276 [ClassLoader] Add ClassCollectionLoader::inline() to generate inlined-classes files (nicolas-grekas)
 * feature #19325 [FrameworkBundle] Allow to specify a domain when updating translations (antograssiot)
 * feature #19277 [Serializer] Argument objects (theofidry, dunglas)
 * feature #19322 [HttpFoundation] Add Request::isMethodIdempotent method (dunglas)
 * feature #18510 Added a SecurityUserValueResolver for controllers (iltar)
 * feature #19203 [Bridge/Doctrine] Reset the EM lazy-proxy instead of the EM service (nicolas-grekas)
 * feature #19236 [FrameworkBundle] Deprecate the service serializer.mapping.cache.doctrine.apc (Ener-Getick)
 * feature #19174 [FrameworkBundle] Show server:run logs by default (nicolas-grekas)
 * feature #19137 [Serializer] Allow to use easily static constructors (Ener-Getick)
 * feature #19146 [DependencyInjection] deprecate access to private shared services. (hhamon)
 * feature #19190 [DependencyInjection] Add support for short services configurators syntax (voronkovich)
 * feature #18823 [Cache] Add PhpArrayAdapter to use shared memory on PHP 7.0 (tgalopin)
 * feature #18948 [VarDumper] Add maxDepth & maxStringLength display options (MGDSoft, nicolas-grekas)
 * feature #18626 [Yaml] Added support for parsing PHP constants (HeahDude)
 * feature #19104 Adds support for the SameSite attribute in cookies. (iangcarroll)
 * feature #19153 [Validator] support egulias/email-validator 2.x (xabbuh)
 * feature #11394 [Routing] support for array values in route defaults (xabbuh)
 * feature #11882 [Workflow] Introducing the workflow component (fabpot, lyrixx)
 * feature #19151 [VarDumper] Add support for XmlReader objects (Taluu)
 * feature #18471 [Console] Add Lockable trait (geoffrey-brier)
 * feature #19139 [FrameworkBundle][Yaml] Move YamlLintCommand to the Yaml component (chalasr)
 * feature #19143 Response headers fix (fabpot)
 * feature #16809 [Form][FrameworkBundle][Bridge] Add a DateInterval form type (MisatoTremor)
 * feature #18466 [Bridge][Twig] Optionally pass dumper into DumpExtension (CarsonF)
 * feature #18022 [DependencyInjection] Sort the CompilerPass by priority (Ener-Getick)
 * feature #19090 [Console] Add ConsoleLogger::hasErrored() (nicolas-grekas)
 * feature #19079 [Debug] Do not quote numbers in stack trace (c960657)
 * feature #19012 [Console] progress bar fix (TomasVotruba, fabpot)
 * feature #19047 [Cache] Add tags based invalidation + TagAwareRedisAdapter (nicolas-grekas)
 * feature #17644 Deprecate using Form::isValid() with an unsubmitted form (Ener-Getick)
 * feature #12979 [Router] added appending of new optional document fragment (rodnaph)
 * feature #18710 [Console] Simplify simulation of user inputs in CommandTester (chalasr)
 * feature #18999 [Console] Centralize input stream in base Input class (chalasr)
 * feature #19060 [ExpressionLanguage] Add a way to hook on each node when dumping the AST (nicolas-grekas)
 * feature #18880 [PhpUnitBridge] add a triggered errors assertion helper (xabbuh)
 * feature #16906 [Console] Better support for one command app (lyrixx)
 * feature #17203 Move Constraint validator test case to Test namespace (WouterJ)
 * feature #18502 [FrameworkBundle] Add file helper to Controller (dfridrich)
 * feature #19053 [Process] Allow inheriting env vars instead of replacing them (nicolas-grekas)
 * feature #18833 [HttpKernel] Move duplicated logic from Esi/Ssi to an AbstractSurrogate (chalasr)
 * feature #18220 Don't send default cache header for 301 redirects (e-moe)
 * feature #17662 [Translation][transChoice] allows escaping the pipe character. (aitboudad)
 * feature #18322 [DomCrawler] Attach label to form fields (carlosV2)
 * feature #18482 Created a trait to sort tagged services (iltar)
 * feature #15458 [Filesystem] Add feature to create hardlinks for files (andrerom)
 * feature #18940 [Console] Add path argument to dump a specific option in debug:config (chalasr)
 * feature #19013 [ExpressionLanguage] Added a way to dump the AST (lyrixx)
 * feature #18332 [Form] added `CallbackChoiceLoader` and refactored ChoiceType's children (HeahDude)
 * feature #18869 [Routing] Throw exception when PHP start tag is missing (WouterJ)
 * feature #18781 [Console] Display errors in quiet mode (multi-io)
 * feature #19011 [HttpKernel] Add convenient method ArgumentResolver:: getDefaultArgumentValueResolvers (romainneutron)
 * feature #18568 [WebProfilerBundle] Fix bundle usage in Content-Security-Policy context without unsafe-inline (romainneutron)
 * feature #16838 [PropertyAccess] Add PSR-6 cache (dunglas)
 * feature #18790 [Console] Show aliases in command description instead of in different lines in application description (juanmirod)
 * feature #18728 deprecate get() for uncompiled container builders (xabbuh)
 * feature #18483 [Serializer] Deprecate SerializerAwareEncoder (JhonnyL)
 * feature #18337 [PropertyInfo] Support singular adder and remover (dunglas)
 * feature #18894 [Cache] Added PhpFilesAdapter (trakos, nicolas-grekas)
 * feature #18964 [PhpUnitBridge] Make DnsMock match namespaces that begin with Tests\\ (teohhanhui)
 * feature #18726 [PhpUnitBridge] Make ClockMock match namespaces that begin with Tests\\ (teohhanhui)
 * feature #18825 [Cache] Create NullAdapter to disable cache if needed (tgalopin)
 * feature #18675 [VarDumper] Add Redis caster (nicolas-grekas)
 * feature #18785 [Yaml] deprecate comma separators in floats (xabbuh)
 * feature #18486 [Yaml] Allow using _ in some numeric notations (Taluu)
