// Copyright (C) 2009 Martin Sandve Alnes
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.
//
// First added:  2009-01-01
// Last changed: 2009-04-01
//
// This demo program computes a projection in 1D.

#include <dolfin.h>
#include "generated_code/Projection1D.h"

using namespace dolfin;
using namespace Projection1D;

class Weight: public Expression 
{
public:
  void eval(Array<double>& values, const Array<double>& x) const
  {
    values[0] = 1.0;
  }
};

class Source: public Expression 
{
public:
  void eval(Array<double>& values, const Array<double>& x) const
  {
    double dx = x[0] - 0.5;
    values[0] = dx*dx;
  }
};

int main()
{
  // Geometry
  UnitInterval mesh(20);

  // Function spaces
  BilinearForm::TrialSpace V(mesh);
  CoefficientSpace_c C(mesh);
  CoefficientSpace_f F(mesh);

  // Functions
  Weight c;
  Source f;
  Function u(V);

  // Forms
  BilinearForm a(V, V);
  LinearForm L(V);

  // Form coefficients
  a.c = c;
  L.f = f;

  u = Function(V);
  solve(a == L, u); 

  // Write solution to file
  File u_file("u.pvd");
  u_file << u;

  // Interpolate f onto the discrete space V
  Source source;
  Function finterpolated(V);
  finterpolated.interpolate(source); 

  // Write interpolated solution to file
  File f_file("f.pvd");
  f_file << finterpolated;
  
  //plot(u);
  
  return 0;
}

