/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_FILE_H
#define _SC_UTIL_FILE_H

// sc
namespace sc {
  class Error;
}

// apr
#include <apr_errno.h> // apr_status_t
struct apr_pool_t;
struct apr_file_t;
struct apr_finfo_t;
struct apr_mmap_t;


typedef apr_off_t sc_size_t;

/**
 * Wrapper class for apr_file_t
 */
class File
{
public:
  File( const char* file, apr_pool_t* pool = 0 );
  virtual ~File();

  const sc::Error* open();
  const sc::Error* close();

  bool exists();
  sc_size_t getSize() const;

  const sc::Error* mmap();
  const sc::Error* unmmap();
  bool ismmaped() const;
  void* mmaped() const;

  //apr_file_t* getFile() const;

private:
  apr_pool_t* _pool;
  const char* _filename;

  bool         _open;
  apr_file_t*  _file;
  apr_finfo_t* _finfo;

  bool         _mmaped;
  apr_mmap_t*  _mmap;
};

#endif // _SC_UTIL_FILE_H
