/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COLORSETTINGSINFO_H
#define _SC_COLORSETTINGSINFO_H

// sc
#include "SettingsInfoBase.h"
#include "ColorSettings.h"
class SettingsWidget;

// qt
#include <QtCore/QString>
#include <QtGui/QFont>


class ColorSettingsInfo : public SettingsInfoBase
{
public:
  ColorSettingsInfo( const QString& title, const QString& id, ColorSettings* fs, int sortIndex );
  ~ColorSettingsInfo();

  const QString& getTitle();
  const QString& getSettingsId();

  void initWidgetData( SettingsWidget* sw );
  void storeWidgetData( SettingsWidget* sw );
  
  bool isModified();

  void ok();
  void apply();
  void cancel();

  int getSortIndex();

private:
  QString       _title;
  QString       _id;

  int           _sortIndex;

  ColorSettings* _cs;

  Colors         _modColors;
  Colors         _newColors;
};


#endif //  _SC_COLORSETTINGSINFO_H
