/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STATUSCMD2_H
#define _SC_STATUSCMD2_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class StatusParam;
class StatusResult;

/**
 * Command for getting status information of a working copy.
 */
class StatusCmd2 : public ScCmd
{
public:
  /**
   * Construct a StatusCmd2.
   *
   * \param param the parameters for the command.
   * \param sr the callback to get and set cache information. 
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  StatusCmd2( StatusParam* param, StatusResult* sr, CmdResultCallback* cb );
  ~StatusCmd2();

  void run();

private:
  // in
  StatusParam*       _param;

  // out
  StatusResult*      _sr;
  CmdResultCallback* _cb;
};

#endif // _SC_STATUSCMD2_H
