/* ====================================================================
 * Copyright 2006,          Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "RepositoryCache.h"
#include "RpListInfo.h"

RepositoryCache::RepositoryCache()
{
}

void RepositoryCache::setRpList( const sc::String& url, svn::Revnumber rev, const svn::DirEntries& list )
{
  RpListInfo info( url, rev, apr_time_now(), list );
  _cache.set(info);
}

bool RepositoryCache::getRpList( const sc::String& url, svn::Revnumber rev, svn::DirEntries& list )
{
  RpListInfo info = _cache.get( url, rev );
  list = info.getDirEntries();
  return !info.isEmpty();
}
