/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "ErrorHandler.h"
#include "sublib/Utility.h"
#include "sublib/MessageBox.h"
#include "util/Error.h"
#include "util/Condition.h"



ErrorHandler::ErrorHandler( const sc::Error* error, sc::Condition* cond )
 : _error(error), _cond(cond)
{
}

ErrorHandler::~ErrorHandler()
{
  delete _error;
}

void ErrorHandler::run( QWidget* parent )
{
  QString msg = QString(
    "<qt>"
     "<center>"
      "<table width=\"500\">"
       "<tr>"
        "<td>" "%1" "</td>"
       "</tr>"
       ).arg( QString::fromUtf8(_error->getMessage()) );

  const sc::Error* nested = _error->getNested();
  while( nested != sc::Success )
  {
    QString nmsg = QString(
      "<tr>"
       "<td>" "%1" "</td>"
      "</tr>"
      ).arg( QString::fromUtf8(nested->getMessage()) );

    msg   += nmsg;
    nested = nested->getNested();
  }

  msg += 
      "<table>"
     "</center>"
    "</qt>";

  msgCritical( _q("subcommander:error"), msg, _q("&Ok") );

  if( _cond )
  {
    _cond->wakeAll();
  }
}
