/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [ptm_pp.h]          Parse Tree Transformation & Pretty Printing          */
/*                                                                          */
/* Copyright (c) 1995 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef ptm_pp_INCL
#define ptm_pp_INCL


#include "ptm.h"
#include "prs.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   The module [ptm_pp] supports some means for source-source-transformations.

   1) It performs a tree-to-tree transformation based on the corresponding
      grammar specifications. It handles comments, too.

      source tree based on CFG 1
      specification of CFG 2
      -------------------------------------------->  concrete target tree
      abstraction(CFG 1)   = abstraction(CFG 2)      based on CFG 2
      regexp(token(CFG 1)) = regexp(token(CFG 2))

   2) It provides the pretty printing of parse trees. This is usefull after
      a transformation, because the target tree doesn't contain any position
      information.

   Note:
   This module is still under construction. The main thing todo refer to the
   layout results which are some times broken.
   Embedded languages won't be supported, either.

   Using the reentrant interface functions you can perform multiple
   transformations at a time.
*/

/* ---------------------------- Macros ------------------------------------- */

/* 
  <p><b>Token separation types</b>
*/

#define PTP_SEP_NON 0 // none
#define PTP_SEP_SPC 1 // space
#define PTP_SEP_IND 2 // indent
#define PTP_SEP_ROW 3 // row

AbstractType(PTP_T) /* Abstract transformation and pp type */
;

/* ---------------------------- Init & Quit -------------------------------- */

void PTP_init(PLR_Tab tab)
/* initializes transformation and pretty printing
   based on parse table 'tab' as target grammar specification
*/
;

PTP_T PTP_init_reentrant(PLR_Tab tab); /* reentrant version of PTP_init     */
void PTP_quit(void);       /* terminates transformation and pretty printing */

void PTP_quit_reentrant(PTP_T ctx)
/* reentrant version of PTP_quit; consumes 'ctx' */
;

void PTP_set_line(int len); /* set 'len' as line length for pretty printing */

void PTP_set_line_reentrant(PTP_T ctx, int len)
/* reentrant version of PTP_set_line */
;

void PTP_tok_sep(symbol t_lft, symbol t_rgt, int sep)
/* specifies the kind of seperation ( 'sep' )
   between the token 't_rgt' and 't_lft';
   replaces a previously defined seperation
*/
;

void PTP_tok_sep_reentrant(PTP_T ctx, symbol t_lft, symbol t_rgt, int sep)
/* reentrant version of PTP_tok_sep */
;

void PTP_tok_conv(symbol t_id, symbol (*conv)(symbol t_id, symbol t_src))
/* specifies a conversion 'conv' for token 't_id';
   replaces a previously defined conversion
   't_id' = NULL --> apply 'conv' to all tokens
*/
;

void PTP_tok_conv_reentrant
     (
       PTP_T ctx, symbol t_id, symbol (*conv)(symbol t_id, symbol t_src)
     )
/* reentrant version of PTP_tok_conv */
;

void PTP_tok_cset(c_bool utf8, c_bool wprint)
/* specifies source character set (single/multi-byte) and
   pp output (on multi-byte source character set)
*/
;

void PTP_tok_cset_reentrant(PTP_T ctx, c_bool utf8, c_bool wprint)
/* reentrant version of PTP_tok_cset */
;


/* ------------------------- Term Pretty Printer --------------------------- */

void PTP_pp(PT_Term tree, FILE* fp)
/* performs pretty printing on parse term 'tree'
   ( output to file 'fp' )
*/
;

void PTP_pp_reentrant(PTP_T ctx, PT_Term tree, FILE* fp)
/* rrentrant version of PTP_pp */
;


/* ------------------------- Tree Transformation --------------------------- */

PT_Term PTP_nt_transform_aux(PT_Term tree, symbol nt)
/* performs tree-to-tree transformation on source 'tree';
   uses 'nt' as startsymbol
*/
;

PT_Term PTP_nt_transform_aux_reentrant
        (
          PTP_T ctx, PT_Term tree, symbol nt
        )
/* reentrant version of PTP_nt_transform_aux */
;

PT_Term PTP_transform(PT_Term tree)
/* performs tree-to-tree transformation on source 'tree' */
;

PT_Term PTP_transform_reentrant(PTP_T ctx, PT_Term tree)
/* reentrant version of PTP_transform */
;



#ifdef __cplusplus
}
#endif

#endif
