/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_34 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 20032, "epsg", 20032,
        "Pulkovo 1995 / Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-");
    add_proj4text (p, 2,
        "0.22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger zone 32\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",0],PARAMETER[\"central_meridian\",-171],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1],PARAMETER[\"false_easting\",32500000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST");
    add_srs_wkt (p, 13,
        "],AUTHORITY[\"EPSG\",\"20032\"]]");
    p = add_epsg_def_ex (filter, first, last, 20064, "epsg", 20064,
        "Pulkovo 1995 / Gauss-Kruger 4N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 4N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",21],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20064\"]]");
    p = add_epsg_def_ex (filter, first, last, 20065, "epsg", 20065,
        "Pulkovo 1995 / Gauss-Kruger 5N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 5N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",27],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20065\"]]");
    p = add_epsg_def_ex (filter, first, last, 20066, "epsg", 20066,
        "Pulkovo 1995 / Gauss-Kruger 6N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 6N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",33],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20066\"]]");
    p = add_epsg_def_ex (filter, first, last, 20067, "epsg", 20067,
        "Pulkovo 1995 / Gauss-Kruger 7N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 7N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",39],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20067\"]]");
    p = add_epsg_def_ex (filter, first, last, 20068, "epsg", 20068,
        "Pulkovo 1995 / Gauss-Kruger 8N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 8N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",45],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20068\"]]");
    p = add_epsg_def_ex (filter, first, last, 20069, "epsg", 20069,
        "Pulkovo 1995 / Gauss-Kruger 9N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 9N (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",51],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "EAST],AUTHORITY[\"EPSG\",\"20069\"]]");
    p = add_epsg_def_ex (filter, first, last, 20070, "epsg", 20070,
        "Pulkovo 1995 / Gauss-Kruger 10N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 10N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",57],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20070\"]]");
    p = add_epsg_def_ex (filter, first, last, 20071, "epsg", 20071,
        "Pulkovo 1995 / Gauss-Kruger 11N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 11N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",63],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20071\"]]");
    p = add_epsg_def_ex (filter, first, last, 20072, "epsg", 20072,
        "Pulkovo 1995 / Gauss-Kruger 12N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 12N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",69],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20072\"]]");
    p = add_epsg_def_ex (filter, first, last, 20073, "epsg", 20073,
        "Pulkovo 1995 / Gauss-Kruger 13N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 13N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",75],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20073\"]]");
    p = add_epsg_def_ex (filter, first, last, 20074, "epsg", 20074,
        "Pulkovo 1995 / Gauss-Kruger 14N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 14N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",81],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20074\"]]");
    p = add_epsg_def_ex (filter, first, last, 20075, "epsg", 20075,
        "Pulkovo 1995 / Gauss-Kruger 15N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 15N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",87],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20075\"]]");
    p = add_epsg_def_ex (filter, first, last, 20076, "epsg", 20076,
        "Pulkovo 1995 / Gauss-Kruger 16N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 16N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",93],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20076\"]]");
    p = add_epsg_def_ex (filter, first, last, 20077, "epsg", 20077,
        "Pulkovo 1995 / Gauss-Kruger 17N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.22");
    add_proj4text (p, 2,
        " +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 17N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",99],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1],PARAMETER[\"false_easting\",50");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",EAST],AUTHORITY[\"EPSG\",\"20077\"]]");
    p = add_epsg_def_ex (filter, first, last, 20078, "epsg", 20078,
        "Pulkovo 1995 / Gauss-Kruger 18N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 18N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",105],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20078\"]]");
    p = add_epsg_def_ex (filter, first, last, 20079, "epsg", 20079,
        "Pulkovo 1995 / Gauss-Kruger 19N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 19N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",111],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20079\"]]");
    p = add_epsg_def_ex (filter, first, last, 20080, "epsg", 20080,
        "Pulkovo 1995 / Gauss-Kruger 20N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 20N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",117],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20080\"]]");
    p = add_epsg_def_ex (filter, first, last, 20081, "epsg", 20081,
        "Pulkovo 1995 / Gauss-Kruger 21N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 21N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",123],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20081\"]]");
    p = add_epsg_def_ex (filter, first, last, 20082, "epsg", 20082,
        "Pulkovo 1995 / Gauss-Kruger 22N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 22N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",129],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20082\"]]");
    p = add_epsg_def_ex (filter, first, last, 20083, "epsg", 20083,
        "Pulkovo 1995 / Gauss-Kruger 23N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 23N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",135],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20083\"]]");
    p = add_epsg_def_ex (filter, first, last, 20084, "epsg", 20084,
        "Pulkovo 1995 / Gauss-Kruger 24N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 24N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",141],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20084\"]]");
    p = add_epsg_def_ex (filter, first, last, 20085, "epsg", 20085,
        "Pulkovo 1995 / Gauss-Kruger 25N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 25N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",147],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20085\"]]");
    p = add_epsg_def_ex (filter, first, last, 20086, "epsg", 20086,
        "Pulkovo 1995 / Gauss-Kruger 26N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 26N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",153],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20086\"]]");
    p = add_epsg_def_ex (filter, first, last, 20087, "epsg", 20087,
        "Pulkovo 1995 / Gauss-Kruger 27N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 27N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",159],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20087\"]]");
    p = add_epsg_def_ex (filter, first, last, 20088, "epsg", 20088,
        "Pulkovo 1995 / Gauss-Kruger 28N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 28N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",165],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20088\"]]");
    p = add_epsg_def_ex (filter, first, last, 20089, "epsg", 20089,
        "Pulkovo 1995 / Gauss-Kruger 29N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 29N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",171],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20089\"]]");
    p = add_epsg_def_ex (filter, first, last, 20090, "epsg", 20090,
        "Pulkovo 1995 / Gauss-Kruger 30N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.2");
    add_proj4text (p, 2,
        "2 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 30N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",177],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 11,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",EAST],AUTHORITY[\"EPSG\",\"20090\"]]");
    p = add_epsg_def_ex (filter, first, last, 20091, "epsg", 20091,
        "Pulkovo 1995 / Gauss-Kruger 31N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 31N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-177],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"20091\"]]");
    p = add_epsg_def_ex (filter, first, last, 20092, "epsg", 20092,
        "Pulkovo 1995 / Gauss-Kruger 32N (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1995", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=24.47,-130.89,-81.56,0,0,0.13,-0.");
    add_proj4text (p, 2,
        "22 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1995 / Gauss-Kruger 32N (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Pulkovo 1995\",DATUM[\"Pulkovo_1995\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[24.47,-130.89,-81.56,0,0,0.13,-0.22],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6200\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4200\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",-171],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",EAST],AUTHORITY[\"EPSG\",\"20092\"]]");
    p = add_epsg_def_ex (filter, first, last, 20135, "epsg", 20135,
        "Adindan / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 35N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-166,-15");
    add_srs_wkt (p, 3,
        ",204,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",27],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"20135\"]]");
    p = add_epsg_def_ex (filter, first, last, 20136, "epsg", 20136,
        "Adindan / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 36N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-166,-15");
    add_srs_wkt (p, 3,
        ",204,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",33],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"20136\"]]");
    p = add_epsg_def_ex (filter, first, last, 20137, "epsg", 20137,
        "Adindan / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 37N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-166,-15");
    add_srs_wkt (p, 3,
        ",204,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",39],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"20137\"]]");
    p = add_epsg_def_ex (filter, first, last, 20138, "epsg", 20138,
        "Adindan / UTM zone 38N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Adindan", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=clrk80 +towgs84=-166,-15,204,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Adindan / UTM zone 38N\",GEOGCS[\"Adindan\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Adindan\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.14");
    add_srs_wkt (p, 2,
        "5,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-166,-15");
    add_srs_wkt (p, 3,
        ",204,0,0,0,0],AUTHORITY[\"EPSG\",\"6201\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4201\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",45],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"20138\"]]");
    p = add_epsg_def_ex (filter, first, last, 20248, "epsg", 20248,
        "AGD66 / AMG zone 48 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 48 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "66\",DATUM[\"Australian_Geodetic_Datum_1966\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],TOWGS84[-117.808,-51.536,137.784,0.3");
    add_srs_wkt (p, 4,
        "03,0.446,0.234,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4202\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 9,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 10,
        "ntral_meridian\",105],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"20248\"]]");
    p = add_epsg_def_ex (filter, first, last, 20249, "epsg", 20249,
        "AGD66 / AMG zone 49", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 49\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20249\"]]");
    p = add_epsg_def_ex (filter, first, last, 20250, "epsg", 20250,
        "AGD66 / AMG zone 50", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 50\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20250\"]]");
    p = add_epsg_def_ex (filter, first, last, 20251, "epsg", 20251,
        "AGD66 / AMG zone 51", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 51\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20251\"]]");
    p = add_epsg_def_ex (filter, first, last, 20252, "epsg", 20252,
        "AGD66 / AMG zone 52", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 52\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20252\"]]");
    p = add_epsg_def_ex (filter, first, last, 20253, "epsg", 20253,
        "AGD66 / AMG zone 53", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 53\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20253\"]]");
    p = add_epsg_def_ex (filter, first, last, 20254, "epsg", 20254,
        "AGD66 / AMG zone 54", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 54\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20254\"]]");
    p = add_epsg_def_ex (filter, first, last, 20255, "epsg", 20255,
        "AGD66 / AMG zone 55", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 55\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20255\"]]");
    p = add_epsg_def_ex (filter, first, last, 20256, "epsg", 20256,
        "AGD66 / AMG zone 56", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 56\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20256\"]]");
    p = add_epsg_def_ex (filter, first, last, 20257, "epsg", 20257,
        "AGD66 / AMG zone 57", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 57\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20257\"]]");
    p = add_epsg_def_ex (filter, first, last, 20258, "epsg", 20258,
        "AGD66 / AMG zone 58", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1966", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-117.8");
    add_proj4text (p, 1,
        "08,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD66 / AMG zone 58\",GEOGCS[\"AGD66\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1966\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-117.808,-51.536,137.784,0.303,0.446,0.2");
    add_srs_wkt (p, 4,
        "34,-0.29],AUTHORITY[\"EPSG\",\"6202\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 5,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 6,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 7,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 8,
        "\",\"4202\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 10,
        "an\",165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 12,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"20258\"]]");
    p = add_epsg_def_ex (filter, first, last, 20348, "epsg", 20348,
        "AGD84 / AMG zone 48 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 48 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",105],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2034");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 20349, "epsg", 20349,
        "AGD84 / AMG zone 49", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 49\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",111],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20349\"]]");
    p = add_epsg_def_ex (filter, first, last, 20350, "epsg", 20350,
        "AGD84 / AMG zone 50", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 50\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",117],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20350\"]]");
    p = add_epsg_def_ex (filter, first, last, 20351, "epsg", 20351,
        "AGD84 / AMG zone 51", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 51\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",123],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20351\"]]");
    p = add_epsg_def_ex (filter, first, last, 20352, "epsg", 20352,
        "AGD84 / AMG zone 52", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 52\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",129],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20352\"]]");
    p = add_epsg_def_ex (filter, first, last, 20353, "epsg", 20353,
        "AGD84 / AMG zone 53", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 53\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",135],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20353\"]]");
    p = add_epsg_def_ex (filter, first, last, 20354, "epsg", 20354,
        "AGD84 / AMG zone 54", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 54\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",141],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20354\"]]");
    p = add_epsg_def_ex (filter, first, last, 20355, "epsg", 20355,
        "AGD84 / AMG zone 55", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 55\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",147],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20355\"]]");
    p = add_epsg_def_ex (filter, first, last, 20356, "epsg", 20356,
        "AGD84 / AMG zone 56", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 56\",GEOGCS[\"AGD84\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Australian_Geodetic_Datum_1984\",SPHEROID[\"Australian N");
    add_srs_wkt (p, 2,
        "ational Spheroid\",6378160,298.25,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",153],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",10000000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"20356\"]]");
    p = add_epsg_def_ex (filter, first, last, 20357, "epsg", 20357,
        "AGD84 / AMG zone 57 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 57 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",159],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2035");
    add_srs_wkt (p, 14,
        "7\"]]");
    p = add_epsg_def_ex (filter, first, last, 20358, "epsg", 20358,
        "AGD84 / AMG zone 58 (deprecated)", 0, 0,
        "Australian National Spheroid", "Greenwich",
        "Australian_Geodetic_Datum_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-134,-");
    add_proj4text (p, 1,
        "48,149,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"AGD84 / AMG zone 58 (deprecated)\",GEOGCS[\"AGD");
    add_srs_wkt (p, 1,
        "84\",DATUM[\"Australian_Geodetic_Datum_1984\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Australian National Spheroid\",6378160,298.25,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7003\"]],TOWGS84[-134,-48,149,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6203\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4203\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",0],PARAMETER[\"central_meridian\",165],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",10000000],UNIT[\"m");
    add_srs_wkt (p, 12,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2035");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 20436, "epsg", 20436,
        "Ain el Abd / UTM zone 36N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 36N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"20436\"]]");
    p = add_epsg_def_ex (filter, first, last, 20437, "epsg", 20437,
        "Ain el Abd / UTM zone 37N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 37N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"20437\"]]");
    p = add_epsg_def_ex (filter, first, last, 20438, "epsg", 20438,
        "Ain el Abd / UTM zone 38N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 38N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",45],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"20438\"]]");
    p = add_epsg_def_ex (filter, first, last, 20439, "epsg", 20439,
        "Ain el Abd / UTM zone 39N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 39N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",51],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"20439\"]]");
    p = add_epsg_def_ex (filter, first, last, 20440, "epsg", 20440,
        "Ain el Abd / UTM zone 40N", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / UTM zone 40N\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",57],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"20440\"]]");
    p = add_epsg_def_ex (filter, first, last, 20499, "epsg", 20499,
        "Ain el Abd / Bahrain Grid", 0, 0,
        "International 1924", "Greenwich",
        "Ain_el_Abd_1970", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Ain el Abd / Bahrain Grid\",GEOGCS[\"Ain el Abd");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Ain_el_Abd_1970\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-236,7,0,0,0,0],AUTHORITY[\"EPSG\",\"6204\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"4204\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 8,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 9,
        "ral_meridian\",51],PARAMETER[\"scale_factor\",0.9996],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"false_easting\",500000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"20499\"]]");
    p = add_epsg_def_ex (filter, first, last, 20538, "epsg", 20538,
        "Afgooye / UTM zone 38N", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=krass +towgs84=-43,-163,45,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Afgooye / UTM zone 38N\",GEOGCS[\"Afgooye\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Afgooye\",SPHEROID[\"Krassowsky 1940\",6378245,298.");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[-43,-163,45,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6205\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4205\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"205");
    add_srs_wkt (p, 13,
        "38\"]]");
    p = add_epsg_def_ex (filter, first, last, 20539, "epsg", 20539,
        "Afgooye / UTM zone 39N", 0, 0,
        "Krassowsky 1940", "Greenwich",
        "Afgooye", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=krass +towgs84=-43,-163,45,0,0");
    add_proj4text (p, 1,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Afgooye / UTM zone 39N\",GEOGCS[\"Afgooye\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Afgooye\",SPHEROID[\"Krassowsky 1940\",6378245,298.");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS84[-43,-163,45,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6205\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4205\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 9,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 11,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 12,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"205");
    add_srs_wkt (p, 13,
        "39\"]]");
    p = add_epsg_def_ex (filter, first, last, 20790, "epsg", 20790,
        "Lisbon (Lisbon) / Portuguese National Grid", 0, 0,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=");
    add_proj4text (p, 1,
        "200000 +y_0=300000 +ellps=intl +towgs84=-304.046,-60.576");
    add_proj4text (p, 2,
        ",103.64,0,0,0,0 +pm=lisbon +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon (Lisbon) / Portuguese National Grid\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"Lisbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"International 1924\",6378388,297,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7022\"]],TOWGS84[-304.046,-60.576,103.64,0,0,0,0]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"6803\"]],PRIMEM[\"Lisbon\",-9.1319");
    add_srs_wkt (p, 5,
        "06111111112,AUTHORITY[\"EPSG\",\"8902\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4803\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",39.66666666666666],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",1],PARAMETER[\"scale_factor\",1]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",200000],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"20790\"]]");
    p = add_epsg_def_ex (filter, first, last, 20791, "epsg", 20791,
        "Lisbon (Lisbon) / Portuguese Grid", 0, 0,
        "International 1924", "Lisbon",
        "Lisbon_1937_Lisbon", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=intl +towgs84=-304.046,-60.576,103.64,0,");
    add_proj4text (p, 2,
        "0,0,0 +pm=lisbon +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Lisbon (Lisbon) / Portuguese Grid\",GEOGCS[\"Li");
    add_srs_wkt (p, 1,
        "sbon (Lisbon)\",DATUM[\"Lisbon_1937_Lisbon\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-304.046,-60.576,103.64,0,0,0,0],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6803\"]],PRIMEM[\"Lisbon\",-9.1319061111111");
    add_srs_wkt (p, 5,
        "12,AUTHORITY[\"EPSG\",\"8902\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4803\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",39.66666666666666],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",1],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",0],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"20791\"]]");
    p = add_epsg_def_ex (filter, first, last, 20822, "epsg", 20822,
        "Aratu / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 22S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],TOWGS84[-151.99,287.04,-147.45");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6208\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4208\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"20822\"]]");
    p = add_epsg_def_ex (filter, first, last, 20823, "epsg", 20823,
        "Aratu / UTM zone 23S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 23S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],TOWGS84[-151.99,287.04,-147.45");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6208\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4208\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"20823\"]]");
    p = add_epsg_def_ex (filter, first, last, 20824, "epsg", 20824,
        "Aratu / UTM zone 24S", 0, 0,
        "International 1924", "Greenwich",
        "Aratu", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=intl +towgs84=-151.99,2");
    add_proj4text (p, 1,
        "87.04,-147.45,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Aratu / UTM zone 24S\",GEOGCS[\"Aratu\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Aratu\",SPHEROID[\"International 1924\",6378388,297,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7022\"]],TOWGS84[-151.99,287.04,-147.45");
    add_srs_wkt (p, 3,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6208\"]],PRIMEM[\"Greenwi");
    add_srs_wkt (p, 4,
        "ch\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0");
    add_srs_wkt (p, 5,
        "174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lat");
    add_srs_wkt (p, 6,
        "itude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 7,
        "\",\"4208\"]],PROJECTION[\"Transverse_Mercator\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"latitude_of_origin\",0],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 9,
        "an\",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",500000],PARAMETER[\"false_northing\",100");
    add_srs_wkt (p, 11,
        "00000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"20824\"]]");
    p = add_epsg_def_ex (filter, first, last, 20934, "epsg", 20934,
        "Arc 1950 / UTM zone 34S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 34S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-90,-294,0,0,0,0],AUTHORITY[\"EPSG\",\"6209\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4209\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",21],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20934\"]]");
    p = add_epsg_def_ex (filter, first, last, 20935, "epsg", 20935,
        "Arc 1950 / UTM zone 35S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 35S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-90,-294,0,0,0,0],AUTHORITY[\"EPSG\",\"6209\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4209\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",27],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20935\"]]");
    p = add_epsg_def_ex (filter, first, last, 20936, "epsg", 20936,
        "Arc 1950 / UTM zone 36S", 0, 0,
        "Clarke 1880 (Arc)", "Greenwich",
        "Arc_1950", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.9663");
    add_proj4text (p, 1,
        "98753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1950 / UTM zone 36S\",GEOGCS[\"Arc 1950\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1950\",SPHEROID[\"Clarke 1880 (Arc)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.4663077,AUTHORITY[\"EPSG\",\"7013\"]],TOWGS84[-");
    add_srs_wkt (p, 3,
        "143,-90,-294,0,0,0,0],AUTHORITY[\"EPSG\",\"6209\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4209\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",33],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"20936\"]]");
    p = add_epsg_def_ex (filter, first, last, 21035, "epsg", 21035,
        "Arc 1960 / UTM zone 35S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"21035\"]]");
    p = add_epsg_def_ex (filter, first, last, 21036, "epsg", 21036,
        "Arc 1960 / UTM zone 36S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"21036\"]]");
    p = add_epsg_def_ex (filter, first, last, 21037, "epsg", 21037,
        "Arc 1960 / UTM zone 37S", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=clrk80 +towgs84=-160,-6");
    add_proj4text (p, 1,
        ",-302,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37S\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"21037\"]]");
    p = add_epsg_def_ex (filter, first, last, 21095, "epsg", 21095,
        "Arc 1960 / UTM zone 35N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 35N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",27],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21095\"]]");
    p = add_epsg_def_ex (filter, first, last, 21096, "epsg", 21096,
        "Arc 1960 / UTM zone 36N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 36N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",33],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21096\"]]");
    p = add_epsg_def_ex (filter, first, last, 21097, "epsg", 21097,
        "Arc 1960 / UTM zone 37N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Arc_1960", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=clrk80 +towgs84=-160,-6,-302,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Arc 1960 / UTM zone 37N\",GEOGCS[\"Arc 1960\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Arc_1960\",SPHEROID[\"Clarke 1880 (RGS)\",6378249");
    add_srs_wkt (p, 2,
        ".145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-160,");
    add_srs_wkt (p, 3,
        "-6,-302,0,0,0,0],AUTHORITY[\"EPSG\",\"6210\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4210\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",39],PARAMETER[\"scale_factor\",0.9996],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21097\"]]");
    p = add_epsg_def_ex (filter, first, last, 21100, "epsg", 21100,
        "Batavia (Jakarta) / NEIEZ (deprecated)", 0, 0,
        "Bessel 1841", "Jakarta",
        "Batavia_Jakarta", "Mercator_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 ");
    add_proj4text (p, 1,
        "+ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia (Jakarta) / NEIEZ (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Batavia (Jakarta)\",DATUM[\"Batavia_Jakarta\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Bessel 1841\",6377397.155,299.1528128,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7004\"]],TOWGS84[-377,681,-50,0,0,0,0],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"6813\"]],PRIMEM[\"Jakarta\",106.8077194444444");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"8908\"]],UNIT[\"degree\",0.0174532");
    add_srs_wkt (p, 6,
        "925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"48");
    add_srs_wkt (p, 8,
        "13\"]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",110],PARAMETER[\"scale_factor\",0.997],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",3900000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",900000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"21100\"]]");
    p = add_epsg_def_ex (filter, first, last, 21148, "epsg", 21148,
        "Batavia / UTM zone 48S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 48S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-377,681,-");
    add_srs_wkt (p, 3,
        "50,0,0,0,0],AUTHORITY[\"EPSG\",\"6211\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4211\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",105],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"21148\"]]");
    p = add_epsg_def_ex (filter, first, last, 21149, "epsg", 21149,
        "Batavia / UTM zone 49S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 49S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-377,681,-");
    add_srs_wkt (p, 3,
        "50,0,0,0,0],AUTHORITY[\"EPSG\",\"6211\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4211\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",111],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"21149\"]]");
    p = add_epsg_def_ex (filter, first, last, 21150, "epsg", 21150,
        "Batavia / UTM zone 50S", 0, 0,
        "Bessel 1841", "Greenwich",
        "Batavia", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=bessel +towgs84=-377,68");
    add_proj4text (p, 1,
        "1,-50,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Batavia / UTM zone 50S\",GEOGCS[\"Batavia\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Batavia\",SPHEROID[\"Bessel 1841\",6377397.155,299.");
    add_srs_wkt (p, 2,
        "1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-377,681,-");
    add_srs_wkt (p, 3,
        "50,0,0,0,0],AUTHORITY[\"EPSG\",\"6211\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4211\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",117],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"21150\"]]");
    p = add_epsg_def_ex (filter, first, last, 21291, "epsg", 21291,
        "Barbados 1938 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=31.95,300.99,419");
    add_proj4text (p, 2,
        ".19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],TOWGS84[31.95,300.99,419.19,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6212\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4212\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",-62],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",0.9995],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",400000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21291\"]]");
    p = add_epsg_def_ex (filter, first, last, 21292, "epsg", 21292,
        "Barbados 1938 / Barbados National Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.17638888888889 +lon_0=-59.55972222");
    add_proj4text (p, 1,
        "222222 +k=0.9999986 +x_0=30000 +y_0=75000 +ellps=clrk80 ");
    add_proj4text (p, 2,
        "+towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / Barbados National Grid\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7012\"]],TOWGS84[31.95,300.99,419.19,0,0,0,0],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"6212\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4212\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",13.17638888888889],PARAMETER[\"central_meridia");
    add_srs_wkt (p, 10,
        "n\",-59.55972222222222],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 11,
        "9986],PARAMETER[\"false_easting\",30000],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",75000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"21292\"]]");
    p = add_epsg_def_ex (filter, first, last, 21413, "epsg", 21413,
        "Beijing 1954 / Gauss-Kruger zone 13", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 13\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",75],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",13500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21413\"]]");
    p = add_epsg_def_ex (filter, first, last, 21414, "epsg", 21414,
        "Beijing 1954 / Gauss-Kruger zone 14", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 14\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",81],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",14500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21414\"]]");
    p = add_epsg_def_ex (filter, first, last, 21415, "epsg", 21415,
        "Beijing 1954 / Gauss-Kruger zone 15", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 15\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",87],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",15500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21415\"]]");
    p = add_epsg_def_ex (filter, first, last, 21416, "epsg", 21416,
        "Beijing 1954 / Gauss-Kruger zone 16", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 16\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",93],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",16500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21416\"]]");
    p = add_epsg_def_ex (filter, first, last, 21417, "epsg", 21417,
        "Beijing 1954 / Gauss-Kruger zone 17", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 17\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",99],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1],PARAMETER[\"false_easting\",17500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21417\"]]");
    p = add_epsg_def_ex (filter, first, last, 21418, "epsg", 21418,
        "Beijing 1954 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 18\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",105],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",18500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21418\"]]");
    p = add_epsg_def_ex (filter, first, last, 21419, "epsg", 21419,
        "Beijing 1954 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 19\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",111],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",19500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21419\"]]");
    p = add_epsg_def_ex (filter, first, last, 21420, "epsg", 21420,
        "Beijing 1954 / Gauss-Kruger zone 20", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 20\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",117],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",20500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21420\"]]");
    p = add_epsg_def_ex (filter, first, last, 21421, "epsg", 21421,
        "Beijing 1954 / Gauss-Kruger zone 21", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 21\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",123],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",21500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21421\"]]");
    p = add_epsg_def_ex (filter, first, last, 21422, "epsg", 21422,
        "Beijing 1954 / Gauss-Kruger zone 22", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 22\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",129],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",22500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21422\"]]");
    p = add_epsg_def_ex (filter, first, last, 21423, "epsg", 21423,
        "Beijing 1954 / Gauss-Kruger zone 23", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger zone 23\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",135],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",23500000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"21423\"]]");
    p = add_epsg_def_ex (filter, first, last, 21453, "epsg", 21453,
        "Beijing 1954 / Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 75E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",75],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"21453\"]]");
    p = add_epsg_def_ex (filter, first, last, 21454, "epsg", 21454,
        "Beijing 1954 / Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 81E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",81],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"21454\"]]");
    p = add_epsg_def_ex (filter, first, last, 21455, "epsg", 21455,
        "Beijing 1954 / Gauss-Kruger CM 87E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 87E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",87],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"21455\"]]");
    p = add_epsg_def_ex (filter, first, last, 21456, "epsg", 21456,
        "Beijing 1954 / Gauss-Kruger CM 93E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 93E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",93],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"21456\"]]");
    p = add_epsg_def_ex (filter, first, last, 21457, "epsg", 21457,
        "Beijing 1954 / Gauss-Kruger CM 99E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 99E\",GEOGCS[\"B");
    add_srs_wkt (p, 1,
        "eijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassows");
    add_srs_wkt (p, 2,
        "ky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TO");
    add_srs_wkt (p, 3,
        "WGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"62");
    add_srs_wkt (p, 4,
        "14\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",99],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"21457\"]]");
    p = add_epsg_def_ex (filter, first, last, 21458, "epsg", 21458,
        "Beijing 1954 / Gauss-Kruger CM 105E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / Gauss-Kruger CM 105E\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"Krassow");
    add_srs_wkt (p, 2,
        "sky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 4,
        "214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",105],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"21458\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

