-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with Command_Line;
with SPARK_IO;
with E_Strings;
with Banner;
with Victor_Wrapper;

--# inherit Banner,
--#         Command_Line,
--#         E_Strings,
--#         SPARK_IO,
--#         Victor_Wrapper;

--# main_program;
procedure Victor
--# global in out SPARK_IO.File_Sys;
is
   Command_Line_Data : Command_Line.Command_Line_Data_T;
   Command_Line_Ok   : Boolean;

   Victor_Ok : Boolean := True;

   Error_String : E_Strings.T;
begin
   Command_Line.Initialize (Data  => Command_Line_Data,
                            Ok    => Command_Line_Ok,
                            Error => Error_String);

   --  Note that Initialize will correctly set Plain regardless
   Banner.Show_Banner (Plain_Mode => Command_Line_Data.Plain);

   --# accept Flow, 22, "Command_Line_Ok is not invariant.";

   if Command_Line_Ok and not Command_Line_Data.Show_Help then
      --  Call vct only if no errors in the command line and we don't
      --  want to show the help text.
      Victor_Wrapper.Execute (CL    => Command_Line_Data,
                              Ok    => Victor_Ok,
                              Error => Error_String);
   else
      --  Otherwise show the help text.
      Banner.Show_Help (Plain_Mode => Command_Line_Data.Plain);
   end if;

   if not (Command_Line_Ok and Victor_Ok) then
      SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Error: ", 0);
      E_Strings.Put_Line (SPARK_IO.Standard_Output, Error_String);
      Command_Line.Set_Exit_Status_Error;
   end if;
end Victor;
