-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--  SparkHTML
--
--  Purpose:
--   This package contains the procedures required to convert the text-based
--  report file output of the Examiner into HTML, with useful links where
--  appropriate.
--
--   The design of this package is given in S.P0468.53.47
--
--  Clients:
--   Examiner MainLoop
--
--  Use:
--   See MainLoop
--
--  Extension:
--   Update as and when the Examiner's report file format changes.
--------------------------------------------------------------------------------

with ContextManager;

--# inherit Ada.Characters.Handling,
--#         CommandLineData,
--#         ContextManager,
--#         ContextManager.Ops,
--#         E_Strings,
--#         FileSystem,
--#         IndexManager,
--#         ScreenEcho,
--#         SPARK_IO;

package SparkHTML
--# own Generate_HTML  : Boolean;
--#     HTML_Work_Dir  : E_Strings.T;
--#     SPARK_Work_Dir : E_Strings.T;
--# initializes Generate_HTML;
is

   -- Creates subdir and frame file
   procedure Init_SPARK_HTML;
   --# global in     CommandLineData.Content;
   --#        in out Generate_HTML;
   --#        in out SPARK_IO.File_Sys;
   --#           out HTML_Work_Dir;
   --#           out SPARK_Work_Dir;
   --# derives Generate_HTML,
   --#         SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                SPARK_IO.File_Sys &
   --#         HTML_Work_Dir     from CommandLineData.Content,
   --#                                SPARK_IO.File_Sys &
   --#         SPARK_Work_Dir    from SPARK_IO.File_Sys;

   procedure Gen_Report_HTML;
   --# global in     CommandLineData.Content;
   --#        in     HTML_Work_Dir;
   --#        in     SPARK_Work_Dir;
   --#        in out Generate_HTML;
   --#        in out SPARK_IO.File_Sys;
   --# derives Generate_HTML     from *,
   --#                                CommandLineData.Content,
   --#                                SPARK_IO.File_Sys &
   --#         SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                Generate_HTML,
   --#                                HTML_Work_Dir,
   --#                                SPARK_Work_Dir;

   procedure Gen_Listing_HTML (File_Descriptor : in ContextManager.FileDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.File_Heap;
   --#        in     Generate_HTML;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                ContextManager.Ops.File_Heap,
   --#                                File_Descriptor,
   --#                                Generate_HTML;

end SparkHTML;
