-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.Wf_Argument_Association)
procedure Tagged_Actual_Must_Be_Object_Check
  (Node_Pos         : in     LexTokenManager.Token_Position;
   Formal_Type      : in     Dictionary.Symbol;
   Actual_Type      : in     Dictionary.Symbol;
   Controlling_Type : in     Dictionary.Symbol;
   Is_A_Variable    : in     Boolean;
   Is_A_Constant    : in     Boolean;
   Error_Found      : in out Boolean)
is
begin
   if not Dictionary.Is_Null_Symbol (Controlling_Type)
     and then Dictionary.Types_Are_Equal
     (Left_Symbol        => Formal_Type,
      Right_Symbol       => Controlling_Type,
      Full_Range_Subtype => False)
     and then not Dictionary.Types_Are_Equal
     (Left_Symbol        => Actual_Type,
      Right_Symbol       => Controlling_Type,
      Full_Range_Subtype => False)
     and then -- but must be an extension of it (earlier check)
     not (Is_A_Variable or else Is_A_Constant) then
      Error_Found := True;
      ErrorHandler.Semantic_Error
        (Err_Num   => 827,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Pos,
         Id_Str    => LexTokenManager.Null_String);
   end if;
end Tagged_Actual_Must_Be_Object_Check;
