/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * by Axel.Mahler@cs.tu-berlin.de
 *
 * $Header: vadm.h[10.0] Fri Jul  9 18:58:01 1993 andy@cs.tu-berlin.de frozen $
 */

/*======================
 *  Constants
 *======================*/

/* action codes */
#define VADM_SBMT		01
#define VADM_PUBL		02
#define VADM_ACCS		03
#define VADM_FRZE		04

#define VADM_DELETE		11
#define VADM_LOCK		12
#define VADM_UNLOCK		13
#define VADM_PROMOTE		14
#define VADM_UNPROMOTE		15
#define VADM_NEWGEN		16

#define VADM_ATTR		21
#define VADM_DELATTR		22
#define VADM_ALIAS		23
#define VADM_UNALIAS		24
#define VADM_CHMOD		25
#define VADM_CHOWN		26
#define VADM_CHAUT		27
#define VADM_SET		28
#define VADM_SETCLEAD		29

/* state transitions */
#define VADM_STATUS_PROMOTE	-10
#define VADM_STATUS_UNPROMOTE	-11

/*=====================================
 * Functions Prototypes
 *=====================================*/

#ifdef __STDC__
#define A(alist) alist
#else
#define A(alist) ()
#endif

/*** dovadm.c ***/
int	doDelete	A((char *asoName, Af_key *aso));
int	doLock		A((char *path, char *asoName, Af_key *aso, int mode));
int	doStatus	A((char *asoName, Af_key *aso, int status));
int	doComment	A((char *path, char *asoName, Af_key *aso, char *commentType));
