// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_MAP_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MAP_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AllocatorType

template <typename T> struct AllocatorType;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(85)

//____________________________________________________________________________
// ChooseMap

template <typename TValue> struct ChooseMap;       	// "seqan-1.3.1/seqan/map/map_chooser.h"(59)

//____________________________________________________________________________
// ChooseMap2_

template <typename TValue, size_t SIZE> struct ChooseMap2_;       	// "seqan-1.3.1/seqan/map/map_chooser.h"(46)

//____________________________________________________________________________
// DIMENSION

template <typename T> struct DIMENSION;       	// "seqan-1.3.1/seqan/map/sumlist.h"(54)

//____________________________________________________________________________
// ImplMapValue_

template <typename TCargo> struct ImplMapValue_;       	// "seqan-1.3.1/seqan/map/map_base.h"(120)

//____________________________________________________________________________
// Map

template <typename TElement, typename TSpec > class Map;       	// "seqan-1.3.1/seqan/map/map_base.h"(63)
template <typename TValue, typename TSpec> class Map;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(66)

//____________________________________________________________________________
// MapValue

template <typename TMap> struct MapValue;       	// "seqan-1.3.1/seqan/map/map_base.h"(113)

//____________________________________________________________________________
// MapValueImpl_

template <typename TMap, typename TCargo> struct MapValueImpl_;       	// "seqan-1.3.1/seqan/map/map_base.h"(90)

//____________________________________________________________________________
// MiniListEntry_

template <typename TValue> struct MiniListEntry_;       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(46)

//____________________________________________________________________________
// MiniSumList

template <unsigned short SIZE , typename TSpec > struct MiniSumList;       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(163)

//____________________________________________________________________________
// MiniSumListIterator

struct MiniSumListIterator;       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(652)

//____________________________________________________________________________
// MiniSumListValueIterator_

struct MiniSumListValueIterator_;       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(165)

//____________________________________________________________________________
// SkipListMapValue_

template <typename TCargo> struct SkipListMapValue_;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(958)

//____________________________________________________________________________
// SkipSumList

template <typename TSpec > struct SkipSumList;       	// "seqan-1.3.1/seqan/map/sumlist.h"(43)

//____________________________________________________________________________
// Skiplist

template <typename TSpec > struct Skiplist;       	// "seqan-1.3.1/seqan/map/map_base.h"(46)

//____________________________________________________________________________
// SkiplistElement

template <typename TValue, typename TSpec> class SkiplistElement;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(69)
template <typename TValue, typename TSpec> class SkiplistElement;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(213)

//____________________________________________________________________________
// SkiplistElement_

template <typename T> struct SkiplistElement_;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(105)

//____________________________________________________________________________
// SkiplistIterator

struct SkiplistIterator;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(80)

//____________________________________________________________________________
// SkiplistNext

template <typename TValue, typename TSpec> class SkiplistNext;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(72)
template <typename TValue, typename TSpec> class SkiplistNext;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(236)

//____________________________________________________________________________
// SkiplistPath

template <typename TValue, typename TSpec> class SkiplistPath;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(75)
template <typename TValue, typename TSpec> class SkiplistPath;       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(264)

//____________________________________________________________________________
// StlIterator_

template <typename T> struct StlIterator_;       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(127)

//____________________________________________________________________________
// StlMapIterator

struct StlMapIterator;       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(291)

//____________________________________________________________________________
// StlSetIterator

struct StlSetIterator;       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(290)

//____________________________________________________________________________
// SumList

template <unsigned int DIM, typename TValue, typename TSpec > class SumList;       	// "seqan-1.3.1/seqan/map/sumlist.h"(48)

//____________________________________________________________________________
// SumListValues

template <unsigned int DIM, typename TValue> struct SumListValues;       	// "seqan-1.3.1/seqan/map/sumlist.h"(91)

//____________________________________________________________________________
// Values

template <typename T> struct Values;       	// "seqan-1.3.1/seqan/map/sumlist.h"(135)

//____________________________________________________________________________
// VectorSet

template <typename TSpec > struct VectorSet;       	// "seqan-1.3.1/seqan/map/map_vector.h"(65)

//____________________________________________________________________________
// VectorSetElement_

template <typename TCargo> struct VectorSetElement_;       	// "seqan-1.3.1/seqan/map/map_vector.h"(73)

//____________________________________________________________________________
// VectorSetElements_

template <typename T> struct VectorSetElements_;       	// "seqan-1.3.1/seqan/map/map_vector.h"(87)

//____________________________________________________________________________
// VectorSetInsert_

template <typename TCargo> struct VectorSetInsert_;       	// "seqan-1.3.1/seqan/map/map_vector.h"(255)

//____________________________________________________________________________
// VectorSetIterator

struct VectorSetIterator;       	// "seqan-1.3.1/seqan/map/map_vector.h"(177)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _insertValues

template <typename TSumList, typename TValues> inline bool _insertValues(TSumList & me, Iter<TSumList, MiniSumListValueIterator_> it, TValues const & new_values,  unsigned int & new_values_size);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(389)
template <typename TSumList, typename TValue> inline bool _insertValues(TSumList & me, Iter<TSumList, MiniSumListValueIterator_> it, TValue const * new_values,  unsigned int & new_values_size);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(398)

//____________________________________________________________________________
// _miniSumListAssignValue

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValue2> inline bool _miniSumListAssignValue(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, unsigned char * ptr, int dim, TValue2 new_value);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(313)

//____________________________________________________________________________
// _miniSumListInsertValues

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TPosition, typename TValue2> inline bool _miniSumListInsertValues(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, TPosition byte_pos, TValue2 const & new_values,  unsigned int & new_values_size);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(356)

//____________________________________________________________________________
// _miniSumListSizeOfValues

template <unsigned int DIM, typename TValue> inline TValue _miniSumListSizeOfValues(SumListValues<DIM, TValue> const & vals);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(337)

//____________________________________________________________________________
// _skiplistAllocateElement

template <typename TValue, typename TSpec> inline SkiplistElement<TValue, TSpec> & _skiplistAllocateElement(Map<TValue, Skiplist<TSpec> > & me, unsigned char height);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(320)

//____________________________________________________________________________
// _skiplistConstructElement

template <typename TValue, typename TSpec, typename TValue2> inline SkiplistElement<TValue, TSpec> & _skiplistConstructElement(Map<TValue, Skiplist<TSpec> > & me, unsigned char height, TValue2 const & _value);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(364)

//____________________________________________________________________________
// _skiplistCreateHeight

template <typename TValue, typename TSpec> inline unsigned char _skiplistCreateHeight(Map<TValue, Skiplist<TSpec> > & me);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(408)
template <typename TValue, typename TSpec> inline unsigned char _skiplistCreateHeight(Map<TValue, Skiplist<TSpec> > & me, SkiplistPath<TValue, TSpec> & path);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(423)

//____________________________________________________________________________
// _skiplistDeallocateElement

template <typename TValue, typename TSpec> inline void _skiplistDeallocateElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, unsigned char height);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(380)

//____________________________________________________________________________
// _skiplistDestructElement

template <typename TValue, typename TSpec> inline void _skiplistDestructElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, unsigned char height);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(395)

//____________________________________________________________________________
// _skiplistFind

template <typename TValue, typename TSpec, typename TFind> inline void _skiplistFind(Map<TValue, Skiplist<TSpec> > & me, TFind const & find,  SkiplistPath<TValue, TSpec> & path);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(519)

//____________________________________________________________________________
// _skiplistFindGoNext

template <typename TValue, typename TSpec, typename TKey> inline bool _skiplistFindGoNext(SkiplistNext<TValue, TSpec> & next, unsigned char, TKey const & _key);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(490)
template <typename TValue, typename TSpec> inline bool _skiplistFindGoNext(SkiplistNext<TValue, TSpec> & next, unsigned char, SkiplistElement<TValue, TSpec> const & el);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(499)
template <typename TValue, typename TSpec> inline bool _skiplistFindGoNext(SkiplistNext<TValue, TSpec> & next, unsigned char , GoEnd);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(508)

//____________________________________________________________________________
// _skiplistGetHeight

template <typename TValue, typename TSpec> inline unsigned char _skiplistGetHeight(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, SkiplistPath<TValue, TSpec> & path);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(448)
template <typename TValue, typename TSpec> inline unsigned char _skiplistGetHeight(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(461)

//____________________________________________________________________________
// _skiplistInsertElement

template <typename TValue, typename TSpec> inline void _skiplistInsertElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, SkiplistPath<TValue, TSpec> & path, unsigned char height);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(590)
template <typename TValue, typename TSpec> inline void _skiplistInsertElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, unsigned char height);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(605)

//____________________________________________________________________________
// _skiplistUnlinkElement

template <typename TValue, typename TSpec> inline void _skiplistUnlinkElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(787)

//____________________________________________________________________________
// add

template <typename TValue, typename TSpec, typename TValue2> inline void add(Map<TValue, Skiplist<TSpec> > & me, TValue2 const & _value);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(759)
template <typename TValue, typename TSpec, typename TKey2, typename TCargo2> inline void add(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key, TCargo2 const & _cargo);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(772)

//____________________________________________________________________________
// appendValues

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValues> inline bool appendValues(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, TValues const & new_values);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(410)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValue2> inline bool appendValues(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, TValue2 const * new_values);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(418)

//____________________________________________________________________________
// assign

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline void assign(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & target, SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const & source);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(230)
template <typename TKey, typename TCompare, typename TAlloc> inline void assign(::std::set<TKey, TCompare, TAlloc> & target, ::std::set<TKey, TCompare, TAlloc> const & source);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(147)
template <typename TKey,typename TCargo, typename TCompare, typename TAlloc> inline void assign(::std::map<TKey,TCargo, TCompare, TAlloc> & target, ::std::map<TKey,TCargo, TCompare, TAlloc> const & source);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(155)
template <typename TValue, typename TSpec> inline void assign(Map<TValue, Skiplist<TSpec> > & target, Map<TValue, Skiplist<TSpec> > const & source);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(283)

//____________________________________________________________________________
// assignValue

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValue2> inline bool assignValue(Iter<SumList<DIM, TValue, MiniSumList<SIZE, TSpec> >, MiniSumListIterator > & it, int dim, TValue2 val);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(839)

//____________________________________________________________________________
// atEnd

template <typename TSet> inline bool atEnd(Iter<TSet, VectorSetIterator> & a);       	// "seqan-1.3.1/seqan/map/map_vector.h"(405)
template <typename TSet> inline bool atEnd(Iter<TSet, VectorSetIterator> const & a);       	// "seqan-1.3.1/seqan/map/map_vector.h"(411)
template <typename TSumList, typename TSumList2> inline bool atEnd(Iter< TSumList, MiniSumListValueIterator_ > & it, TSumList2 & container);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(635)
template <typename TSumList, typename TSumList2> inline bool atEnd(Iter< TSumList, MiniSumListValueIterator_ > & it, TSumList2 const & container);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(643)
template <typename TSumList> inline bool atEnd(Iter<TSumList, MiniSumListIterator> & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(793)
template <typename TStlMap> inline bool atEnd(Iter<TStlMap, StlMapIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(428)
template <typename TStlMap> inline bool atEnd(Iter<TStlMap, StlSetIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(626)
template <typename TSkiplist> inline bool atEnd(Iter<TSkiplist, SkiplistIterator> & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1078)

//____________________________________________________________________________
// begin

template <typename TElement, typename TSpec> inline typename Iterator< Map<TElement, VectorSet<TSpec> > >::Type begin(Map<TElement, VectorSet<TSpec> > & set);       	// "seqan-1.3.1/seqan/map/map_vector.h"(366)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type begin(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(272)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const>::Type begin(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const & me);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(280)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc>, TIteratorSpec>::Type begin(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TIteratorSpec);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(384)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type begin(::std::map<TKey,TCargo, TCompare, TAlloc> & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(392)
template <typename TValue, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::set<TValue,TCompare,TAlloc>, TIteratorSpec>::Type begin(::std::set<TValue,TCompare,TAlloc> & me, TIteratorSpec);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(582)
template <typename TValue, typename TCompare, typename TAlloc> inline typename Iterator< ::std::set<TValue,TCompare,TAlloc> >::Type begin(::std::set<TValue,TCompare,TAlloc> & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(590)
template <typename TValue, typename TSpec, typename TIteratorSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> >, TIteratorSpec>::Type begin(Map<TValue, Skiplist<TSpec> > & me, TIteratorSpec);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(920)
template <typename TValue, typename TSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type begin(Map<TValue, Skiplist<TSpec> > & me);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(927)

//____________________________________________________________________________
// cargo

template <typename TKey, typename TObject, typename TSpec> inline TObject & cargo(Pair<TKey, TObject, TSpec> & element);       	// "seqan-1.3.1/seqan/map/map_base.h"(228)
template <typename TKey, typename TObject, typename TSpec> inline TObject const & cargo(Pair<TKey, TObject, TSpec> const & element);       	// "seqan-1.3.1/seqan/map/map_base.h"(234)
template <typename TKey, typename TSpec, typename TKey2> inline typename Cargo< Map<TKey, VectorSet<TSpec> > >::Type & cargo(Map<TKey, VectorSet<TSpec> > & set, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_vector.h"(349)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Iter<TSet, VectorSetIterator> &it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(434)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Iter<TSet, VectorSetIterator> const &it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(439)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > >& pr);       	// "seqan-1.3.1/seqan/map/map_vector.h"(497)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > > const & pr);       	// "seqan-1.3.1/seqan/map/map_vector.h"(503)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline typename Cargo< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type & cargo(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(283)
template <typename TStlMap> inline typename Cargo<TStlMap>::Type & cargo(Iter<TStlMap, StlMapIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(482)
template <typename TStlMap> inline typename Cargo<TStlMap>::Type & cargo(Iter<TStlMap, StlMapIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(489)
template <typename TValue, typename TSpec, typename TKey2> inline typename Cargo< Map<TValue, Skiplist<TSpec> > >::Type & cargo(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(689)
template <typename TSkiplist> inline typename Cargo<TSkiplist>::Type & cargo(Iter<TSkiplist, SkiplistIterator> & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1126)
template <typename TSkiplist> inline typename Cargo<TSkiplist>::Type & cargo(Iter<TSkiplist, SkiplistIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1132)

//____________________________________________________________________________
// clear

template <typename TValue, typename TSpec> inline void clear(Map<TValue, VectorSet<TSpec> > & me);       	// "seqan-1.3.1/seqan/map/map_vector.h"(239)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline void clear(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(261)
template <typename TSumList> inline void clear(Iter<TSumList, MiniSumListIterator> & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(743)
template <typename TValue, typename TCompare, typename TAlloc> inline void clear(::std::set<TValue, TCompare, TAlloc> & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(254)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline void clear(::std::map<TKey,TCargo, TCompare, TAlloc> & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(262)
template <unsigned int DIM, typename TValue> inline void clear(SumListValues<DIM, TValue> & me);       	// "seqan-1.3.1/seqan/map/sumlist.h"(200)
template <typename TValue, typename TSpec> inline void clear(Map<TValue, Skiplist<TSpec> > & me);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(885)

//____________________________________________________________________________
// end

template <typename TElement, typename TSpec> inline typename Iterator< Map<TElement, VectorSet<TSpec> > >::Type end(Map<TElement, VectorSet<TSpec> > &set);       	// "seqan-1.3.1/seqan/map/map_vector.h"(377)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type end(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(290)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const>::Type end(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const& me);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(298)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type end(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TIteratorSpec);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(404)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type end(::std::map<TKey,TCargo, TCompare, TAlloc> & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(415)
template <typename TValue, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::set<TValue, TCompare, TAlloc>, TIteratorSpec>::Type end(::std::set<TValue, TCompare, TAlloc> & me, TIteratorSpec);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(602)
template <typename TValue, typename TCompare, typename TAlloc> inline typename Iterator< ::std::set<TValue,TCompare,TAlloc> >::Type end(::std::set<TValue,TCompare,TAlloc> & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(613)
template <typename TValue, typename TSpec, typename TIteratorSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> >, TIteratorSpec>::Type end(Map<TValue, Skiplist<TSpec> > &, TIteratorSpec);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(940)
template <typename TValue, typename TSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type end(Map<TValue, Skiplist<TSpec> > &);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(947)

//____________________________________________________________________________
// erase

template <typename TValue, typename TSpec, typename T> inline void erase(Map<TValue, VectorSet<TSpec> > &set, T const & tokill);       	// "seqan-1.3.1/seqan/map/map_vector.h"(314)
template <typename TValue, typename TCompare, typename TAlloc, typename TMap2> inline void erase(::std::set<TValue, TCompare, TAlloc> & me, Iter<TMap2, StlSetIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(717)
template <typename TKey, typename TCargo ,typename TMap2> inline void erase(::std::map<TKey,TCargo> & me, Iter<TMap2, StlMapIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(726)
template <typename TValue, typename TCompare, typename TAlloc, typename TToRemove> inline void erase(::std::set<TValue, TCompare, TAlloc> & me, TToRemove const & to_remove);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(738)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TToRemove> inline void erase(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TToRemove const & to_remove);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(747)
template <typename TValue, typename TSpec, typename TMap2> inline void erase(Map<TValue, Skiplist<TSpec> > & me, Iter<TMap2, SkiplistIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(827)
template <typename TValue, typename TSpec, typename TToRemove> inline void erase(Map<TValue, Skiplist<TSpec> > & me, TToRemove const & to_remove);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(836)

//____________________________________________________________________________
// eraseAll

template <typename TValue, typename TSpec, typename TToRemove> inline void eraseAll(Map<TValue, Skiplist<TSpec> > & me, TToRemove const & to_remove);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(868)

//____________________________________________________________________________
// find

template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< Map<TKey2, VectorSet<TSpec> > >::Type find(Map<TKey2, VectorSet<TSpec> > & set, TKey const &key);       	// "seqan-1.3.1/seqan/map/map_vector.h"(337)
template <typename TValue, typename TCompare, typename TAlloc,typename TFind> inline typename Iterator< ::std::set<TValue, TCompare, TAlloc> >::Type find(::std::set<TValue, TCompare, TAlloc> & me, TFind const & _find);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(680)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TFind> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type find(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TFind const & _find);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(697)
template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type find(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find, SkiplistPath<TValue, TSpec> & path);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(561)
template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type find(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(571)

//____________________________________________________________________________
// getSum

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Value< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type & getSum(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, unsigned int dim);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(252)
template <typename TSumList> inline typename Value<TSumList>::Type getSum(Iter<TSumList, MiniSumListIterator > & it, int dim);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(813)

//____________________________________________________________________________
// getValue

template <typename TSumList> inline typename Value<TSumList>::Type getValue(Iter<TSumList, MiniSumListValueIterator_ > & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(608)
template <typename TSumList> inline typename Value<TSumList>::Type getValue(Iter<TSumList, MiniSumListIterator > & it, int dim);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(803)

//____________________________________________________________________________
// goBeforeEnd

template <typename TSumList> inline void goBeforeEnd(Iter<TSumList, MiniSumListIterator> & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(780)

//____________________________________________________________________________
// goBegin

template <typename TSumList> inline void goBegin(Iter<TSumList, MiniSumListIterator> & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(769)

//____________________________________________________________________________
// goNext

template <typename TSet> inline void goNext(Iter<TSet, VectorSetIterator> & it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(466)
template <typename TSumList> inline void goNext(Iter< TSumList, MiniSumListValueIterator_ > & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(596)
template <typename TSumList> inline void goNext(Iter<TSumList, MiniSumListIterator> & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(755)
template <typename TStlMap> inline void goNext(Iter<TStlMap, StlMapIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(438)
template <typename TStlMap> inline void goNext(Iter<TStlMap, StlSetIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(636)
template <typename TSkiplist> inline void goNext(Iter<TSkiplist, SkiplistIterator> & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1087)

//____________________________________________________________________________
// hasKey

template <typename TKey, typename TValue, typename TSpec> inline bool hasKey(Map<TValue, VectorSet<TSpec> > const &set, TKey const &key);       	// "seqan-1.3.1/seqan/map/map_vector.h"(327)
template <typename TValue, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::set<TValue,TCompare,TAlloc> & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(164)
template <typename TValue, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::set<TValue,TCompare,TAlloc> const & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(172)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::map<TKey, TCargo, TCompare, TAlloc> & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(181)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::map<TKey, TCargo, TCompare, TAlloc> const & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(189)
template <typename TValue, typename TSpec, typename TKey2> inline bool hasKey(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1009)

//____________________________________________________________________________
// insert

template <typename TValue, typename TSpec, typename TElement> inline void insert(Map<TValue, VectorSet<TSpec> > & set, TElement const &element);       	// "seqan-1.3.1/seqan/map/map_vector.h"(289)
template <typename TValue, typename TSpec, typename TKey, typename TCargo> inline void insert(Map<TValue, VectorSet<TSpec> > &set, TKey const & _key, TCargo const & _cargo);       	// "seqan-1.3.1/seqan/map/map_vector.h"(299)
template <typename TValue, typename TCompare, typename TAlloc, typename TValue2> inline void insert(::std::set<TValue, TCompare, TAlloc> & me,TValue2 const & _value);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(217)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2, typename TCargo2> inline void insert(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TKey2 const & _key, TCargo2 const & _cargo);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(227)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline void insert(::std::map<TKey,TCargo, TCompare, TAlloc> & me,TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(235)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2, typename TCargo2, typename TSpec> inline void insert(::std::map<TKey,TCargo, TCompare, TAlloc> & me, Pair<TKey2,TCargo2,TSpec> const & _value);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(243)
template <typename TValue, typename TSpec, typename TValue2> inline void insert(Map<TValue, Skiplist<TSpec> > & me, TValue2 const & _value);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(722)
template <typename TValue, typename TSpec, typename TKey2, typename TCargo2> inline void insert(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key, TCargo2 const & _cargo);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(730)

//____________________________________________________________________________
// insertValues

template <typename TSumList, typename TValues> inline bool insertValues(Iter<TSumList, MiniSumListIterator > & it, TValues const & vals);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(888)
template <typename TSumList, typename TValue> inline bool insertValues(Iter<TSumList, MiniSumListIterator > & it, TValue const * p_vals);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(902)

//____________________________________________________________________________
// key

template <typename TElement> inline TElement & key(TElement & element);       	// "seqan-1.3.1/seqan/map/map_base.h"(182)
template <typename TElement> inline TElement const & key(TElement const & element);       	// "seqan-1.3.1/seqan/map/map_base.h"(188)
template <typename TKey, typename TObject, typename TSpec> inline TKey & key(Pair<TKey, TObject, TSpec> & element);       	// "seqan-1.3.1/seqan/map/map_base.h"(195)
template <typename TKey, typename TObject, typename TSpec> inline TKey const & key(Pair<TKey, TObject, TSpec> const & element);       	// "seqan-1.3.1/seqan/map/map_base.h"(201)
template <typename TSet> inline typename Key<TSet>::Type key(Iter<TSet, VectorSetIterator> &it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(420)
template <typename TSet> inline typename Key<TSet>::Type key(Iter<TSet, VectorSetIterator> const &it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(426)
template <typename TSet> inline typename Key<TSet>::Type key(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > > & pr);       	// "seqan-1.3.1/seqan/map/map_vector.h"(482)
template <typename TSet> inline typename Key<TSet>::Type key(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > > const & pr);       	// "seqan-1.3.1/seqan/map/map_vector.h"(488)
template <typename TStlMap> inline typename Key<TStlMap>::Type const & key(Iter<TStlMap, StlMapIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(465)
template <typename TStlMap> inline typename Key<TStlMap>::Type const & key(Iter<TStlMap, StlMapIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(472)
template <typename TStlMap> inline typename Key<TStlMap>::Type const & key(Iter<TStlMap, StlSetIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(661)
template <typename TStlMap> inline typename Key<TStlMap>::Type const & key(Iter<TStlMap, StlSetIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(668)
template <typename TSkiplist> inline typename Key<TSkiplist>::Type const & key(Iter<TSkiplist, SkiplistIterator> & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1111)
template <typename TSkiplist> inline typename Key<TSkiplist>::Type const & key(Iter<TSkiplist, SkiplistIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1117)

//____________________________________________________________________________
// length

template <typename TValue, typename TSpec> inline typename Size< Map<TValue, VectorSet<TSpec> > >::Type length(Map<TValue, VectorSet<TSpec> > const &set);       	// "seqan-1.3.1/seqan/map/map_vector.h"(170)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Size< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type length(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(242)
template <typename TValue, typename TCompare, typename TAlloc> inline typename Size< ::std::set<TValue, TCompare, TAlloc> >::Type length(::std::set<TValue, TCompare, TAlloc> const & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(199)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline typename Size< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type length(::std::map<TKey,TCargo, TCompare, TAlloc> const & me);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(207)
template <typename TValue, typename TSpec> inline typename Size< Map<TValue, Skiplist<TSpec> > >::Type length(Map<TValue, Skiplist<TSpec> > const & me);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(908)

//____________________________________________________________________________
// mapValue

template <typename TMap, typename TKey> inline typename MapValue<TMap>::Type mapValue(TMap & me, TKey const & _key);       	// "seqan-1.3.1/seqan/map/map_base.h"(172)
template <typename TValue, typename TSpec, typename TKey2> inline typename MapValue< Map<TValue, Skiplist<TSpec> > >::Type mapValue(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(984)

//____________________________________________________________________________
// operator!=

template <typename TSet> inline bool operator!=(Iter<TSet, VectorSetIterator> const &a, Iter<TSet, VectorSetIterator> const &b);       	// "seqan-1.3.1/seqan/map/map_vector.h"(396)
template <typename TSumList, typename TSumList2> inline bool operator!= (Iter<TSumList, MiniSumListIterator> const & left, Iter<TSumList2, MiniSumListIterator> const & right);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(948)
template <typename TStlMap> inline bool operator!= (Iter<TStlMap, StlMapIterator> const & left, Iter<TStlMap, StlMapIterator> const & right);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(373)
template <typename TStlMap> inline bool operator!= (Iter<TStlMap, StlSetIterator> const & left, Iter<TStlMap, StlSetIterator> const & right);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(571)
template <unsigned int DIM, typename TValue> inline bool operator!= (SumListValues<DIM, TValue> const & left, SumListValues<DIM, TValue> const & right);       	// "seqan-1.3.1/seqan/map/sumlist.h"(188)
template <typename TSkiplist> inline bool operator!= (Iter<TSkiplist, SkiplistIterator> const & left, Iter<TSkiplist, SkiplistIterator> const & right);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1150)

//____________________________________________________________________________
// operator+=

template <unsigned int DIM, typename TValue> inline SumListValues<DIM, TValue> const & operator+= (SumListValues<DIM, TValue> & left, SumListValues<DIM, TValue> const & right);       	// "seqan-1.3.1/seqan/map/sumlist.h"(149)

//____________________________________________________________________________
// operator-=

template <unsigned int DIM, typename TValue> inline SumListValues<DIM, TValue> const & operator-= (SumListValues<DIM, TValue> & left, SumListValues<DIM, TValue> const & right);       	// "seqan-1.3.1/seqan/map/sumlist.h"(163)

//____________________________________________________________________________
// operator==

template <typename TSet> inline bool operator==(Iter<TSet, VectorSetIterator> const &a, Iter<TSet, VectorSetIterator> const &b);       	// "seqan-1.3.1/seqan/map/map_vector.h"(389)
template <typename TSumList, typename TSumList2> inline bool operator== (Iter<TSumList, MiniSumListIterator> const & left, Iter<TSumList2, MiniSumListIterator> const & right);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(940)
template <typename TStlMap> inline bool operator== (Iter<TStlMap, StlMapIterator> const & left, Iter<TStlMap, StlMapIterator> const & right);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(364)
template <typename TStlMap> inline bool operator== (Iter<TStlMap, StlSetIterator> const & left, Iter<TStlMap, StlSetIterator> const & right);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(562)
template <unsigned int DIM, typename TValue> inline bool operator== (SumListValues<DIM, TValue> const & left, SumListValues<DIM, TValue> const & right);       	// "seqan-1.3.1/seqan/map/sumlist.h"(177)
template <typename TSkiplist> inline bool operator== (Iter<TSkiplist, SkiplistIterator> const & left, Iter<TSkiplist, SkiplistIterator> const & right);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1142)

//____________________________________________________________________________
// removeValues

template <typename TSumList> inline void removeValues(Iter<TSumList, MiniSumListIterator > & it);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(912)

//____________________________________________________________________________
// scanValues

template <typename TSumList, typename TValues> inline void scanValues( Iter< TSumList, MiniSumListValueIterator_ > & it,  TValues & values);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(621)

//____________________________________________________________________________
// searchSumList

template <typename TSumList, typename TValue> inline void searchSumList(Iter< TSumList, MiniSumListIterator > & it, TValue const & val, int dim);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(824)

//____________________________________________________________________________
// setCargo

template <typename TKey, typename TObject, typename TSpec, typename TSource> inline void setCargo(Pair<TKey, TObject, TSpec> & element, TSource const & source);       	// "seqan-1.3.1/seqan/map/map_base.h"(244)

//____________________________________________________________________________
// setKey

template <typename TElement, typename TSource> inline void setKey(TElement & element, TSource const & source);       	// "seqan-1.3.1/seqan/map/map_base.h"(211)
template <typename TKey, typename TObject, typename TSpec, typename TSource> inline void setKey(Pair<TKey, TObject, TSpec> & element, TSource const & source);       	// "seqan-1.3.1/seqan/map/map_base.h"(218)

//____________________________________________________________________________
// splitSumList

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline void splitSumList(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & right);       	// "seqan-1.3.1/seqan/map/sumlist_mini.h"(432)

//____________________________________________________________________________
// value

template <typename TSet> inline typename Reference<TSet>::Type value(Iter<TSet, VectorSetIterator> &it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(448)
template <typename TSet> inline typename Reference<TSet>::Type value(Iter<TSet, VectorSetIterator> const &it);       	// "seqan-1.3.1/seqan/map/map_vector.h"(455)
template <typename TStlMap> inline typename Value<TStlMap>::Type & value(Iter<TStlMap, StlMapIterator> & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(448)
template <typename TStlMap> inline typename Value<TStlMap>::Type & value(Iter<TStlMap, StlMapIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_adapter_stl.h"(455)
template <typename TValue, typename TSpec, typename TKey2> inline typename Value< Map<TValue, Skiplist<TSpec> > >::Type & value(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(641)
template <typename TSkiplist> inline typename Value<TSkiplist>::Type & value(Iter<TSkiplist, SkiplistIterator> & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1096)
template <typename TSkiplist> inline typename Value<TSkiplist>::Type & value(Iter<TSkiplist, SkiplistIterator> const & it);       	// "seqan-1.3.1/seqan/map/map_skiplist.h"(1102)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

