# Regression test specification for the gbz80 target.

EMU = $(SDCC_EXTRA_DIR)/emu/rrgb/rrgb$(EXEEXT)
MAKEBIN = $(top_builddir)/bin/makebin$(EXEEXT)

SDCCFLAGS += --nostdinc -I$(top_srcdir)
LINKFLAGS += --nostdlib -L$(top_builddir)/device/lib/build/gbz80

SDCCFLAGS += -mgbz80 --less-pedantic -DREENTRANT=
LINKFLAGS += --out-fmt-ihx gbz80.lib

OBJEXT = .rel
BINEXT = .gb

# otherwise `make` deletes testfwk.rel and `make -j` will fail
.PRECIOUS: $(PORT_CASES_DIR)/%$(OBJEXT)

# Needs parts of gbdk-lib, namely the internal mul/div/mod functions.
EXTRAS = $(PORT_CASES_DIR)/testfwk$(OBJEXT) $(PORT_CASES_DIR)/support$(OBJEXT)
include $(srcdir)/fwk/lib/spec.mk

# Rule to convert .ihx to .gb
%$(BINEXT): %.ihx
	$(MAKEBIN) -Z -yn ABS $< $@

# Rule to link into .ihx
%.ihx: %$(OBJEXT) $(EXTRAS) $(FWKLIB) $(PORT_CASES_DIR)/fwk.lib
	$(SDCC) $(SDCCFLAGS) $(LINKFLAGS) $(EXTRAS) $(PORT_CASES_DIR)/fwk.lib $< -o $@

$(PORT_CASES_DIR)/%$(OBJEXT): $(PORTS_DIR)/$(PORT)/%.asm
	@# TODO: sdas should place it\'s output in the current dir
	cp $< $(PORT_CASES_DIR)
	$(top_builddir)/bin/sdasgb -plosgff $(PORT_CASES_DIR)/$(notdir $<)
	rm $(PORT_CASES_DIR)/$(notdir $<)

%$(OBJEXT): %.c
	$(SDCC) $(SDCCFLAGS) -c $< -o $@

$(PORT_CASES_DIR)/%$(OBJEXT): $(PORTS_DIR)/$(PORT)/%.c
	$(SDCC) $(SDCCFLAGS) -c $< -o $@

$(PORT_CASES_DIR)/%$(OBJEXT): $(srcdir)/fwk/lib/%.c
	$(SDCC) $(SDCCFLAGS) -c $< -o $@

$(PORT_CASES_DIR)/fwk.lib: $(srcdir)/fwk/lib/fwk.lib
	cat < $(srcdir)/fwk/lib/fwk.lib > $@

# PENDING: Path to sdcc-extra
%.out: %$(BINEXT)
	mkdir -p $(dir $@)
	$(EMU) -k $< > $@
	-grep -n FAIL $@ /dev/null || true

_clean:
