/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TTYACCESS_H
#define TTYACCESS_H

#include "intincl.h"
#include <sys/types.h>

enum tty_types {
  TTY_TYPE_SERIAL,
  TTY_TYPE_BLUETOOTH
};

struct port_args_t {
  enum tty_types type;
  char* device;
  char* baud; /* for serial port */
  uint8_t channel; /* for bluetooth */
  uint8_t timeout;
  unsigned int ignorebits :1;
  unsigned int startdelay;
};

struct tty_access {
  char* (*read) (int (*stop_condition)(const char*, const size_t));
  int (*write) (const char* data, size_t count);
  void (*flush) (void);
  void (*close) (void);
};

struct tty_access* tty_open (struct port_args_t* args);
int tty_write (const char* data, size_t count,
	       long (*write_func) (const char* data, long len));

/* This function returns a char* that must be freed.
 * If it returns NULL, there was an error. Look at errno for the reason.
 * If the strlen(char*)==0, reading from the device timed out. Retry or abort.
 * (the timeout might only happen when the device was not opened with O_NONBLOCK,
 *  the timeout time refers to the value that was set as c_cc[VTIME])
 */
char* tty_read (int (*stop_condition)(const char*,const size_t),
		long (*read_func) (char* buf, long len));

#endif
