#  Copyright (C) 1999-2012
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc AnalysisMainMenu {} {
    global ds9

    # WARNING: this is a variable length menu. 
    # Be sure to update ds9(menu,size,analysis)
    menu $ds9(mb).analysis
    $ds9(mb).analysis add command -label "[msgcat::mc {Pixel Table}]..." \
	-command PixelTableDialog 
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "[msgcat::mc {Mask Parameters}]..." \
	-command MaskDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton -label [msgcat::mc {Contours}] \
	-variable contour(view) -command ContourUpdate
    $ds9(mb).analysis add command -label "[msgcat::mc {Contour Parameters}]..."\
	-command ContourDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton -label [msgcat::mc {Coordinate Grid}] \
	-variable grid(view) -command GridUpdate
    $ds9(mb).analysis add command \
	-label "[msgcat::mc {Coordinate Grid Parameters}]..." \
	-command GridDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton -label [msgcat::mc {Smooth}] \
	-variable smooth(view) -command SmoothUpdate
    $ds9(mb).analysis add command -label "[msgcat::mc {Smooth Parameters}]..." \
	-command SmoothDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "[msgcat::mc {Name Resolution}]..." \
	-command NRESDialog
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add cascade -label [msgcat::mc {Image Servers}] \
	-menu $ds9(mb).analysis.image
    $ds9(mb).analysis add cascade -label [msgcat::mc {Archives}] \
	-menu $ds9(mb).analysis.arch
    $ds9(mb).analysis add cascade -label [msgcat::mc {Catalogs}] \
	-menu $ds9(mb).analysis.cat
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "[msgcat::mc {Catalog Tool}]..." \
	-command CATTool
    $ds9(mb).analysis add command -label "[msgcat::mc {Line Plot Tool}]..." \
	-command PlotLineTool
    $ds9(mb).analysis add command -label "[msgcat::mc {Bar Plot Tool}]..." \
	-command PlotBarTool
    $ds9(mb).analysis add command -label "[msgcat::mc {Scatter Plot Tool}]..." \
	-command PlotScatterTool
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command -label "[msgcat::mc {Virtual Observatory}]..."\
	-command VODialog
    $ds9(mb).analysis add command -label "[msgcat::mc {Web Browser}]..." \
	-command {HV web Web {}}
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add checkbutton \
	-label [msgcat::mc {Analysis Command Log}] \
	-variable panalysis(log)
    $ds9(mb).analysis add separator
    $ds9(mb).analysis add command \
	-label "[msgcat::mc {Load Analysis Commands}]..." \
	-command OpenAnalysisMenu
    $ds9(mb).analysis add command \
	-label [msgcat::mc {Clear Analysis Commands}] \
	-command ClearAnalysisMenu

    menu $ds9(mb).analysis.image
    $ds9(mb).analysis.image add command \
	-label {SAO-DSS} -command SAODialog
    $ds9(mb).analysis.image add command \
	-label {ESO-DSS I/II} -command ESODialog
    $ds9(mb).analysis.image add command \
	-label {STSCI-DSS I/II} -command STSCIDialog
    $ds9(mb).analysis.image add command \
	-label {IPAC-2MASS} -command 2MASSDialog
    $ds9(mb).analysis.image add command \
	-label {NRAO-VLA FIRST} -command FIRSTDialog
    $ds9(mb).analysis.image add command \
	-label {NRAO-NVSS} -command NVSSDialog
    $ds9(mb).analysis.image add command \
	-label {HEASARC-SkyView} -command SkyViewDialog

    menu $ds9(mb).analysis.cat
    $ds9(mb).analysis.cat add command \
	-label [msgcat::mc {Search for Catalogs}] \
	-command "CATCDSSrchDialog catcdssrch1"
    $ds9(mb).analysis.cat add command -label [msgcat::mc {Clear All}] \
	-command CATClearFrame
    $ds9(mb).analysis.cat add command -label [msgcat::mc {Match}] \
	-command CATMatchFrame
    $ds9(mb).analysis.cat add separator
    CATCatalogMenu

    # Analysis Archive Menu
    menu $ds9(mb).analysis.arch
    $ds9(mb).analysis.arch add command -label {NVO Image Mosaic Service} \
	-command HVArchMontage
    $ds9(mb).analysis.arch add separator
    $ds9(mb).analysis.arch add cascade -label {Chandra} \
	-menu $ds9(mb).analysis.arch.chandra
    $ds9(mb).analysis.arch add command -label {ROSAT All-Sky (MPE/MPG)} \
	-command HVArchRosat
    $ds9(mb).analysis.arch add separator
    $ds9(mb).analysis.arch add command -label {NVSS (NRAO)} \
	-command HVArchNVSS
    $ds9(mb).analysis.arch add command -label {4MASS (NRAO)} \
	-command HVArch4MASS
    $ds9(mb).analysis.arch add command -label {SIRTF FLS/VLA (NRAO)} \
	-command HVArchSIRTF
    $ds9(mb).analysis.arch add command -label {VLA First (NRAO)} \
	-command HVArchFirst

    menu $ds9(mb).analysis.arch.chandra
    $ds9(mb).analysis.arch.chandra add command \
	-label {Chaser (NASA/SAO)} -command HVArchChandraChaser
    $ds9(mb).analysis.arch.chandra add command \
	-label {Fast Image (NASA/SAO)} -command HVArchChandraPop
    $ds9(mb).analysis.arch.chandra add command \
	-label {Public FTP (SAO)} -command HVArchChandraFTP

    menu $ds9(mb).analysis.arch.simbad
    $ds9(mb).analysis.arch.simbad add command -label {SAO} \
	-command HVArchSIMBADSAO
    $ds9(mb).analysis.arch.simbad add command -label {CDS} \
	-command HVArchSIMBADCDS

    menu $ds9(mb).analysis.arch.ads
    $ds9(mb).analysis.arch.ads add command -label {SAO} \
	-command HVArchADSSAO
    $ds9(mb).analysis.arch.ads add command -label {CDS} \
	-command HVArchADSCDS
}

proc UpdateAnalysisMenuStatic {} {
    global ds9

    global debug
    if {$debug(tcl,update)} {
	puts stderr "UpdateAnalysisMenuStatic"
    }

    if {$ds9(active,num) > 0} {
	$ds9(mb) entryconfig [msgcat::mc {Analysis}] -state normal
    } else {
	$ds9(mb) entryconfig [msgcat::mc {Analysis}] -state disabled
    }
}

proc UpdateAnalysisMenu {} {
    global ds9
    global current
    global ianalysis

    global debug
    if {$debug(tcl,update)} {
	puts stderr "UpdateAnalysisMenu"
    }

    if {$current(frame) != {}} {
	for {set ii 0} {$ii<$ianalysis(menu,count)} {incr ii} {

	    if {[$current(frame) has fits]} {
		set fn [$current(frame) get fits file name 1]
	    } else {
		set fn {none}
	    }

	    # disable by default
	    $ianalysis(menu,$ii,parent) entryconfig $ianalysis(menu,$ii,item) \
		-state disabled

	    foreach tt $ianalysis(menu,$ii,template) {
		if {[regexp ".$tt" $fn]} {
		    $ianalysis(menu,$ii,parent) entryconfig \
			$ianalysis(menu,$ii,item) -state normal
		    break
		}
	    }
	}
    }
}

proc PrefsDialogAnalysis {} {
    global dprefs

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {Analysis}]
    lappend dprefs(tabs) [ttk::frame $w.analysis]

    set f [ttk::labelframe $w.analysis.file \
	       -text [msgcat::mc {Analysis File}]]

    ttk::checkbutton $f.auto -text [msgcat::mc {Autoload}] \
	-variable panalysis(autoload)

    ttk::entry $f.pre -textvariable panalysis(user) -width 60
    ttk::button $f.browse -text [msgcat::mc {Browse}] \
	-command "AnalysisPrefOpen panalysis(user)"
    ttk::entry $f.pre2 -textvariable panalysis(user2) -width 60
    ttk::button $f.browse2 -text [msgcat::mc {Browse}] \
	-command "AnalysisPrefOpen panalysis(user2)"
    ttk::entry $f.pre3 -textvariable panalysis(user3) -width 60
    ttk::button $f.browse3 -text [msgcat::mc {Browse}] \
	-command "AnalysisPrefOpen panalysis(user3)"
    ttk::entry $f.pre4 -textvariable panalysis(user4) -width 60
    ttk::button $f.browse4 -text [msgcat::mc {Browse}] \
	-command "AnalysisPrefOpen panalysis(user4)"

    grid $f.auto -padx 2 -pady 2 -sticky w
    grid $f.pre $f.browse -padx 2 -pady 2 -sticky w
    grid $f.pre2 $f.browse2 -padx 2 -pady 2 -sticky w
    grid $f.pre3 $f.browse3 -padx 2 -pady 2 -sticky w
    grid $f.pre4 $f.browse4 -padx 2 -pady 2 -sticky w

    set f [ttk::labelframe $w.analysis.log -text [msgcat::mc {Analysis Log}]]

    ttk::checkbutton $f.log -text [msgcat::mc {Show Command}] \
	-variable panalysis(log)

    grid $f.log -padx 2 -pady 2 -sticky w

    pack $w.analysis.file $w.analysis.log -side top -fill both -expand true
}

proc PrefsDialogPixelTable {} {
    global dprefs
    global ppixel

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {Pixel Table}]
    lappend dprefs(tabs) [ttk::frame $w.pixel]

    set f [ttk::labelframe $w.pixel.param -text [msgcat::mc {Pixel Table}]]

    ttk::label $f.tsize -text [msgcat::mc {Size}]
    
    PrefsDialogPixelTableButtonCmd $ppixel(size)
    ttk::menubutton $f.size -textvariable dprefs(pixeltable,msg) \
	-menu $f.size.menu

    global ipixel
    set m $f.size.menu
    menu $m
    for {set ii 3} {$ii<=$ipixel(max)} {incr ii 2} {
	$m add radiobutton -label "${ii}x${ii}" -variable ppixel(size) \
	    -value $ii -command [list PrefsDialogPixelTableButtonCmd $ii]
    }
    grid $f.tsize $f.size -padx 2 -pady 2 -sticky w

    pack $f -side top -fill both -expand true
}

proc PrefsDialogPixelTableButtonCmd {ii} {
    global dprefs
    global pixel

    set dprefs(pixeltable,msg) "${ii}x${ii}"
}

proc PrefsDialogContour {} {
    global dprefs

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {Contours}]
    lappend dprefs(tabs) [ttk::frame $w.contour]

    set f [ttk::labelframe $w.contour.param -text [msgcat::mc {Contours}]]

    ttk::label $f.mtitle -text [msgcat::mc {Method}]
    ttk::menubutton $f.method -textvariable pcontour(method) \
	-menu $f.method.menu

    global pcontour
    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pcontour color {}

    ttk::label $f.wtitle -text [msgcat::mc {Width}]
    ttk::menubutton $f.width -textvariable pcontour(width) -menu $f.width.menu
    WidthDashMenu $f.width.menu pcontour width dash {} {}

    grid $f.mtitle $f.method -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color -padx 2 -pady 2 -sticky w
    grid $f.wtitle $f.width -padx 2 -pady 2 -sticky w

    set m $f.method.menu 
    menu $m
    $m add radiobutton -label [msgcat::mc {Block}] \
	-variable pcontour(method) -value block
    $m add radiobutton -label [msgcat::mc {Smooth}] \
	-variable pcontour(method) -value smooth

    pack $f -side top -fill both -expand true
}

proc PrefsDialogSmooth {} {
    global dprefs

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {Smooth}]
    lappend dprefs(tabs) [ttk::frame $w.smooth]

    set f [ttk::labelframe $w.smooth.param -text [msgcat::mc {Smooth}]]

    ttk::label $f.title -text [msgcat::mc {Function}]
    ttk::menubutton $f.function -textvariable psmooth(function) \
	-menu $f.function.menu

    menu $f.function.menu
    $f.function.menu add radiobutton -label [msgcat::mc {Boxcar}] \
	-variable psmooth(function) -value boxcar
    $f.function.menu add radiobutton -label [msgcat::mc {Tophat}] \
	-variable psmooth(function) -value tophat
    $f.function.menu add radiobutton -label [msgcat::mc {Gaussian}] \
	-variable psmooth(function) -value gaussian

    grid $f.title $f.function -padx 2 -pady 2 -sticky w

    pack $f -side top -fill both -expand true
}

proc PrefsDialogCatalog {} {
    global dprefs

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {Catalogs}]
    lappend dprefs(tabs) [ttk::frame $w.cat]

    # Catalog
    set f [ttk::labelframe $w.cat.param -text [msgcat::mc {Catalogs}]]

    ttk::label $f.stitle -text [msgcat::mc {Server}]
    ttk::menubutton $f.svr -textvariable pcat(server) -menu $f.svr.menu
    ttk::label $f.shtitle -text [msgcat::mc {Shape}]
    ttk::menubutton $f.shape -textvariable pcat(sym,shape) -menu $f.shape.menu
    ttk::checkbutton $f.vot -variable pcat(vot) \
	-text [msgcat::mc {Download VOTABLE format if available}]
    ttk::label $f.loctitle -text [msgcat::mc {IAU Location Code}]
    ttk::entry $f.loc -textvariable pcat(loc) -width 7

    global pcat
    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pcat sym,color {}

    ttk::label $f.ftitle -text [msgcat::mc {Font}]
    FontMenuButton $f.font pcat sym,font sym,font,size \
	sym,font,weight, sym,font,slant {}

    menu $f.svr.menu
    $f.svr.menu add radiobutton -label {CDS} \
	-variable pcat(server) -value cds
    $f.svr.menu add radiobutton -label {SAO} \
	-variable pcat(server) -value sao
    $f.svr.menu add radiobutton -label {CADC} \
	-variable pcat(server) -value cadc
    $f.svr.menu add radiobutton -label {ADAC} \
	-variable pcat(server) -value adac
    $f.svr.menu add radiobutton -label {IUCAA} \
	-variable pcat(server) -value iucaa
    $f.svr.menu add radiobutton -label {BEJING} \
	-variable pcat(server) -value bejing
    $f.svr.menu add radiobutton -label {CAMBRIDGE UK} \
	-variable pcat(server) -value cambridge
    $f.svr.menu add radiobutton -label {UKIRT HAWAII} \
	-variable pcat(server) -value ukirt

    menu $f.shape.menu
    $f.shape.menu add radiobutton -label [msgcat::mc {Circle}] \
	-variable pcat(sym,shape) -value circle
    $f.shape.menu add radiobutton -label [msgcat::mc {Ellipse}] \
	-variable pcat(sym,shape) -value ellipse
    $f.shape.menu add radiobutton -label [msgcat::mc {Box}] \
	-variable pcat(sym,shape) -value box
    $f.shape.menu add radiobutton -label [msgcat::mc {Text}] \
	-variable pcat(sym,shape) -value text
    $f.shape.menu add cascade -label [msgcat::mc {Point}] \
	-menu $f.shape.menu.point

    menu $f.shape.menu.point
    $f.shape.menu.point add radiobutton -label [msgcat::mc {Circle}] \
	-variable pcat(sym,shape) -value {circle point}
    $f.shape.menu.point add radiobutton -label [msgcat::mc {Box}] \
	-variable pcat(sym,shape) -value {box point}
    $f.shape.menu.point add radiobutton -label [msgcat::mc {Diamond}] \
	-variable pcat(sym,shape) -value {diamond point}
    $f.shape.menu.point add radiobutton -label [msgcat::mc {Cross}] \
	-variable pcat(sym,shape) -value {cross point}
    $f.shape.menu.point add radiobutton -label [msgcat::mc {X}] \
	-variable pcat(sym,shape) -value {x point}
    $f.shape.menu.point add radiobutton -label [msgcat::mc {Arrow}] \
	-variable pcat(sym,shape) -value {arrow point}
    $f.shape.menu.point add radiobutton -label [msgcat::mc {BoxCircle}] \
	-variable pcat(sym,shape) -value {boxcircle point}
    $f.shape.menu.point add separator

    grid $f.stitle $f.svr -padx 2 -pady 2 -sticky w
    grid $f.shtitle $f.shape -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color -padx 2 -pady 2 -sticky w
    grid $f.ftitle $f.font -padx 2 -pady 2 -sticky w
    grid $f.loctitle - - $f.loc -padx 2 -pady 2 -sticky w
    grid $f.vot - - - -padx 2 -pady 2 -sticky w

    pack $f -side top -fill both -expand true
}

proc PrefsDialogPlot {} {
    global dprefs

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {Plot}]
    lappend dprefs(tabs) [ttk::frame $w.plot]

    # Grid
    set f [ttk::labelframe $w.plot.grid -text [msgcat::mc {Grid}]]

    ttk::checkbutton $f.x -text [msgcat::mc {X Axis}] \
	-variable pap(grid,x)
    ttk::radiobutton $f.xlinear -text [msgcat::mc {Linear}] \
	-variable pap(grid,xlog) -value 0
    ttk::radiobutton $f.xlog -text [msgcat::mc {Log}] \
	-variable pap(grid,xlog) -value 1

    ttk::checkbutton $f.y -text [msgcat::mc {Y Axis}] \
	-variable pap(grid,y)
    ttk::radiobutton $f.ylinear -text [msgcat::mc {Linear}] \
	-variable pap(grid,ylog) -value 0
    ttk::radiobutton $f.ylog -text [msgcat::mc {Log}] \
	-variable pap(grid,ylog) -value 1

    grid $f.x $f.xlinear $f.xlog -padx 2 -pady 2 -sticky w
    grid $f.y $f.ylinear $f.ylog -padx 2 -pady 2 -sticky w

    # Font
    set f [ttk::labelframe $w.plot.font -text [msgcat::mc {Font}]]

    ttk::label $f.tnumlab -text [msgcat::mc {Axis Numbers}]
    FontMenuButton $f.numlab pap \
	numlabFont numlabSize numlabWeight numlabSlant {}
    ttk::label $f.ttextlab -text [msgcat::mc {Axis Label}]
    FontMenuButton $f.textlab pap \
	textlabFont textlabSize textlabWeight textlabSlant {}
    ttk::label $f.ttitle -text [msgcat::mc {Title}]
    FontMenuButton $f.title pap \
	titleFont titleSize titleWeight titleSlant {}

    grid $f.tnumlab $f.numlab $f.ttextlab $f.textlab $f.ttitle $f.title \
	-padx 2 -pady 2 -sticky w

    # Discrete
    set f [ttk::labelframe $w.plot.discrete -text [msgcat::mc {Discrete}]]

    ttk::checkbutton $f.show -text [msgcat::mc {Show}] \
	-variable pap(discrete)

    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pap discrete,color {}

    ttk::label $f.stitle -text [msgcat::mc {Symbol}]
    ttk::menubutton $f.symbol -textvariable pap(discrete,symbol) \
	-menu $f.symbol.menu

    ttk::checkbutton $f.fill -text [msgcat::mc {Fill}] \
	-variable pap(discrete,fill)

    grid $f.show -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color $f.stitle $f.symbol $f.fill \
	-padx 2 -pady 2 -sticky w

    PlotLineSymbolMenu $f.symbol.menu pap(discrete,symbol)

    # Line
    set f [ttk::labelframe $w.plot.linear -text [msgcat::mc {Linear}]]

    ttk::checkbutton $f.show -text [msgcat::mc {Show}] \
	-variable pap(linear)

    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pap linear,color {}

    ttk::label $f.wtitle -text [msgcat::mc {Width}]
    ttk::menubutton $f.width -textvariable pap(linear,width) -menu $f.width.menu
    ttk::label $f.dtitle -text [msgcat::mc {Dash}]
    ttk::menubutton $f.dash -textvariable pap(linear,dash) -menu $f.dash.menu

    grid $f.show -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color $f.wtitle $f.width 	$f.dtitle $f.dash \
	-padx 2 -pady 2 -sticky w

    PlotLineWidthMenu $f.width.menu pap(linear,width)
    PlotLineDashMenu $f.dash.menu pap(linear,dash)

    # Step
    set f [ttk::labelframe $w.plot.step -text [msgcat::mc {Step}]]

    ttk::checkbutton $f.show -text [msgcat::mc {Show}] \
	-variable pap(step)

    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pap step,color {}

    ttk::label $f.wtitle -text [msgcat::mc {Width}]
    ttk::menubutton $f.width -textvariable pap(step,width) -menu $f.width.menu
    ttk::label $f.dtitle -text [msgcat::mc {Dash}]
    ttk::menubutton $f.dash -textvariable pap(step,dash) -menu $f.dash.menu

    grid $f.show -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color $f.wtitle $f.width $f.dtitle $f.dash \
	-padx 2 -pady 2 -sticky w

    PlotLineWidthMenu $f.width.menu pap(step,width)
    PlotLineDashMenu $f.dash.menu pap(step,dash)

    # Quadratic
    set f [ttk::labelframe $w.plot.quadratic -text [msgcat::mc {Quadratic}]]

    ttk::checkbutton $f.show -text [msgcat::mc {Show}] \
	-variable pap(quadratic)

    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pap quadratic,color {}

    ttk::label $f.wtitle -text [msgcat::mc {Width}]
    ttk::menubutton $f.width -textvariable pap(quadratic,width) \
	-menu $f.width.menu
    ttk::label $f.dtitle -text [msgcat::mc {Dash}]
    ttk::menubutton $f.dash -textvariable pap(quadratic,dash) -menu $f.dash.menu

    grid $f.show -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color $f.wtitle $f.width $f.dtitle $f.dash \
	-padx 2 -pady 2 -sticky w

    PlotLineWidthMenu $f.width.menu pap(quadratic,width)
    PlotLineDashMenu $f.dash.menu pap(quadratic,dash)

    # Error
    set f [ttk::labelframe $w.plot.error -text [msgcat::mc {Error}]]
    
    ttk::checkbutton $f.show -text [msgcat::mc {Show}] \
	-variable pap(error)

    ttk::label $f.ctitle -text [msgcat::mc {Color}]
    ColorMenuButton $f.color pap error,color {}

    ttk::label $f.wtitle -text [msgcat::mc {Width}]
    ttk::menubutton $f.width -textvariable pap(error,width) -menu $f.width.menu

    grid $f.show -padx 2 -pady 2 -sticky w
    grid $f.ctitle $f.color $f.wtitle $f.width \
	-padx 2 -pady 2 -sticky w

    PlotLineWidthMenu $f.width.menu pap(error,width)

    pack $w.plot.grid $w.plot.font $w.plot.discrete $w.plot.linear \
	$w.plot.step $w.plot.quadratic $w.plot.error \
	-side top -fill both -expand true
}

proc PrefsDialogVO {} {
    global dprefs

    set w $dprefs(tab)

    $dprefs(list) insert end [msgcat::mc {VO}]
    lappend dprefs(tabs) [ttk::frame $w.vo]

    # Browser
    set f [ttk::labelframe $w.vo.browser -text [msgcat::mc {Browser}]]

    ttk::checkbutton $f.web -text [msgcat::mc {Use Internal Web Browser}] \
	-variable pvo(hv)
    ttk::radiobutton $f.xpa -text [msgcat::mc {Connect Directly}] \
	-variable pvo(method) -value xpa -command PrefsVOMethod
    ttk::radiobutton $f.mime -text [msgcat::mc {Connect Using Web Proxy}] \
	-variable pvo(method) -value mime -command PrefsVOMethod

    grid $f.web -padx 2 -pady 2 -sticky w
    grid $f.xpa $f.mime -padx 2 -pady 2 -sticky w

    # Server
    set f [ttk::labelframe $w.vo.server -text [msgcat::mc {VO Server}]]

    ttk::label $f.stitle -text [msgcat::mc {Default}]
    ttk::entry $f.server -textvariable pvo(server) -width 50

    grid $f.stitle $f.server -padx 2 -pady 2 -sticky w

    # Keep-Alive
    set f [ttk::labelframe $w.vo.keep -text [msgcat::mc {Keep-Alive}]]

    ttk::label $f.dtitle -text [msgcat::mc {Minutes}]
    ttk::entry $f.delay -textvariable pvo(delay) -width 5

    grid $f.dtitle $f.delay -padx 2 -pady 2 -sticky w

    pack $w.vo.browser $w.vo.server $w.vo.keep -side top -fill both -expand true
}



