// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "fitsimage.h"
#include "rice.h"
#include "gzip.h"
#include "gzraw.h"
#include "hcompress.h"
#include "plio.h"

void FitsImage::initCompress()
{
  int bitpix = fits_->getInteger("ZBITPIX",0);
  char* type = fits_->getString("ZCMPTYPE");
  if (!bitpix || !type) {
    if (type)
      delete [] type;
    return ;
  }

  if (compress_)
    delete compress_;
  compress_ = NULL;

  FitsHead* srcHead = fits_->head();
  FitsTableHDU* srcHDU = (FitsTableHDU*)(srcHead->hdu());
  FitsColumn* gzip = srcHDU->find("GZIP_COMPRESSED_DATA");

  // if GZIP_COMPRESS_DATA found, must be floating point, force gzraw
  if (gzip && (bitpix==-32 || bitpix==-64))
    memcpy(type,"GZRAW",5);

  if (!strncmp(type,"RICE",4))
    switch (bitpix) {
    case 8: 
      compress_ = new FitsRicem<unsigned char>(fits_);
      break;
    case 16:
      compress_ = new FitsRicem<short>(fits_);
      break;
    case -16:
      compress_ = new FitsRicem<unsigned short>(fits_);
      break;
    case 32:
      compress_ = new FitsRicem<int>(fits_);
      break;
    case 64:
      compress_ = new FitsRicem<long long>(fits_);
      break;
    case -32:
      compress_ = new FitsRicem<float>(fits_);
      break;
    case -64:
      compress_ = new FitsRicem<double>(fits_);
      break;
    }
  else if (!strncmp(type,"GZIP",4))
    switch (bitpix) {
    case 8: 
      compress_ = new FitsGzipm<unsigned char>(fits_);
      break;
    case 16:
      compress_ = new FitsGzipm<short>(fits_);
      break;
    case -16:
      compress_ = new FitsGzipm<unsigned short>(fits_);
      break;
    case 32:
      compress_ = new FitsGzipm<int>(fits_);
      break;
    case 64:
      compress_ = new FitsGzipm<long long>(fits_);
      break;
    case -32:
      compress_ = new FitsGzipm<float>(fits_);
      break;
    case -64:
      compress_ = new FitsGzipm<double>(fits_);
      break;
    }
  else if (!strncmp(type,"PLIO",4))
    switch (bitpix) {
    case 8: 
      compress_ = new FitsPliom<unsigned char>(fits_);
      break;
    case 16:
      compress_ = new FitsPliom<short>(fits_);
      break;
    case -16:
      compress_ = new FitsPliom<unsigned short>(fits_);
      break;
    case 32:
      compress_ = new FitsPliom<int>(fits_);
      break;
    case 64:
      compress_ = new FitsPliom<long long>(fits_);
      break;
    case -32:
      compress_ = new FitsPliom<float>(fits_);
      break;
    case -64:
      compress_ = new FitsPliom<double>(fits_);
      break;
    }
  else if (!strncmp(type,"HCOMPRESS",4))
    switch (bitpix) {
    case 8: 
      compress_ = new FitsHcompressm<unsigned char>(fits_);
      break;
    case 16:
      compress_ = new FitsHcompressm<short>(fits_);
      break;
    case -16:
      compress_ = new FitsHcompressm<unsigned short>(fits_);
      break;
    case 32:
      compress_ = new FitsHcompressm<int>(fits_);
      break;
    case 64:
      compress_ = new FitsHcompressm<long long>(fits_);
      break;
    case -32:
      compress_ = new FitsHcompressm<float>(fits_);
      break;
    case -64:
      compress_ = new FitsHcompressm<double>(fits_);
      break;
    }
  else if (!strncmp(type,"GZRAW",5))
    switch (bitpix) {
    case -32:
      compress_ = new FitsGzrawm<float>(fits_);
      break;
    case -64:
      compress_ = new FitsGzrawm<double>(fits_);
      break;
    }

  if (type)
    delete [] type;

  return;
}
