// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __iistcl_h__
#define __iistcl_h__

extern "C" {
  #include "ximtool.h"
}

extern int IISDebug;

#define MAXCHANNEL 40

class IIS {
 private:
  Tcl_Interp* interp;

 public:
  XimData xim;
  IoChan* chan[MAXCHANNEL];
  void (*func[MAXCHANNEL])(IoChan*, int*, void*);

 public:
  IIS(Tcl_Interp*);
  ~IIS();

  void eval(char*);
  char* evalstr(char*);
  const char* result() {return interp->result;}
  int open(int, const char*[]);
  int close();
  int retcur(int, const char*[]);
  int encodewcs(int, const char*[]);
  int debug(int, const char*[]);
};

extern IIS* iis;

#endif
