/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CProfileTab.cxx
    \author Romain BONDUE
    \date 05/08/2005 */
#include "CProfileTab.h"
#include "GtkGUI.h"
#include "Parameters.h"
#include "UserData.h"



namespace
{
    inline void PrepareButton (::GtkWidget* pButton,
                               void (*CallBack) (::GtkButton*,
                                                 nsGUI::CProfileTab*),
                               nsGUI::CProfileTab* This) throw()
    {
        ::gtk_widget_set_sensitive (pButton, false);
        ::g_signal_connect (G_OBJECT (pButton), "clicked",
                            G_CALLBACK (CallBack), This);

    } // PrepareButton()

} // anonymous namespace



const char* nsGUI::CProfileTab::ColumnTitle [NbColumn] = {"", "Profile",
                                            "SSID","Mode", "Channel",
                                            "Encryption", "Authentication"};

const ::GType nsGUI::CProfileTab::TabType [NbColumn] = {
                                                G_TYPE_BOOLEAN, G_TYPE_STRING,
                                                G_TYPE_STRING, G_TYPE_STRING,
                                                G_TYPE_UINT, G_TYPE_STRING,
                                                G_TYPE_STRING};


nsGUI::CProfileTab::CProfileTab (CGtkGUI* pUI) throw()
    : CSelectableRowList (NbColumn, TabType, ColumnTitle, pUI,
                          &CGtkGUI::ApplyProfile),
      m_pHBox (GTK_BOX (::gtk_hbox_new (false, 4))),
      m_pDeleteButton (::gtk_button_new_from_stock (GTK_STOCK_DELETE)),
      m_pEditButton (::gtk_button_new_from_stock (GTK_STOCK_EDIT)),
      m_pApplyButton (::gtk_button_new_from_stock (GTK_STOCK_APPLY))
{
    PrepareButton (m_pDeleteButton, DeleteButtonCallBack, this);
    PrepareButton (m_pEditButton, EditButtonCallBack, this);
    PrepareButton (m_pApplyButton, ApplyButtonCallBack, this);

    ::GtkWidget* const pNewProfileButton (::gtk_button_new_from_stock
                                                            (GTK_STOCK_NEW));
    ::g_signal_connect (G_OBJECT (pNewProfileButton), "clicked",
                        G_CALLBACK (NewProfileButtonCallBack), this);

    ::GtkBox* const pVBox (GTK_BOX (::gtk_vbutton_box_new()));
    ::gtk_button_box_set_layout (GTK_BUTTON_BOX (pVBox), GTK_BUTTONBOX_SPREAD);
    ::gtk_container_add (GTK_CONTAINER (pVBox), pNewProfileButton);
    ::gtk_container_add (GTK_CONTAINER (pVBox), m_pApplyButton);
    ::gtk_container_add (GTK_CONTAINER (pVBox), m_pEditButton);
    ::gtk_container_add (GTK_CONTAINER (pVBox), m_pDeleteButton);

    ::gtk_container_set_border_width (GTK_CONTAINER (m_pHBox), 6);
    ::gtk_box_pack_start_defaults (m_pHBox,
                               CSelectableRowList::operator ::GtkWidget*());
    ::gtk_box_pack_start_defaults (m_pHBox, GTK_WIDGET (pVBox));

} // CProfileTab()


void nsGUI::CProfileTab::SetProfile (unsigned Row,
                                     const nsUserData::CProfile& Profile)
                                                                        throw()
{
    SetData (Row, NamePos, Profile.GetName());
    SetData (Row, SSIDPos, Profile.GetSSID());
    SetData (Row, ModePos, nsWireless::GetModeName (Profile.GetMode()));
    SetData (Row, ChannelPos, Profile.GetChannel());
    SetData (Row, EncryptPos, nsWireless::GetEncryptName
                                    (Profile.GetEncryptionD().GetEncrypt()));
    SetData (Row, AuthPos, nsWireless::GetAuthName
                                        (Profile.GetEncryptionD().GetAuth()));

} // SetProfile()


void nsGUI::CProfileTab::DeleteButtonCallBack (::GtkButton*, CProfileTab* This)
                                                                        throw()
{
    const unsigned SelectedRow (This->GetSelectedRow());
    if (This->GetUI()->DeleteProfile (SelectedRow))
        This->DeleteRow (SelectedRow);

} // DeleteButtonCallBack()


void nsGUI::CProfileTab::EditButtonCallBack (::GtkButton*, CProfileTab* This)
                                                                        throw()
{
    const nsUserData::CProfile* const pProfile (This->GetUI()->EditProfile());
    if (pProfile)
    {
        This->SetSelected (This->GetSelectedRow(), false);
        This->SetProfile (This->GetSelectedRow(), *pProfile);
    }

} // EditButtonCallBack()


void nsGUI::CProfileTab::ApplyButtonCallBack (::GtkButton*, CProfileTab* This)
                                                                        throw()
{
    This->RowTriggered();

} // ApplyButtonCallBack()


void nsGUI::CProfileTab::NewProfileButtonCallBack (::GtkButton*,
                                                   CProfileTab* This) throw()
{
    const nsUserData::CProfile* const pProfile (This->GetUI()->NewProfile());
    if (pProfile) This->AddProfile (*pProfile);

} // NewProfileButtonCallBack()
