You attempted to use multiple types as bounds for a closure or trait object.
Rust does not currently support this. A simple example that causes this error:

```compile_fail,E0225
fn main() {
    let _: Box<dyn std::io::Read + std::io::Write>;
}
```

Auto traits such as Send and Sync are an exception to this rule:
It's possible to have bounds of one non-builtin trait, plus any number of
auto traits. For example, the following compiles correctly:

```
fn main() {
    let _: Box<dyn std::io::Read + Send + Sync>;
}
```
