use std::io::Read;
use std::fs::File;

use sequoia_openpgp as openpgp;
use openpgp::Result;

use sequoia_policy_config::ConfiguredStandardPolicy;

fn usage() -> ! {
    let binary = std::env::args().next()
        .unwrap_or_else(|| String::from("sequoia-policy-config-check"));
    eprintln!("Usage: {} [config.toml]", binary);
    eprintln!("");
    eprintln!("If no configuration is supplied, the default configuration \
               is checked.");
    std::process::exit(1);
}

fn main() -> Result<()> {
    let mut args = std::env::args();

    if args.len() > 2 {
        eprintln!("Expected at most one argument.");
        usage();
    }

    let mut p = ConfiguredStandardPolicy::new();

    if let Some(filename) = args.nth(1) {
        let mut file = File::open(filename)?;
        let mut bytes = Vec::new();
        file.read_to_end(&mut bytes)?;
        p.parse_bytes(bytes)?;
    } else {
        p.parse_default_config()?;
    }

    Ok(())
}
