= Video
* ((<Video Subsystem Outline>))
* ((<SDL::Screen>))
* ((<SDL::Surface>))
* ((<SDL::VideoInfo>))
* ((<Color, PixelFormat and Pixel value>))

* Methods
  * ((<SDL::Screen.get>)) -- returns the current display surface
  * ((<SDL::Screen.info>)) -- returns information about the video hardware
  * ((<SDL::Screen.driver_name>)) -- Obtain the name of the video driver
  * ((<SDL::Screen.list_modes>)) -- Returns an array of available screen dimensions for the given format and video flags
  * ((<SDL::Screen.check_mode>)) -- Check to see if a particular video mode is supported.
  * ((<SDL::Screen.open>)) -- Set up a video mode with the specified width, height and bits-per-pixel.
  * ((<SDL::Screen#update_rect>)) -- Makes sure the given area is updated on the given screen.
  * ((<SDL::Screen#update_rects>)) -- Makes sure the given list of rectangles is updated on the given screen
  * ((<SDL::Screen#flip>)) -- Swaps screen buffers
  * ((<SDL::Surface#set_colors>)) -- Sets a portion of the colormap for the given 8-bit surface.
  * ((<SDL::Surface#set_palette>)) -- Sets the colors in the palette of an 8-bit surface
  * ((<SDL::Screen.set_gamma>)) -- Sets the color gamma function for the display
  * ((<SDL::Screen.get_gamma_ramp>)) -- Gets the color gamma lookup tables for the display
  * ((<SDL::Screen.set_gamma_ramp>)) -- Sets the color gamma lookup tables for the display
  * ((<SDL::PixelFormat#map_rgb>)) -- RGB Map a RGB color value to a pixel format.
  * ((<SDL::PixelFormat#map_rgba>)) -- Map a RGBA color value to a pixel format.
  * ((<SDL::PixelFormat#get_rgb>)) -- Get RGB values from a pixel in the specified pixel format.
  * ((<SDL::PixelFormat#get_rgba>)) -- Get RGBA values from a pixel in the specified pixel format.
  * ((<SDL::Surface.new>)) -- Create an empty ((<SDL::Surface>))
  * ((<SDL::Surface.new_from>)) -- Create an ((<SDL::Surface>)) object from pixel data
  * ((<SDL::Surface#lock>)) -- Lock a surface for directly access.
  * ((<SDL::Surface#unlock>)) -- Unlocks a previously locked surface.
  * ((<SDL::Surface#must_lock?>)) -- Get whether the surface require locking or not.
  * ((<SDL::Surface.load_bmp>)) -- Load a Windows BMP file into an SDL_Surface.
  * ((<SDL::Surface.load_bmp_from_io>)) -- Load a Windows BMP file into an Surface from IO object.
  * ((<SDL::Surface#save_bmp>)) -- Save an SDL_Surface as a Windows BMP file.
  * ((<SDL::Surface#destroy>)) -- Frees a Surface
  * ((<SDL::Surface#destroyed?>)) -- Returns whether surface is destoryed or not.
  * ((<SDL::Surface#set_color_key>)) -- Sets the color key (transparent pixel) in a blittable surface and RLE acceleration.
  * ((<SDL::Surface#set_alpha>)) -- Adjust the alpha properties of a surface
  * ((<SDL::Surface#set_clip_rect>)) -- Sets the clipping rectangle for a surface.
  * ((<SDL::Surface#get_clip_rect>)) -- Gets the clipping rectangle for a surface.
  * ((<SDL::Surface.blit>)) -- This performs a fast blit from the source surface to the destination surface.
  * ((<SDL::Surface#fill_rect>)) -- This function performs a fast fill of the given rectangle with some color
  * ((<SDL::Surface#display_format>)) -- Convert a surface to the display format
  * ((<SDL::Surface#display_format_alpha>)) -- Convert a surface to the display format
  * ((<SDL::Surface#flags>)) -- Get surface flags
  * ((<SDL::Surface#format>)) -- Get surface pixel format
  * ((<SDL::Surface#w>)) -- Get surface width
  * ((<SDL::Surface#h>)) -- Get surface height
  * ((<SDL::Surface#pixels>)) -- Get the actual pixel data
  * ((<SDL::PixelFormat#Rmask>)) -- Get binary mask used to retrieve red color value
  * ((<SDL::PixelFormat#Gmask>)) -- Get binary mask used to retrieve green color value
  * ((<SDL::PixelFormat#Bmask>)) -- Get binary mask used to retrieve blue color value
  * ((<SDL::PixelFormat#Amask>)) -- Get binary mask used to retrieve alpla value
  * ((<SDL::PixelFormat#Rloss>)) -- Precision loss of red component
  * ((<SDL::PixelFormat#Gloss>)) -- Precision loss of green component
  * ((<SDL::PixelFormat#Bloss>)) -- Precision loss of blue component
  * ((<SDL::PixelFormat#Aloss>)) -- Precision loss of alpha component
  * ((<SDL::PixelFormat#Rshift>)) -- Binary left shift of red component in the pixel value
  * ((<SDL::PixelFormat#Gshift>)) -- Binary left shift of green component in the pixel value
  * ((<SDL::PixelFormat#Bshift>)) -- Binary left shift of blue component in the pixel value
  * ((<SDL::PixelFormat#Ashift>)) -- Binary left shift of alpha component in the pixel value
  * ((<SDL::Surface#colorkey>)) -- Pixel value of transparent pixels
  * ((<SDL::Surface#alpha>)) -- Overall surface alpha value
  * ((<SDL::PixelFormat#colorkey>)) -- Pixel value of transparent pixels.
  * ((<SDL::PixelFormat#alpha>)) -- Overall surface alpha value
  * ((<SDL::PixelFormat#bpp>)) -- The number of bits used to represent each pixel in a surface
  * ((<SDL::Surface#pitch>)) -- The number of bytes used for one scanline in a surface
  * ((<SDL::Surface.load>)) -- Load image into an surface
  * ((<SDL::Surface.load_from_io>)) -- Load a image file into an Surface from IO object.
  * ((<SDL::Surface#put_pixel>)) -- Writes a pixel to the specified position
  * ((<SDL::Surface#get_pixel>)) -- Gets the color of the specified pixel.
  * ((<SDL::Surface#put>)) -- Performs a fast blit from entire surface.
  * ((<SDL::Surface#copy_rect>)) -- Copies a part of surface.
  * ((<SDL::Surface.auto_lock?>)) -- Get whether surface is automatically locked
  * ((<SDL::Surface.auto_lock_on>)) -- Switch on auto locking
  * ((<SDL::Surface.auto_lock_off>)) -- Switch off auto locking.
  * ((<SDL::Surface.transform_draw>)) -- Draw a rotated and scaled image.
  * ((<SDL::Surface.transform_blit>)) -- Draw a rotated and scaled image with colorkey and blending
  * ((<SDL::Surface#draw_line>)) -- Draw a line
  * ((<SDL::Surface#draw_rect>)) -- Draws a rect
  * ((<SDL::Surface#draw_circle>)) -- Draws a circle
  * ((<SDL::Surface#draw_ellipse>)) -- Draws an ellipse.
  * ((<SDL::Surface#draw_bezier>)) -- Draws a bezier curve
  * ((<SDL::Surface#transform_surface>)) -- Creates an rotated an scaled surface

== Video Subsystem Outline
SDL presents a very simple interface to the display framebuffer.
The framebuffer is represented as an offscreen surface to which
you can write directly. If you want the screen to show what you
have written, call the ((<update|SDL::Screen#update_rect>))
function which will guarantee that
the desired portion of the screen is updated.

Before you call any of the SDL video functions, you must first
call ((<SDL.init>))(SDL::INIT_VIDEO), which initializes the video and
events in the SDL library. 

If you use both sound and video in your application, you need to
call ((<SDL.init>))(SDL::INIT_AUDIO | SDL::INIT_VIDEO) before opening
the sound device, otherwise under Win32 DirectX, you won't be
able to set full-screen display modes.

After you have initialized the library, you can start up the
video display in a number of ways. The easiest way is to pick a
common screen resolution and depth and just initialize the
video, checking for errors. You will probably get what you want,
but SDL may be emulating your requested mode and converting the
display on update. The best way is to ((<query|SDL::Screen.info>)), 
for the best video
mode closest to the desired one, and then 
((<convert|SDL::Surface#display_format>)) your images to 
that pixel format.

SDL currently supports any bit depth >= 8 bits per pixel. 8 bpp
formats are considered 8-bit palettized modes, while 12, 15, 16,
24, and 32 bits per pixel are considered "packed pixel" modes,
meaning each pixel contains the RGB color components packed in
the bits of the pixel.

After you have initialized your video mode, you can take the
surface that was returned, and write to it like any other
framebuffer, calling the update routine as you go.

== SDL::Surface
Graphical Surface class.

This class represent areas of "graphical" memory, memory that
can be drawn to. 

* ((<SDL::Surface#set_colors>)) -- Sets a portion of the colormap for the given 8-bit surface.
* ((<SDL::Surface#set_palette>)) -- Sets the colors in the palette of an 8-bit surface
* ((<SDL::Surface.new>)) -- Create an empty ((<SDL::Surface>))
* ((<SDL::Surface.new_from>)) -- Create an ((<SDL::Surface>)) object from pixel data
* ((<SDL::Surface#lock>)) -- Lock a surface for directly access.
* ((<SDL::Surface#unlock>)) -- Unlocks a previously locked surface.
* ((<SDL::Surface#must_lock?>)) -- Get whether the surface require locking or not.
* ((<SDL::Surface.load_bmp>)) -- Load a Windows BMP file into an SDL_Surface.
* ((<SDL::Surface.load_bmp_from_io>)) -- Load a Windows BMP file into an Surface from IO object.
* ((<SDL::Surface#save_bmp>)) -- Save an SDL_Surface as a Windows BMP file.
* ((<SDL::Surface#destroy>)) -- Frees a Surface
* ((<SDL::Surface#destroyed?>)) -- Returns whether surface is destoryed or not.
* ((<SDL::Surface#set_color_key>)) -- Sets the color key (transparent pixel) in a blittable surface and RLE acceleration.
* ((<SDL::Surface#set_alpha>)) -- Adjust the alpha properties of a surface
* ((<SDL::Surface#set_clip_rect>)) -- Sets the clipping rectangle for a surface.
* ((<SDL::Surface#get_clip_rect>)) -- Gets the clipping rectangle for a surface.
* ((<SDL::Surface.blit>)) -- This performs a fast blit from the source surface to the destination surface.
* ((<SDL::Surface#fill_rect>)) -- This function performs a fast fill of the given rectangle with some color
* ((<SDL::Surface#display_format>)) -- Convert a surface to the display format
* ((<SDL::Surface#display_format_alpha>)) -- Convert a surface to the display format
* ((<SDL::Surface#flags>)) -- Get surface flags
* ((<SDL::Surface#format>)) -- Get surface pixel format
* ((<SDL::Surface#w>)) -- Get surface width
* ((<SDL::Surface#h>)) -- Get surface height
* ((<SDL::Surface#pixels>)) -- Get the actual pixel data
* ((<SDL::Surface#colorkey>)) -- Pixel value of transparent pixels
* ((<SDL::Surface#alpha>)) -- Overall surface alpha value
* ((<SDL::Surface#pitch>)) -- The number of bytes used for one scanline in a surface
* ((<SDL::Surface.load>)) -- Load image into an surface
* ((<SDL::Surface.load_from_io>)) -- Load a image file into an Surface from IO object.
* ((<SDL::Surface#put_pixel>)) -- Writes a pixel to the specified position
* ((<SDL::Surface#get_pixel>)) -- Gets the color of the specified pixel.
* ((<SDL::Surface#put>)) -- Performs a fast blit from entire surface.
* ((<SDL::Surface#copy_rect>)) -- Copies a part of surface.
* ((<SDL::Surface.auto_lock?>)) -- Get whether surface is automatically locked
* ((<SDL::Surface.auto_lock_on>)) -- Switch on auto locking
* ((<SDL::Surface.auto_lock_off>)) -- Switch off auto locking.
* ((<SDL::Surface.transform_draw>)) -- Draw a rotated and scaled image.
* ((<SDL::Surface.transform_blit>)) -- Draw a rotated and scaled image with colorkey and blending
* ((<SDL::Surface#draw_line>)) -- Draw a line
* ((<SDL::Surface#draw_rect>)) -- Draws a rect
* ((<SDL::Surface#draw_circle>)) -- Draws a circle
* ((<SDL::Surface#draw_ellipse>)) -- Draws an ellipse.
* ((<SDL::Surface#draw_bezier>)) -- Draws a bezier curve
* ((<SDL::Surface#transform_surface>)) -- Creates an rotated an scaled surface

== SDL::Screen
Video framebuffer class. 

This class is subclass of ((<SDL::Surface>)), and contents 
is shown in display.

The video framebuffer is returned by 
((<SDL::Screen.open>)) and ((<SDL::Screen.get>)).

* ((<SDL::Screen.get>)) -- returns the current display surface
* ((<SDL::Screen.info>)) -- returns information about the video hardware
* ((<SDL::Screen.driver_name>)) -- Obtain the name of the video driver
* ((<SDL::Screen.list_modes>)) -- Returns an array of available screen dimensions for the given format and video flags
* ((<SDL::Screen.check_mode>)) -- Check to see if a particular video mode is supported.
* ((<SDL::Screen.open>)) -- Set up a video mode with the specified width, height and bits-per-pixel.
* ((<SDL::Screen#update_rect>)) -- Makes sure the given area is updated on the given screen.
* ((<SDL::Screen#update_rects>)) -- Makes sure the given list of rectangles is updated on the given screen
* ((<SDL::Screen#flip>)) -- Swaps screen buffers
* ((<SDL::Screen.set_gamma>)) -- Sets the color gamma function for the display
* ((<SDL::Screen.get_gamma_ramp>)) -- Gets the color gamma lookup tables for the display
* ((<SDL::Screen.set_gamma_ramp>)) -- Sets the color gamma lookup tables for the display

== SDL::VideoInfo
Video Target information class.

The instance of this class is returned by ((<SDL::Screen.info>)). It
contains information on either the 'best' available mode (if
called before ((<SDL::Screen.open>))) or the current video mode.

This class has following methods.

--- SDL::VideoInfo#hw_available

    Is it possible to create hardware surfaces?

--- SDL::VideoInfo#wm_available
    
    Is there a window manager available?

--- SDL::VideoInfo#blit_hw
    
    Are hardware to hardware blits accelerated?

--- SDL::VideoInfo#blit_hw_CC
    
    Are hardware to hardware colorkey blits accelerated?

--- SDL::VideoInfo#blit_hw_A
    
    Are hardware to hardware alpha blits accelerated?

--- SDL::VideoInfo#blit_sw
    
    Are software to hardware blits accelerated?

--- SDL::VideoInfo#blit_sw_CC
    
    Are software to hardware colorkey blits accelerated?

--- SDL::VideoInfo#blit_sw_A
    
    Are software to hardware alpha blits accelerated?

--- SDL::VideoInfo#blit_fill
    
    Are color fills accelerated?

--- SDL::VideoInfo#video_mem
    
    Total amount of video memory in Kilobytes

--- SDL::VideoInfo#bpp
    
    bits per pixel of the video device

== SDL::PixelFormat
Surface format information class.
Please see ((<Color, PixelFormat and Pixel value>)).

* ((<SDL::PixelFormat#map_rgb>)) -- RGB Map a RGB color value to a pixel format.
* ((<SDL::PixelFormat#map_rgba>)) -- Map a RGBA color value to a pixel format.
* ((<SDL::PixelFormat#get_rgb>)) -- Get RGB values from a pixel in the specified pixel format.
* ((<SDL::PixelFormat#get_rgba>)) -- Get RGBA values from a pixel in the specified pixel format.
* ((<SDL::PixelFormat#Rmask>)) -- Get binary mask used to retrieve red color value
* ((<SDL::PixelFormat#Gmask>)) -- Get binary mask used to retrieve green color value
* ((<SDL::PixelFormat#Bmask>)) -- Get binary mask used to retrieve blue color value
* ((<SDL::PixelFormat#Amask>)) -- Get binary mask used to retrieve alpla value
* ((<SDL::PixelFormat#Rloss>)) -- Precision loss of red component
* ((<SDL::PixelFormat#Gloss>)) -- Precision loss of green component
* ((<SDL::PixelFormat#Bloss>)) -- Precision loss of blue component
* ((<SDL::PixelFormat#Aloss>)) -- Precision loss of alpha component
* ((<SDL::PixelFormat#Rshift>)) -- Binary left shift of red component in the pixel value
* ((<SDL::PixelFormat#Gshift>)) -- Binary left shift of green component in the pixel value
* ((<SDL::PixelFormat#Bshift>)) -- Binary left shift of blue component in the pixel value
* ((<SDL::PixelFormat#Ashift>)) -- Binary left shift of alpha component in the pixel value
* ((<SDL::PixelFormat#colorkey>)) -- Pixel value of transparent pixels.
* ((<SDL::PixelFormat#alpha>)) -- Overall surface alpha value
* ((<SDL::PixelFormat#bpp>)) -- The number of bits used to represent each pixel in a surface

== Color, PixelFormat and Pixel value

=== Outline
In Ruby/SDL, color is described as four elements
of 8-bit unsigned interger(from 0 to 255), Red, Green,
Blue and Alpha. In Ruby/SDL, this values are
packed as unsigned n-bit integer(n=8,16,24,32).
The rules of this conversion is called PixelFormat
and converted n-bit integer is called pixel value.
Each surface has one PixelFormat, and you can use
((<SDL::Surface#format>)) to get PixelFormat from surface object.
You can also covert from or to pixel values calling
((<SDL::PixelFormat#map_rgb>)), ((<SDL::PixelFormat#map_rgba>)),
((<SDL::PixelFormat#get_rgb>)) and ((<SDL::PixelFormat#get_rgba>)).
You can use pixel value or 3 elements array 
or 4 elements array as color parameter.
Return values are normally pixel values.

=== Details
Not documented yet.

== Video Methods 

--- SDL.get_video_surface
--- SDL.getVideoSurface

    This method is obsolete. Please use ((<SDL::Screen.get>)) instead.

--- SDL::Screen.get

    This method returns the current display surface.
    If SDL is doing format conversion on the display surface, this
    method returns the publicly visible surface, not the real
    video surface.

    Returns the instance of ((<SDL::Screen>)).

    Raises ((<SDL::Error>)) on failure
--- SDL.video_info
--- SDL.videoInfo

    This method is obsolete. Please use ((<SDL::Screen.info>)) instead.

--- SDL::Screen.info

    This function returns a ((<information|SDL::VideoInfo>)) about
    the video hardware. If this is called before ((<SDL::Screen.open>)),
    bpp attribute of the returned object will contain the pixel
    format of the "best" video mode.

    Returns the instance of ((<SDL::VideoInfo>)).

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Screen.open>)), ((<SDL::VideoInfo>))

--- SDL.video_driver_name
--- SDL.videoDriverName

    This method is obsolete. Please use ((<SDL::Screen.driver_name>)) instead.

--- SDL::Screen.driver_name
--- SDL::Screen.driverName

    The driver name is a simple one
    word identifier like "x11" or "windib".

    Returns driver name as string.

    Raises ((<SDL::Error>)) if video has not been initialized with 
    ((<SDL.init>)).

    * See Also
      
      ((<SDL.init>))

--- SDL.list_modes(flags)
--- SDL.listModes(flags)

    This method is obsolete. Please use ((<SDL::Screen.list_modes>)) instead.

--- SDL::Screen.list_modes(flags)
--- SDL::Screen.listModes(flags)

    Return an array of available screen dimensions for
    the given format and video flags, sorted largest to smallest.
    
    Returns nil if there are no dimensions available for a
    particular format, or true if any dimension is okay for the given
    format.
    The flag parameter is an OR'd
    combination of surface flags. The flags are the same as those
    used ((<SDL::Screen.open>)) and they play a strong role in deciding
    what modes are valid.
    For instance, if you pass SDL::HWSURFACE as
    a flag only modes that support hardware video surfaces will be
    returned.


    EXAMPLE
      # Get available fullscreen/hardware modes
      modes = SDL::Screen.list_modes(SDL::FULLSCREEN|SDL::HWSURFACE)
      
      # Check is there are any modes available
      if modes == nil
        puts "No modes available!"
        exit 1
      end
      
      # Check is there are any modes available
      if modes == true
        puts "All resolutions available."
      else
        # Print valid modes
        puts "Available Modes"
        modes.each{|w, h| puts "  #{w} x #{h}"}
      end

    * See Also
      
      ((<SDL::Screen.open>)), ((<SDL::Screen.info>))

--- SDL.check_video_mode(w,h,bpp,flags)
--- SDL.checkVideoMode(w,h,bpp,flags)

    This method is obsolete. Please use ((<SDL::Screen.check_mode>)) instead.

--- SDL::Screen.check_mode(w,h,bpp,flags)
--- SDL::Screen.checkMode(w,h,bpp,flags)

    Returns 0 if the requested mode is not supported
    under any bit depth,
    or returns the bits-per-pixel of the
    closest available mode with the given width, height and
    requested surface flags (see ((<SDL::Screen.open>))).
    
    The bits-per-pixel value returned is only a suggested mode. You
    can usually request and bpp you want when 
    ((<setting|SDL::Screen.opn>)) the video mode
    and SDL will emulate that color depth with a shadow video
    surface.


    EXAMPLE
      puts "Checking mode 640x480@16bpp."
      bpp = SDL::Screen.check_mode(640, 480, 16, SDL::HWSURFACE)
      if bpp == 0
        puts "Mode not available."
        exit 1
      end
      
      puts "SDL Recomemends 640x480@#{bpp}bpp."
      screen = SDL::Screen.open(640, 480, bpp, SDL_HWSURFACE)

    * See Also
      
      ((<SDL::Screen.open>)), ((<SDL::Screen.info>))

--- SDL.setVideoMode(w,h,bpp,flags)
--- SDL.set_video_mode(w,h,bpp,flags)

    This method is obsolete. Please use ((<SDL::Screen.open>)) instead.

--- SDL::Screen.open(w,h,bpp,flags)

    Set up a video mode with the specified width, height and
    bits-per-pixel.
    
    If bpp is 0, it is treated as the current display bits per
    pixel.
    
    The flags parameter is the same as the ((<SDL::Surface#flags>))
    OR'd combinations of the following values
    are valid.
    
    :SDL::SWSURFACE
      Create the video surface in system memory
    :SDL::HWSURFACE
      Create the video surface in video memory
    :SDL::ASYNCBLIT
      Enables the use of asynchronous updates of the
      display surface. This will usually slow down
      blitting on single CPU machines, but may
      provide a speed increase on SMP systems.
    :SDL::ANYFORMAT
      Normally, if a video surface of the requested
      bits-per-pixel (((|bpp|))) is not available, SDL will
      emulate one with a shadow surface. Passing
      SDL_ANYFORMAT prevents this and causes SDL to
      use the video surface, regardless of its pixel
      depth.
    :SDL::HWPALETTE
      Give SDL exclusive palette access. Without this
      flag you may not always get the the colors you
      request with ((<SDL::Surface#set_colors>)) or ((<SDL::Surface#set_palette>)).
    :SDL::DOUBLEBUF
      Enable hardware double buffering; only valid
      with SDL::HWSURFACE. Calling ((<SDL::Screen#flip>)) will flip
      the buffers and update the screen. All drawing
      will take place on the surface that is not
      displayed at the moment. If double buffering
      could not be enabled then ((<SDL::Screen#flip>)) will just
      perform a ((<SDL::Screen#update_rect>)) on the entire screen.
    :SDL::FULLSCREEN
      SDL will attempt to use a fullscreen mode. If a
      hardware resolution change is not possible (for
      whatever reason), the next higher resolution
      will be used and the display window centered on
      a black background.
    :SDL::OPENGL
      Create an OpenGL rendering context. You should
      have previously set OpenGL video attributes
      with ((<SDL::GL.set_attr>)).
    :SDL::OPENGLBLIT
      Create an OpenGL rendering context, like above,
      but allow normal blitting operations. The
      screen (2D) surface may have an alpha channel,
      and ((<SDL::Screen.update_rect>)) must be used for updating
      changes to the screen surface. NOTE: This
      option is kept for compatibility only, and is
      ((*not recommended*)) for new code.
    
    :SDL::RESIZABLE
      Create a resizable window. When the window is
      resized by the user a ((<SDL::Event::VideoResize>)) event is
      generated and ((<SDL::Screen.open>)) can be called
      again with the new size.
    :SDL::NOFRAME
      If possible, SDL::NOFRAME causes SDL to create a
      window with no title bar or frame decoration.
      Fullscreen modes automatically have this flag
      set.

    Returns the framebuffer surface as instace of ((<SDL::Screen>)).

    Raises ((<SDL::Error>)) on failure
    * NOTES

      Whatever flags ((<SDL::Screen.open>)) could satisfy are set
      in the ((|Surface#flags|)) of the returned surface.
      
      The ((|bpp|)) parameter is the number of bits per pixel, so
      a ((|bpp|)) of 24 uses the packed representation of 3 bytes/pixel.
      For the more common 4 bytes/pixel mode, use a ((|bpp|)) of 32.
      Somewhat oddly, both 15 and 16 will request a 2 bytes/pixel
      mode, but different pixel formats.

    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL::Surface#set_colors>)), ((<SDL::Screen#flip>)), ((<SDL::Screen>))

--- SDL::Screen#updateRect(x,y,w,h)
--- SDL::Screen#update_rect(x,y,w,h)

    Makes sure the given area is updated on the given screen. The
    rectangle must be confined within the screen boundaries (no
    clipping is done).
    
    If ((|x|)), ((|y|)), ((|w|)) and ((|h|)) are all 0, this method
    update the entire screen.
    
    This method should not be called while screen is
    ((|locked|Surface#lock|)).

    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL::Screen#update_rects>))

--- SDL::Screen#update_rects(*rects)
--- SDL::Screen#updateRects(*rects)

    Makes sure the given list of rectangles is updated on the given
    screen. Each rectangle parameter should be an array
    of 4 elements as [x, y, w, h].
    The rectangles must all be confined within the screen
    boundaries (no clipping is done).
    
    This method should not be called while screen(((|self|))),
    is ((<locked|SDL::Surface#lock>)).

    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL::Screen#update_rect>))

--- SDL::Screen#flip

    On hardware that supports double-buffering, this function sets
    up a flip and returns. The hardware will wait for vertical
    retrace, and then swap video buffers before the next video
    surface blit or lock will return. On hardware that doesn't
    support double-buffering, this is equivalent to calling 
    ((|self|)).((<update_rect|SDL::Screen#update_rect>))(0, 0, 0, 0)

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL.set_video_mode>)), ((<SDL::Screen#update_rect>))

--- SDL::Surface#set_colors(colors,firstcolor)
--- SDL::Surface#setColors(colors,firstcolor)

    Sets a portion of the colormap for the given 8-bit surface.
    
    When ((|self|)) is the surface associated with the current display,
    the display colormap will be updated with the requested colors.
    If SDL::HWPALETTE was set in ((<SDL::Screen.open>)) flags,
    this method will always return true, and the palette is
    guaranteed to be set the way you desire, even if the window
    colormap has to be warped or run under emulation.
    
    ((|colors|)) is array of colors, one color has three componets,
    R, G, B and each component is 8-bits in size.
    
    Palettized (8-bit) screen surfaces with the SDL::HWPALETTE flag
    have two palettes, a logical palette that is used for mapping
    blits to/from the surface and a physical palette (that
    determines how the hardware will map the colors to the display).
    SDL_SetColors modifies both palettes (if present), and is
    equivalent to calling ((<SDL::Surface#set_palette>)) 
    with the flags set to (SDL::OGPAL | SDL::PHYSPAL).

    If ((|self|)) is not a palettized surface, this method does
    nothing, returning false.
    If all of the colors were set as passed to
    this method, it will return true.
    If not all the color entries
    were set exactly as given, it will return false,
    and you should look
    at the surface palette to determine the actual color palette.


    EXAMPLE
      # Create a display surface with a grayscale palette
      
      # Fill colors with color information
      colors = Array.new(256){|i| [i, i, i]}
      # Create display
      screen = SDL::Screen.open(640, 480, 8, SDL::HWPALETTE)
      
      # Set palette
      screen.set_colors(colors, 0)

    * See Also
      
      ((<SDL::Surface#set_palette>)), ((<SDL::Screen.open>))

--- SDL::Surface#set_palette(flags,colors,firstcolor)
--- SDL::Surface#setPalette(flags,colors,firstcolor)

    Sets a portion of the palette for the given 8-bit surface.
    
    Palettized (8-bit) screen surfaces with the SDL::HWPALETTE flag
    have two palettes, a logical palette that is used for mapping
    blits to/from the surface and a physical palette (that
    determines how the hardware will map the colors to the display).
    ((<SDL::Surface.blit>)) always uses the logical palette when blitting
    surfaces (if it has to convert between surface pixel formats).
    Because of this, it is often useful to modify only one or the
    other palette to achieve various special color effects (e.g.,
    screen fading, color flashes, screen dimming).
    
    This method can modify either the logical or physical palette
    by specifing SDL::LOGPAL or SDL::PHYSPALthe in the ((|flags|))
    parameter.
    
    When ((|self|)) is the surface associated with the current display,
    the display colormap will be updated with the requested colors.
    If SDL::HWPALETTE was set in ((<SDL::Screen.open>)) flags,
    this method will always return true, and the palette is
    guaranteed to be set the way you desire, even if the window
    colormap has to be warped or run under emulation.
    
    ((|colors|)) is array of colors, one color has three componets,
    R, G, B and each component is 8-bits in size.

    If surface is not a palettized surface, this function does
    nothing, returning false.
    If all of the colors were set as passed to
    this method, it will return true.
    If not all the color entries
    were set exactly as given, it will return false,
     and you should look
    at the surface palette to determine the actual color palette.


    EXAMPLE
      # Create a display surface with a grayscale palette
      
      # Fill colors with color information
      colors = Array.new(256){|i| [i, i, i]}
      # Create display
      screen = SDL::Screen.open(640, 480, 8, SDL::HWPALETTE)
      
      # Setpalette
      screen.set_palette(SDL::LOGPAL|SDL::PHYSPAL, colors, 0)

    * See Also
      
      ((<SDL::Surface#set_colors>)), ((<SDL::Screen.open>))

--- SDL.set_gamma(redgamma,greengamma,bluegamma)
--- SDL.setGamma(redgamma,greengamma,bluegamma)

    This method is obsolete. Please use ((<SDL::Screen.set_gamma>)) instead.

--- SDL::Screen.set_gamma(redgamma,greengamma,bluegamma)
--- SDL::Screen.setGamma(redgamma,greengamma,bluegamma)

    Sets the "gamma function" for the display of each color
    component. Gamma controls the brightness/contrast of colors
    displayed on the screen. A gamma value of 1.0 is identity (i.e.,
    no adjustment is made).
    
    This function adjusts the gamma based on the "gamma function"
    parameter, you can directly specify lookup tables for gamma
    adjustment with ((<SDL::Screen.set_gamma_ramp>)).

    Raises ((<SDL::Error>)) on failure
    * NOTES

      Not all display hardware is able to change gamma.

    * See Also
      
      ((<SDL::Screen.get_gamma_ramp>)), ((<SDL::Screen.set_gamma_ramp>))

--- SDL.get_gamma_ramp
--- SDL.getGammaRamp

    This method is obsolete. Please use ((<SDL::Screen.get_gamma_ramp>)) instead.

--- SDL::Screen.get_gamma_ramp
--- SDL::Screen.getGammaRamp

    Gets the gamma translation lookup tables currently used by the
    display. Each table is an array of 256 16bit unsigned integer
    values.

    Returns an array of 3 elements of an array of 256 16bit unsigned integer.

    Raises ((<SDL::Error>)) on failure
    * NOTES

      Not all display hardware is able to change gamma.

    * See Also
      
      ((<SDL::Screen.set_gamma>)), ((<SDL::Screen.set_gamma_ramp>))

--- SDL.set_gamma_ramp(table)
--- SDL.setGammaRamp(table)

    This method is obsolete. Please use ((<SDL::Screen.set_gamma_ramp>)) instead.

--- SDL::Screen.set_gamma_ramp(tables)
--- SDL::Screen.setGammaRamp(tables)

    Sets the gamma lookup tables for the display for each color
    component. 
    ((|tables|)) parameter is same as ((<SDL::Screen.get_gamma_ramp>)),
    representing a mapping between the input and output for that
    channel. The input is the index into the array, and the output
    is the 16-bit gamma value at that index, scaled to the output
    color precision. 
    
    This function adjusts the gamma based on lookup tables, you can
    also have the gamma calculated based on a "gamma function"
    parameter with ((<SDL::Screen.set_gamma>)).

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Screen.set_gamma>)), ((<SDL::Screen.get_gamma_ramp>))

--- SDL::Surface#map_rgb(r,g,b)
--- SDL::Surface#mapRGB(r,g,b)

    This method is obsolete. Please use ((<SDL::PixelFormat#map_rgb>)) instead.

--- SDL::PixelFormat#map_rgb(r,g,b)
--- SDL::PixelFormat#mapRGB(r,g,b)

    Maps the RGB color value to the specified pixel format and
    returns the pixel value as a 32-bit integer.
    ((|r|)), ((|g|)), ((|b|)) should be more than and equal to 0,
    and less than or equal to 255.
    
    If the format has a palette (8-bit) the index of the closest
    matching color in the palette will be returned.
    
    If the specified pixel format has an alpha component it will be
    returned as all 1 bits (fully opaque).

    A pixel value best approximating the given RGB color value for a
    given pixel format. If the pixel format bpp (color depth) is
    less than 32-bpp then the unused upper bits of the return value
    can safely be ignored (e.g., with a 16-bpp format the return
    value can be assigned to a 16-bit unsigned integer,
    and similarly a 8-bit unsigned integer for an 8-bpp format).

    * See Also
      
      ((<SDL::PixelFormat#get_rgb>)), ((<SDL::PixelFormat#get_rgba>)), ((<SDL::PixelFormat#map_rgba>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface#map_rgba(r,g,b,a)
--- SDL::Surface#mapRGBA(r,g,b,a)

    This method is obsolete. Please use ((<SDL::PixelFormat#map_rgba>)) instead.

--- SDL::PixelFormat#map_rgba(r,g,b,a)
--- SDL::PixelFormat#mapRGBA(r,g,b,a)

    Maps the RGBA color value to the specified pixel format and
    returns the pixel value as a 32-bit integer.
    ((|r|)), ((|g|)), ((|b|)) should be more than and equal to 0,
    and less than or equal to 255.
    
    If the format has a palette (8-bit) the index of the closest
    matching color in the palette will be returned.
    
    If the specified pixel format has no alpha component the alpha
    value will be ignored (as it will be in formats with a palette).

    A pixel value best approximating the given RGBA color value for a
    given pixel format. If the pixel format bpp (color depth) is
    less than 32-bpp then the unused upper bits of the return value
    can safely be ignored (e.g., with a 16-bpp format the return
    value can be assigned to a 16-bit unsigned integer,
    and similarly a 8-bit unsigned integer for an 8-bpp format).

    * See Also
      
      ((<SDL::PixelFormat#get_rgb>)), ((<SDL::PixelFormat#get_rgba>)), ((<SDL::PixelFormat#map_rgb>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface#get_rgb(pixel)
--- SDL::Surface#getRGB(pixel)

    This method is obsolete. Please use ((<SDL::PixelFormat#get_rgb>)) instead.

--- SDL::PixelFormat#get_rgb(pixel)
--- SDL::PixelFormat#getRGB(pixel)

    Get RGB component values from a pixel stored in the specified
    pixel format. It returns an array of 3 elements.
    
    This function uses the entire 8-bit [0..255] range when
    converting color components from pixel formats with less than
    8-bits per RGB component (e.g., a completely white pixel in
    16-bit RGB565 format would return [0xff, 0xff, 0xff] not [0xf8,
    0xfc, 0xf8]).

    * See Also
      
      ((<SDL::PixelFormat#get_rgba>)), ((<SDL::PixelFormat#map_rgb>)), ((<SDL::PixelFormat#map_rgba>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface#get_rgba(pixel)
--- SDL::Surface#getRGBA(pixel)

    This method is obsolete. Please use ((<SDL::PixelFormat#get_rgba>)) instead.

--- SDL::PixelFormat#get_rgba(pixel)
--- SDL::PixelFormat#getRGBA(pixel)

    Get RGBA component values as array of four elements 
    from a pixel stored in the specified
    pixel format.
    
    This function uses the entire 8-bit [0..255] range when
    converting color components from pixel formats with less than
    8-bits per RGB component (e.g., a completely white pixel in
    16-bit RGB565 format would return [0xff, 0xff, 0xff] not [0xf8,
    0xfc, 0xf8]).
    
    If the surface has no alpha component, the alpha will be
    returned as 0xff (100% opaque).

    * See Also
      
      ((<SDL::PixelFormat#get_rgba>)), ((<SDL::PixelFormat#map_rgb>)), ((<SDL::PixelFormat#map_rgba>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface.new(flags,w,h,depth,Rmask,Gmask,Bmask,Amask)
--- SDL::Surface.new(flags,w,h,format)

    Allocate an empty surface 
    (must be called after ((<SDL::Screen.open>)))
    
    If depth is 8 bits an empty palette is allocated for the
    surface, otherwise a 'packed-pixel' format is created
    using the ((|RGBAmask|))'s provided (see ((<SDL::PixelFormat>))). 
    The ((|flags|))
    specifies the type of surface that should be created, it is an
    OR'd combination of the following possible values.
    
    :SDL::SWSURFACE
      SDL will create the surface in system memory.
      This improves the performance of pixel level
      access, however you may not be able to take
      advantage of some types of hardware blitting.
    :SDL::HWSURFACE
      SDL will attempt to create the surface in
      video memory. This will allow SDL to take
      advantage of Video->Video blits (which are
      often accelerated).
    :SDL::SRCCOLORKEY
      This flag turns on colourkeying for blits from
      this surface. If SDL::HWSURFACE is also
      specified and colourkeyed blits are
      hardware-accelerated, then SDL will attempt to
      place the surface in video memory. Use
      ((<SDL::Surface#set_color_key>)) to set or clear this flag
      after surface creation.
    :SDL::SRCALPHA
      This flag turns on alpha-blending for blits
      from this surface. If SDL::HWSURFACE is also
      specified and alpha-blending blits are
      hardware-accelerated, then the surface will be
      placed in video memory if possible. Use
      ((<SDL::Surface#set_alpha>)) to set or clear this flag after
      surface creation.

    Returns the instance of ((<SDL::Surface>)).

    Raises ((<SDL::Error>)) on failure

    EXAMPLE
      # Create a 32-bit surface with the bytes of 
      # each pixel in R,G,B,A order,
      # as expected by OpenGL for textures
      
      big_endian = ([1].pack("N") == [1].pack("L"))
      
      if big_endian
        rmask = 0xff000000
        gmask = 0x00ff0000
        bmask = 0x0000ff00
        amask = 0x000000ff
      else
        rmask = 0x000000ff
        gmask = 0x0000ff00
        bmask = 0x00ff0000
        amask = 0xff000000
      end
      
      surface = SDL::Surface.new(SDL::SWSURFACE, width, height, 32,
                                 rmask, gmask, bmask, amask);

    * NOTES

        Note: If an alpha-channel is specified (that is, if ((|Amask|)) is
        nonzero), then the SDL::SRCALPHA flag is automatically set.
        You may remove this flag by calling ((<SDL::Surface#set_alpha>)) after
        surface creation.

    * See Also
      
      ((<SDL::Surface.new_from>)), ((<SDL::Screen.oepn>)), ((<SDL::Surface#lock>)), ((<SDL::Surface#set_alpha>)), ((<SDL::Surface#set_color_key>))

--- SDL::Surface.new_from(pixels,w,h,depth,pitch,Rmask,Gmask,Bmask,Amask)

    Creates an ((<SDL::Surface>)) object from the provided pixel data.
    
    The data stored in ((|pixels|))(String object)
     is assumed to be of the depth
    specified in the parameter list. 
    ((|pitch|)) is the length of each scanline in bytes.
    
    See ((<SDL::Surface.new>)) for a more detailed description of the
    other parameters.

    Returns the created surface.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface.new>))

--- SDL::Surface#lock

    This method sets up a surface for directly accessing the pixels. Between calls to ((<SDL::Surface#lock>)) 
    and ((<SDL::Surface#unlock>)) you can write to and read from surface directly.
    Once you are done accessing the surface, you should use ((<SDL::Surface#unlock>)) to release it.
    
    Not all surfaces require locking. If ((<SDL::Surface#must_lock?>)) returns false, then you can read and write to
    the surface at any time, and the pixel format of the surface will not change.
    
    No operating system or library calls should be made between lock/unlock pairs, as critical system locks
    may be held during this time.
    
    It should be noted, that since SDL 1.1.8 surface locks are recursive. This means that you can lock a
    surface multiple times, but each lock must have a match unlock.
      surface.lock
      # Surface is locked
      # Direct pixel access on surface here
      surface.lock
      # More direct pixel access on surface
      surface.unlock
      # Surface is still locked
      # Note: Is versions < 1.1.8, the surface would have been
      # no longer locked at this stage
      surface.unlock
      # Surface is now unlocked
    
    You shoud lock before colling following methods:
    * ((<SDL::Surface#pixels>))
    * ((<SDL::Surface#put_pixel>))
    * ((<SDL::Surface#get_pixel>))
    * ((<SDL::Surface#draw_line>))
    * ((<SDL::Surface#draw_aa_line>))
    * ((<SDL::Surface#draw_line_alpha>))
    * ((<SDL::Surface#draw_aa_line_alpha>))
    * ((<SDL::Surface#draw_rect>))
    * ((<SDL::Surface#draw_rect_alpha>))
    * ((<SDL::Surface#draw_filled_rect_alpha>))
    * ((<SDL::Surface#draw_circle>))
    * ((<SDL::Surface#draw_filled_circle>))
    * ((<SDL::Surface#draw_aa_circle>))
    * ((<SDL::Surface#draw_aa_filled_circle>))
    * ((<SDL::Surface#draw_circle_alpha>))
    * ((<SDL::Surface#draw_filled_circle_alpha>))
    * ((<SDL::Surface#draw_aa_circle_alpha>))
    * ((<SDL::Surface#draw_ellipse>))
    * ((<SDL::Surface#draw_filled_ellipse>))
    * ((<SDL::Surface#draw_aa_ellipse>))
    * ((<SDL::Surface#draw_aa_filled_ellipse>))
    * ((<SDL::Surface#draw_ellipse_alpha>))
    * ((<SDL::Surface#draw_filled_ellipse_alpha>))
    * ((<SDL::Surface#draw_aa_ellipse_alpha>))
    * ((<SDL::Surface#draw_bezier>))
    * ((<SDL::Surface#draw_aa_bezier>))
    * ((<SDL::Surface#draw_bezier_alpha>))
    * ((<SDL::Surface#draw_aa_bezier_alpha>))
    * ((<SDL::Surface#transform_surface>))

    Raises ((<SDL::Error>)), if the surface couldn't be locked.

    * NOTES

      If ((<SDL::Surface#auto_lock?>)) returns true, you need not call this method
      because Ruby/SDL automatically locks surface when you call methods that 
      need locking.

    * See Also
      
      ((<SDL::Surface#unlock>)), ((<SDL::Surface#must_lock?>)), ((<SDL.auto_lock?>)), ((<SDL.auto_lock_on>)), ((<SDL.auto_lock_off>)), ((<SDL.auto_lock=>))

--- SDL::Surface#unlock

    Surfaces that were previously locked using ((<SDL::Surfaces#lock>)) must be unlocked with ((<SDL::Surfaces#unlock>)).
    Surfaces should be unlocked as soon as possible.
    
    It should be noted that since 1.1.8, surface locks are recursive.

    * See Also
      
      ((<SDL::Surface#lock>))

--- SDL::Surface#must_lock?
--- SDL::Surface#mustLock?

    Returns true if ((|self|)) require locking for direct access to the pixels, 
    otherwise returns false.

    * See Also
      
      ((<SDL::Surface#lock>))

--- SDL::Surface.load_bmp(filename)
--- SDL::Surface.loadBMP(filename)

    Loads a surface from a named Windows BMP file.

    Returns the new ((<SDL::Surface>)) object.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface#save_bmp>)), ((<SDL::Surface.load>))

--- SDL::Surface.load_bmp_from_io(io)
--- SDL::Surface.loadBMPFromIO(io)

    Loads a surface from a ruby's IO object.
    IO object means the ruby object that has following methods:
    * read
    * rewind
    * tell
    
    For example, instances of IO class, StringIO class and Zlib::GZipReader class
    are IO object.

    Returns the new ((<SDL::Surface>)) object.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface.load_bmp>)), ((<SDL::Surface.load_from_io>))

--- SDL::Surface#save_bmp(filename)
--- SDL::Surface#saveBMP(filename)

    Saves the ((|self|)) surface as a Windows BMP file named ((|filename|)).

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface.load_bmp>))

--- SDL::Surface#destroy

    Frees the resource used by a Surface.
    If a surface is destroyed, all operations are forbidden.

    * See Also
      
      ((<SDL::Surface.new>)), ((<SDL::Surface.new_from>)), ((<SDL::Surface#destroyed?>))

--- SDL::Surface#destroyed?

    Returns whether the surface is destroyed by
    ((<SDL::Surface#destroy>)).

    * See Also
      
      ((<SDL::Surface#destroy>))

--- SDL::Surface#set_color_key(flag,key)
--- SDL::Surface#setColorKey(flag,key)

    Sets the color key (transparent pixel) in a blittable ((|surface|Surface|))
    and enables or disables RLE blit acceleration.
    ((|key|)) parameter should be pixel value or color array.
    
    RLE acceleration can substantially speed up blitting 
    of images with large horizontal runs of transparent
    pixels (i.e., pixels that match the ((|key|)) value). 
    The key must be of the same pixel format as the surface,
    if pixel value is used.
    In that case, ((<SDL::PixelFormat#map_rgb>))
    is often useful for obtaining an acceptable value.
    
    If ((|flag|)) is SDL_SRCCOLORKEY then ((|key|)) is the transparent pixel color in the source image of a blit.
    
    If ((|flag|)) is OR'd with SDL::RLEACCEL then the surface will 
    be draw using RLE acceleration when drawn with 
    ((<SDL::Surface.blit>)). The surface will actually be encoded 
    for RLE acceleration the first time ((<SDL::Surface.blit>))
    or ((<SDL::Surface#display_format>)) is called on the surface.
    
    If ((|flag|)) is 0, this function clears any current color key.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface.blit>)), ((<SDL::Surface#display_format>)), ((<SDL::Surface#map_rgb>)), ((<SDL::Surface#set_alpha>)), ((<SDL::Surface#colorkey>))

--- SDL::Surface#set_alpha(flags,alpha)
--- SDL::Surface#setAlpha(flags,alpha)

    This method is used for setting the per-surface alpha value and/or enabling and disabling alpha
    blending.
    
    The surface parameter specifies which surface whose 
    alpha attributes you wish to adjust. ((|flags|)) is used to
    specify whether alpha blending should be used (SDL::SRCALPHA)
     and whether the surface should use RLE
    acceleration for blitting (SDL::RLEACCEL). ((|flags|)) 
    can be an OR'd combination of these two options, one of
    these options or 0. If SDL::SRCALPHA is not passed as a flag
     then all alpha information is ignored when
    blitting the surface. The alpha parameter is the 
    per-surface alpha value; a surface need not have an
    alpha channel to use per-surface alpha and blitting can still be accelerated with SDL::RLEACCEL.
    
    Alpha effects surface blitting in the following ways:
    
    :RGBA->RGB with SDL::SRCALPHA    
      The source is alpha-blended with the destination, using the alpha channel.
      SDL_SRCCOLORKEY and the per-surface alpha are ignored.
    
    :RGBA->RGB without SDL::SRCALPHA
      The RGB data is copied from the source. The source alpha channel and the per-surface
      alpha value are ignored.
    
    :RGB->RGBA with SDL::SRCALPHA
      The source is alpha-blended with the destination using the per-surface alpha value. If
      SDL::SRCCOLORKEY is set, only the pixels not matching the colorkey value are copied. The
      alpha channel of the copied pixels is set to opaque.
    
    :RGB->RGBA without SDL::SRCALPHA
      The RGB data is copied from the source and the alpha value of the copied pixels is set to
      opaque. If SDL::SRCCOLORKEY is set, only the pixels not matching the colorkey value are
      copied.   
                                                                                                             
    :RGBA->RGBA with  SDL::SRCALPHA
      The source is alpha-blended with the destination using the source alpha channel. The     
      alpha channel in the destination surface is left untouched. SDL::SRCCOLORKEY is ignored.  
    
    RGBA->RGBA witout SDL::SRCALPHA
      The RGBA data is copied to the destination surface. If SDL::SRCCOLORKEY is set, only the  
      pixels not matching the colorkey value are copied.
    
    RGB->RGB with SDL_SRCALPHA
      The source is alpha-blended with the destination using the per-surface alpha value. If
      SDL_SRCCOLORKEY is set, only the pixels not matching the colorkey value are copied.
    
    RGB->RGB witout SDL_SRCALPHA
      The RGB data is copied from the source. If SDL_SRCCOLORKEY is set, only the pixels not
      matching the colorkey value are copied.

    Raises ((<SDL::Error>)) on failure
    * NOTES

      Note: This method and the semantics of SDL alpha blending have changed since version 1.1.4. Up
      until version 1.1.5, an alpha value of 0 was considered opaque and a value of 255 was considered
      transparent. This has now been inverted: 0 (SDL::ALPHA_TRANSPARENT) is now considered transparent and
      255 (SDL::ALPHA_OPAQUE) is now considered opaque.
      The per-surface alpha value of 128 is considered a special case and is optimised, so it's much
      faster than other per-surface values.
      
      Note that RGBA->RGBA blits (with SDL::SRCALPHA set) keep the alpha of the destination surface.
      This means that you cannot compose two arbitrary RGBA surfaces this way and get the result you would
      expect from "overlaying" them; the destination alpha will work as a mask.
      
      Also note that per-pixel and per-surface alpha cannot be combined; the per-pixel alpha is always used
      if available

    * See Also
      
      ((<SDL::Surface#map_rgba>)), ((<SDL::Surface#get_rgba>)), ((<SDL::Surface#display_format>)), ((<SDL::Surface.blit>)), ((<SDL::Surface#alpha>))

--- SDL::Surface#set_clip_rect(x,y,w,h)
--- SDL::Surface#setClipRect(x,y,w,h)

    Sets the clipping rectangle for a surface. 
    When this surface is the destination of a blit, only the area
    within the clip rectangle will be drawn into.
    
    The rectangle pointed to by rect will be clipped to the edges of the surface so that the clip rectangle
    for a surface can never fall outside the edges of the surface.

    * See Also
      
      ((<SDL::Surface#get_clip_rect>)), ((<SDL::Surface.blit>))

--- SDL::Surface#get_clip_rect
--- SDL::Surface#getClipRect

    Gets the clipping rectangle for a surface. When this surface is the destination of a blit, only the area
    within the clip rectangle is drawn into.

    Returns 4 element array as [x, y, w, h].

    * See Also
      
      ((<SDL::Surface#set_clip_rect>)), ((<SDL::Surface.blit>))

--- SDL.blit_surface(src,srcX,srcY,srcW,srcH,dst,dstX,dstY)
--- SDL.blitSurface(src,srcX,srcY,srcW,srcH,dst,dstX,dstY)

    This method is obsolete. Please use ((<SDL::Surface.blit>)) instead.

--- SDL::Surface.blit(src,srcX,srcY,srcW,srcH,dst,dstX,dstY)

    This performs a fast blit from the source surface to the destination surface.
    
    ((|src|)) is source surface, ((|dst|)) is destination surface, 
    ((|srcX|)), ((|srcY|)), ((|srcW|)), ((|srcH|)) is source rectangle, 
    and ((|dstX|)), ((|dstY|)) is destination point.
    If all of ((|srcX|)), ((|srcY|)), ((|srcW|)), ((|srcH|)) is zero, the entire surface is copied.
    
    The blit function should not be called on a locked surface.
    
    The results of blitting operations vary greatly depending on whether SDL::SRCAPLHA is set or not. See 
    ((<SDL::Surface#set_alpha>)) for an explaination of how this 
    affects your results. Colorkeying and alpha attributes also
    interact with surface blitting, as the following pseudo-code should hopefully explain.
    
      if source surface has SDL::SRCALPHA set 
        if source surface has alpha channel (that is, Amask != 0)
          blit using per-pixel alpha, ignoring any colour key
        elsif source surface has SDL::SRCCOLORKEY set
          blit using the colour key AND the per-surface alpha value
        else
          blit using the per-surface alpha value
        end
      elsif source surface has SDL::SRCCOLORKEY se
        blit using the colour key
      else
        ordinary opaque rectangular blit
      end

    If the blit is successful, it returns 0.

    If either of the surfaces were in video memory, 
    and the blit raises SDL::Surface::VideoMemoryLost,
    the video memory was lost, so it
    should be reloaded with artwork and re-blitted.
    
    This happens under DirectX 5.0 when the system switches away from your fullscreen application. Locking
    the surface will also fail until you have access to the video memory again.

--- SDL::Surface#fill_rect(x,y,w,h,color)
--- SDL::Surface#fillRect(x,y,w,h,color)

    This method performs a fast fill of the given rectangle with ((|color|)).
    
    Please see ((<Color, PixelFormat and Pixel value>)) to specify ((|color|)).
    If the color value contains an alpha value then the destination is simply "filled"
    with that alpha information, no blending takes place.
    
    If there is a clip rectangle set on the destination (set via ((<SDL::Surface#set_clip_rect>)))
    then this function will clip based on the intersection of the clip rectangle 
    and the dstrect rectangle and the dstrect rectangle
    will be modified to represent the area actually filled.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface#map_rgb>)), ((<SDL::Surface#map_rgba>)), ((<SDL::Surface.blit>))

--- SDL::Surface#display_format
--- SDL::Surface#displayFormat

    This method copies ((|self|)) to a new surface of the pixel format and colors of the video
    framebuffer, suitable for fast blitting onto the display surface.
    
    If you want to take advantage of hardware colorkey or alpha blit acceleration, you should set the
    colorkey and alpha value before calling this function.
    
    If you want an alpha channel, see ((<SDL::Surface#display_format_alpha>)).

    Returns converted surface object.

    Raises ((<SDL::Error>)) if the conversion fails or runs out of memory.

    * See Also
      
      ((<SDL::Surface#display_format_alpha>)), ((<SDL::Surface#set_alpha>)), ((<SDL::Surface#set_color_key>))

--- SDL::Surface#display_format_alpha
--- SDL::Surface#displaFormatAlpha

    This method copies ((|self|)) to a new surface of the pixel format and colors of the video
    framebuffer plus an alpha channel, suitable for fast blitting onto the display surface.
    
    If you want to take advantage of hardware colorkey or alpha blit acceleration, you should set the
    colorkey and alpha value before calling this function.
    
    This function can be used to convert a colourkey to an alpha channel, if the SDL::SRCCOLORKEY flag is set
    on the surface. The generated surface will then be transparent (alpha=0) where the pixels match the
    colourkey, and opaque (alpha=255) elsewhere.

    Returns converted surface object.

    Raises ((<SDL::Error>)) if the conversion fails or runs out of memory.

    * See Also
      
      ((<SDL::Surface#display_format>)), ((<SDL::Surface#set_alpha>)), ((<SDL::Surface#set_color_key>))

--- SDL::Surface#flags

    Returns the surface flags.
    The following are supported:
    
    :SDL::SWSURFACE
      Surface is stored in system memory
    :SDL::HWSURFACE
      Surface is stored in video memory
    :SDL::ASYNCBLIT
      Surface uses asynchronous blits if possible
    :SDL::ANYFORMAT
      Allows any pixel-format (Display surface)
    :SDL::HWPALETTE
      Surface has exclusive palette
    :SDL::DOUBLEBUF
      Surface is double buffered (Display surface)
    :SDL::FULLSCREEN
      Surface is full screen (Display Surface)
    :SDL::OPENGL
      Surface has an OpenGL context (Display Surface)
    :SDL::OPENGLBLIT
      Surface supports OpenGL blitting (Display Surface)
    :SDL::RESIZABLE
      Surface is resizable (Display Surface)
    :SDL::HWACCEL
      Surface blit uses hardware acceleration
    :SDL::SRCCOLORKEY
      Surface use colorkey blitting
    :SDL::RLEACCEL
      Colorkey blitting is accelerated with RLE
    :SDL::SRCALPHA
      Surface blit uses alpha blending

    Returns OR'd compination of above constants.

    * See Also
      
      ((<SDL::Surface>)), ((<SDL::Screen>))

--- SDL::Surface#format

    Returns ((<SDL::PixelFormat>)) object.

--- SDL::Surface#w

    Returns width of the surface.

    * See Also
      
      ((<SDL::Surface#h>))

--- SDL::Surface#h

    Returns height of the surface

    * See Also
      
      ((<SDL::Surface#w>))

--- SDL::Surface#pixels

    Returns pixel data as String object.
    Examine ((<SDL::Surface#flags>)), ((<SDL::Surface#pitch>)) and ((<SDL::Surface#format>))
    to analyze pixel data.

    * NOTES

      You must ((<lock|SDL::Surface#lock>)) surface before calling this method.

    * See Also
      
      ((<SDL::Surface#flags>)), ((<SDL::Surface#pitch>)), ((<SDL::Surface#format>))

--- SDL::PixelFormat#Rmask

    Returns binary mask allowing us to isolate red component.

--- SDL::PixelFormat#Gmask

    Returns binary mask allowing us to isolate green component.

--- SDL::PixelFormat#Bmask

    Returns binary mask allowing us to isolate blue component.

--- SDL::PixelFormat#Amask

    Returns binary mask allowing us to isolate alpha component.

--- SDL::PixelFormat#Rloss

    Returns the number of bits lost from red component when packing 8-bit color component in a pixel.

--- SDL::PixelFormat#Gloss

    Returns the number of bits lost from green component when packing 8-bit color component in a pixel.

--- SDL::PixelFormat#Bloss

    Returns the number of bits lost from blue component when packing 8-bit color component in a pixel.

--- SDL::PixelFormat#Aloss

    Returns the number of bits lost from alpha component when packing 8-bit color component in a pixel.

--- SDL::PixelFormat#Rshift

    Returns the number of bits to the right of red component in the pixel value.

--- SDL::PixelFormat#Gshift

    Returns the number of bits to the right of green component in the pixel value.

--- SDL::PixelFormat#Bshift

    Returns the number of bits to the right of blue component in the pixel value

--- SDL::PixelFormat#Ashift

    Returns the number of bits to the right of alpha component in the pixel value.

--- SDL::Surface#colorkey

    Returns pixel value of transparent pixels.

    * See Also
      
      ((<SDL::Surface>)), ((<SDL::Surface#set_color_key>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface#alpha

    Returns surface alpha value from 0(transparent) to 255(opaque).

    * See Also
      
      ((<SDL::Surface#set_alpha>))

--- SDL::PixelFormat#colorkey

    Returns pixel value of transparent pixels.

    * See Also
      
      ((<SDL::Surface>)), ((<SDL::Surface#set_color_key>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::PixelFormat#alpha

    Returns surface alpha value from 0(transparent) to 255(opaque).

    * See Also
      
      ((<SDL::Surface#set_alpha>))

--- SDL::Surface#bpp

    This method is obsolete. Please use ((<SDL::PixelFormat#bpp>)) instead.

--- SDL::PixelFormat#bpp

    Returns the number of bits used to represent each pixel in a surface.
    Usually 8, 16, 24 or 32.

--- SDL::Surface#pitch

    Returns the number of bytes used for each scanline in a surface.
    
    ((<SDL::Surface#pixels>)) returns pitch*((<SDL::Surface#h>)) bytes string.
    Normally, this values is equal to ((<SDL::Surface#bpp>))*((<SDL::Surface#w>))/8, but
    in some case the value is more than bpp*w/8 because
    some pudding bytes are used.

--- SDL::Surface.load(filename)

    Load image into an surface and returns ((<surface|SDL::Surface>)) object.
    If image format supports transparent color, colorkey is set into new surfafe.
    
    Supoorted formats are
    BMP, PNM (PPM/PGM/PBM), XPM,
    XCF, PCX, GIF, JPEG, TIFF, TGA, PNG and LBM.

    Raises ((<SDL::Error>)) on failure

    You need SDL_image to use this method.
--- SDL::Surface.load_from_io(io)
--- SDL::Surface.loadFromIO(io)

    Loads a surface from a ruby's IO object.
    IO object means the ruby object that has following methods:
    * read
    * rewind
    * tell
    
    If image format supports transparent color, colorkey is set into new surfafe.
    Supoorted formats are
    BMP, PNM (PPM/PGM/PBM), XPM,
    XCF, PCX, GIF, JPEG, TIFF, TGA, PNG and LBM.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Surface.load>)), ((<SDL::Surface.load_bmp_from_io>))

--- SDL::Surface#put_pixel(x, y, color)
--- SDL::Surface#putPixel(x, y, color)
--- SDL::Surface#[]=(x, y, color)

    Writes ((|color|)) pixel at (((|x|)), ((|y|))).


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.
    * See Also
      
      ((<SDL::Surface#get_pixel>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface#get_pixel(x, y)
--- SDL::Surface#getPixel(x, y)
--- SDL::Surface#[](x, y)

    Returns pixel value at (((|x|)), ((|y|))).


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.
    * See Also
      
      ((<SDL::Surface#put_pixel>)), ((<Color, PixelFormat and Pixel value>))

--- SDL::Surface#put(src, x, y)

    Performs a fast blit from entire ((|src|)) surface to ((|self|)) at (((|x|)), ((|y|))).
    
    This means:
      SDL::Surface.blit(src, 0, 0, src.w, src.h, self, x, y)

    * See Also
      
      ((<SDL::Surface.blit>))

--- SDL::Surface#copy_rect(x,y,w,h)
--- SDL::Surface#copyRect(x,y,w,h)

    Copies a (((|x|)), ((|y|)), ((|w|)), ((|h|))) rectangle from ((|self|)) and return new ((|surface|Surface|)) object.

    Raises ((<SDL::Error>)) on failure
    * NOTES

      This method call ((<SDL::Surface.blit>)) internally, therefore you must unlock surface before calling it.

--- SDL.auto_lock?
--- SDL.autoLock?
--- SDL.auto_lock
--- SDL.autoLock

    This method is obsolete. Please use ((<SDL::Surface.auto_lock?>)) instead.


    You need SGE to use this method.
--- SDL::Surface.auto_lock?
--- SDL::Surface.autoLock?

    Returns true if surface is automatically ((<locked|SDL::Surface#lock>))
    when necessary, otherwise returns false.
    
    Default is ON(true).


    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL::Surface#unlock>)), ((<SDL::Surface.auto_lock_on>)), ((<SDL::Surface.auto_lock_off>))

--- SDL.auto_lock_on
--- SDL.autoLockON

    This method is obsolete. Please use ((<SDL::Surface.auto_lock_on>)) instead.


    You need SGE to use this method.
--- SDL::Surface.auto_lock_on
--- SDL::Surface.autoLockON

    Enables auto surface locking. 


    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL::Surface.auto_lock?>)), ((<SDL::Surface.auto_lock_off>))

--- SDL.auto_lock_off
--- SDL.autoLockOFF

    This method is obsolete. Please use ((<SDL::Surface.auto_lock_off>)) instead.


    You need SGE to use this method.
--- SDL::Surface.auto_lock_off
--- SDL::Surface.autoLockOFF

    Disables auto surface locking. 


    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL::Surface.auto_lock?>)), ((<SDL::Surface.auto_lock_on>))

--- SDL.auto_lock=(locking)
--- SDL.autoLock=(locking)

    This method is obsolete. Please use ((<SDL::Surface.auto_lock_on>)) instead.

    Enables or disables auto surface locking.
    'SDL.auto_lock = true' is same as ((<SDL::Surface.auto_lock_on>))
    and 'SDL.auto_lock = false' is same as 
    ((<SDL::Surface.auto_lock_off>)).


    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#lock>)), ((<SDL.auto_lock?>)), ((<SDL.auto_lock_on>)), ((<SDL.auto_lock_off>))

--- SDL.transform(src,dst,angle,xscale,yscale,px,py,qx,qy,flags)

    This method is obsolete. Please use ((<SDL::Surface.transform_draw>)) instead.


    You need SGE to use this method.
--- SDL::Surface.transform_draw(src,dst,angle,xscale,yscale,px,py,qx,qy,flags)

    Draws a rotated and scaled version of ((|src|)) on ((|dest|)).
    ((|angle|)) the rotation angle in degrees, 
    ((|xscale|)) and ((|yscale|)) are x and y scaling factor,
    (((|px|)), ((|py|))) is the pivot point to rotate around in the ((|src|)),
    and (((|qx|)), ((|qy|))) is the destination point on ((|dst|)) surface.
    
    ((|flags|)) is OR'd combination of follwing values:
    
    :0
      Default
    :SDL::Surface::TRANSFORM_SAFE
      Don't asume that the ((|src|)) and ((|dst|)) surfaces has
      the same pixel format. This is the default when the two
      surfaces don't have the same BPP. This is slower but will
      render wierd pixel formats right.
    :SDL::Surface::TRANSFORM_AA
      Use the interpolating renderer. Much slower but
      can look better.
    :SDL::Surface::TRANSFORM_TMAP
      Use texture mapping. This is a bit faster but
      the result isn't as nice as in the normal mode. This mode
      will also ignore the px/py coordinates and the other flags.


    You need SGE to use this method.
    * NOTES

      To get optimal performance PLEASE make sure that the two
      surfaces has the same pixel format (color depth) and doesn't use
      24-bpp.
      
      You can set source and destination clipping rectangles with
      ((<SDL::Surface#set_clip_rect>)).
      
      If you use the interpolated renderer the image will be
      clipped 1 pixel in hight and width (to optimize the
      performance).
      
      If you want to transform a 32-bpp RGBA (alpha) surface with
      the interpolated renderer, please use the 
      SDL::TRANSFORM_SAFE flag.
      
      This function will not do any alpha blending, but it will
      try to preserve the alpha channel. If you want to rotate and
      alpha blend the result, please use ((<SDL::Surface.transform_blit>))
      and then blit that surface to its destination.

    * See Also
      
      ((<SDL::Surface.transform_blit>)), ((<SDL::Surface#transform_surface>)), ((<SDL::Surface.new>))

--- SDL.transform_blit(src,dst,angle,xscale,yscale,px,py,qx,qy,flags)
--- SDL.transformBlit(src,dst,angle,xscale,yscale,px,py,qx,qy,flags)

    This method is obsolete. Please use ((<SDL::Surface.transform_blit>)) instead.


    You need SGE to use this method.
--- SDL::Surface.transform_blit(src,dst,angle,xscale,yscale,px,py,qx,qy,flags)
--- SDL::Surface.transformBlit(src,dst,angle,xscale,yscale,px,py,qx,qy,flags)

    Draw a rotated and scaled image. 
    This method is same as ((<SDL::Surface.transform_draw>)) except
    colorkey and blending are enabled. 


    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface.transform_draw>)), ((<SDL::Surface#transform_surface>)), ((<SDL::Surface#set_color_key>)), ((<SDL::Surface#set_alpha>))

--- SDL::Surface#draw_line(x1,y1,x2,y2,color, aa=false, alpha=nil)
--- SDL::Surface#drawLine(x1,y1,x2,y2,color, aa=false, alpha=nil)

    Draws a ((|color|)) line from (((|x1|)), ((|y1|))) to (((|x2|)), ((|y2|))).
    If ((|aa|)) is true, draws an antialiased line.
    If ((|alpha|)) is integer, draws blended line with alpha value
    is ((|alpha|)). 
    If ((|alpha|)) is nil, draws a normal line.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_rect>))

--- SDL::Surface#draw_aa_line(x1,y1,x2,y2,color)
--- SDL::Surface#drawAALine(x1,y1,x2,y2,color)

    This method is obsolete. Please use ((<SDL::Surface#draw_line>)) instead.

    Draws a ((|color|)) antialiased line from (((|x1|)), ((|y1|))) to (((|x2|)), ((|y2|))).


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_line>))

--- SDL::Surface#draw_line_alpha(x1,y1,x2,y2,color,alpha)
--- SDL::Surface#drawLineAlpha(x1,y1,x2,y2,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_line>)) instead.

    Draws a ((|color|)) line from (((|x1|)), ((|y1|))) to (((|x2|)), ((|y2|)))
    with blending.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_line>))

--- SDL::Surface#draw_aa_line_alpha(x1,y1,x2,y2,color,alpha)
--- SDL::Surface#drawAALineAlpha(x1,y1,x2,y2,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_line>)) instead.

    Draws a antialiased ((|color|)) line from 
    (((|x1|)), ((|y1|))) to (((|x2|)), ((|y2|))) with blending.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_line>))

--- SDL::Surface#draw_rect(x,y,w,h,color, fill=false, alpha=nil)
--- SDL::Surface#drawRect(x,y,w,h,color, fill=false, alpha=nil)

    Draws a rectangle with color ((|color|)). 
    Draw a filled rectangle if ((|fill|)) is true,
    and a blended rectangle if ((|alpha|)) is integer.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#fill_rect>))

--- SDL::Surface#draw_rect_alpha(x,y,w,h,color,alpha)
--- SDL::Surface#drawRectAlpha(x,y,w,h,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_rect>)) instead.

    Draws a blended rectangle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#fill_rect>)), ((<SDL::Surface#draw_rect>))

--- SDL::Surface#draw_filled_rect_alpha(x,y,w,h,color,alpha)
--- SDL::Surface#drawFilledRectAlpha(x,y,w,h,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_rect>)) instead.

    Draws a filled blended rectangle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#fill_rect>)), ((<SDL::Surface#draw_rect>))

--- SDL::Surface#draw_circle(x,y,r,color,fill=false,aa=false,alpha=0)
--- SDL::Surface#drawCircle(x,y,r,color,fill=false,aa=false,alpha=0)

    Draws a circle. (((|x|)),((|y|))) is center, 
    ((|r|)) is radius and ((|color|)) is drawing color.
    If ((|fill|)) is true, draws a filled circle.
    If ((|aa|)) is true, draws an antialiased circle.
    If ((|alpha|)) is integer, draws a blended circle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * NOTES

      You cannot draw a filled antialiased blended circle.

    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_filled_circle(x,y,r,color)
--- SDL::Surface#drawFilledCircle(x,y,r,color)

    This method is obsolete. Please use ((<SDL.draw_circle>)) instead.

    Draws a filled circle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_aa_circle(x,y,r,color)
--- SDL::Surface#drawAACircle(x,y,r,color)

    This method is obsolete. Please use ((<SDL.draw_circle>)) instead.

    Draws an antialiased circle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_aa_filled_circle(x,y,r,color)
--- SDL::Surface#drawAAFilledCircle(x,y,r,color)

    This method is obsolete. Please use ((<SDL.draw_circle>)) instead.

    Draws a filled antialiased circle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_circle_alpha(x,y,r,color,alpha)
--- SDL::Surface#drawCircleAlpha(x,y,r,color,alpha)

    This method is obsolete. Please use ((<SDL.draw_circle>)) instead.

    Draws blended circle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_filled_circle_alpha(x,y,r,color,alpha)
--- SDL::Surface#drawFilledCircleAlpha(x,y,r,color,alpha)

    This method is obsolete. Please use ((<SDL.draw_circle>)) instead.

    Draws a filled blended circle.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_aa_circle_alpha(x,y,r,color,alpha)
--- SDL::Surface#drawAACircleAlpha(x,y,r,color,alpha)

    This method is obsolete. Please use ((<SDL.draw_circle>)) instead.

    Draws an antialiased blended circle


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_ellipse(x,y,rx,ry,color, fill=false, aa=false, alpha=nil)
--- SDL::Surface#drawEllipse(x,y,rx,ry,color, fill=false, aa=false, alpha=nil) )

    
    Draws an ellipse. (((|x|)),((|y|))) is center, 
    ((|rx|)) is x-radius, ((|ry|)) is y-radius
    and ((|color|)) is drawing color.
    If ((|fill|)) is true, draws a filled ellipse.
    If ((|aa|)) is true, draws an antialiased ellipse.
    If ((|alpha|)) is integer, draws a blended ellipse.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * NOTES

      You cannot draw a filled antialiased blended ellipse.

    * See Also
      
      ((<SDL::Surface#draw_circle>))

--- SDL::Surface#draw_filled_ellipse(x,y,rx,ry,color)
--- SDL::Surface#drawFilledEllipse(x,y,rx,ry,color)

    This method is obsolete. Please use ((<SDL::Surface#draw_ellipse>)) instead.

    Draws a filled ellipse.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_aa_ellipse(x,y,rx,ry,color)
--- SDL::Surface#drawAAEllipse(x,y,rx,ry,color)

    This method is obsolete. Please use ((<SDL::Surface#draw_ellipse>)) instead.

    Draws an antialiased ellipse.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_aa_filled_ellipse(x,y,rx,ry,color)
--- SDL::Surface#drawAAFilledEllipse(x,y,rx,ry,color)

    This method is obsolete. Please use ((<SDL::Surface#draw_ellipse>)) instead.

    Draws a filled antialiased ellipse.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_ellipse_alpha(x,y,rx,ry,color,alpha)
--- SDL::Surface#drawEllipseAlpha(x,y,rx,ry,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_ellipse>)) instead.

    Draws a blended ellipse.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_filled_ellipse_alpha(x,y,rx,ry,color,alpha)
--- SDL::Surface#drawFilledEllipseAlpha(x,y,rx,ry,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_ellipse>)) instead.

    Draws a filled blended ellipse


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_aa_ellipse_alpha(x,y,rx,ry,color,alpha)
--- SDL::Surface#drawAAEllipseAlpha(x,y,rx,ry,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_ellipse>)) instead.

    Draws an antialiased blended ellipse.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_ellipse>))

--- SDL::Surface#draw_bezier(x1,y1,x2,y2,x3,y3,x4,y4,level,color,aa=false,alpha=nil)
--- SDL::Surface#drawBezier(x1,y1,x2,y2,x3,y3,x4,y4,level,color,aa=false,alpha=nil)

    Draws a bezier curve from (((|x1|)), ((|y1|))) to (((|x4|)), ((|y4|)))
    with the control points (((|x2|)), ((|y2|))) and (((|x3|)), ((|y3|))).
    ((|level|)) indicates how
    good precision the function should use, 4-7 is normal.
    If ((|aa|)) is true, draws an antialiased curve.
    If ((|alpha|)) is integer, draws blended curve.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
--- SDL::Surface#draw_aa_bezier(x1,y1,x2,y2,x3,y3,x4,y4,level,color)
--- SDL::Surface#drawAABezier(x1,y1,x2,y2,x3,y3,x4,y4,level,color)

    This method is obsolete. Please use ((<SDL::Surface#draw_bezier>)) instead.

    Draws an antialiased bezier curve.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_bezier>))

--- SDL::Surface#draw_bezier_alpha(x1,y1,x2,y2,x3,y3,x4,y4,level,color,alpha)
--- SDL::Surface#drawBezierAlpha(x1,y1,x2,y2,x3,y3,x4,y4,level,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_bezier>)) instead.

    Draws a blended bezier curve.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_bezier>))

--- SDL::Surface#draw_aa_bezier_alpha(x1,y1,x2,y2,x3,y3,x4,y4,level,color,alpha)
--- SDL::Surface#drawAABezierAlpha(x1,y1,x2,y2,x3,y3,x4,y4,level,color,alpha)

    This method is obsolete. Please use ((<SDL::Surface#draw_bezier>)) instead.

    Draws an antialiased blended bezier curve.


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface#draw_bezier>))

--- SDL::Surface#transform_surface(bgcolor,angle,xscale,yscale,flags)
--- SDL::Surface#transformSurface(bgcolor,angle,xscale,yscale,flags)

    Returns a rotated and scaled version of ((|self|)).
    See ((|Surface.transform_draw|)) for more information.
    ((|bgcolor|)) is background color that new surface have.
    
    The new surface object will have the same depth 
    and pixel format as ((|self|)).


    This method needs ((<Locking|SDL::Surface#lock>)).
    If ((<SDL.auto_lock?>)) is true, Ruby/SDL automatically locks/unlocks the surface.
    Raises ((<SDL::Error>)) on failure

    You need SGE to use this method.
    * See Also
      
      ((<SDL::Surface.transform_draw>)), ((<SDL::Surface.transform_blit>))

