#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "transport_dg2.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e-10;
  bool dump = (argc > 2);
  Float w;
  field phi_h;
  din >> catchmark("w")   >> w
      >> catchmark("phi") >> phi_h;
  size_t k = phi_h.get_space().degree();
  quadrature_option_type qopt;
  qopt.set_family(quadrature_option_type::gauss);
  qopt.set_order(2*k+1);
  Float err_l2   = sqrt(integrate (phi_h.get_geo(), sqr(phi_h - phi_exact(w)), qopt));
  space Th1 (phi_h.get_geo(), "P"+itos(k+1)+"d");
  field eh = interpolate(Th1, phi_h - phi_exact(w));
  Float err_linf = eh.max_abs();
  derr << "err_l2   = " << err_l2   << endl
       << "err_linf = " << err_linf << endl;
  if (dump) {
    dout << catchmark("phi")      << phi_h
         << catchmark("e")        << eh;
  }
  return (err_l2 < tol) ? 0 : 1;
}
