#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"../../../rheolef/nfem/tst"}

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

C="0"
Cy="0 1"
P="x2 xy y2"
# J'ai supprime le test sur la forme "div" car elle est assemblee avec deux espaces P2 vectoriels, et ca n'est pas correct...
# maintenant les matrices elementaires testent cela et ca genere une erreur (Pierre -> Jocelyn)
FORMS="mass 2D_D"
APPS="P2"
L="-1 0 1"

status=0
command="../sbin/mkgeo_grid_2d 10 10 > square.geo"
echo "      $command"
eval $command 2>/dev/null

i=0
for form in $FORMS; do
 for app_u in $APPS; do
 for app_v in $APPS; do
 for i in $C; do
  for j in $Cy; do
  for lu in $L; do
  for lv in $L; do
   for p in $P; do
    for q in $P; do
     command="./form_on_locked_space_tst square -lock top -form $form -approx-u $app_u -approx-v $app_v -lock-u-component $lu -lock-v-component $lv -u-monom $p -v-monom $q -u-component $i -v-component $j"
     echo "      $command"
     eval $command >/dev/null 2>/dev/null
     if test $? -ne 0; then status=1; echo "        => *NO*"; exit $status; fi
    done
   done
   done
   done
  done
 done
 done
 done
done

command="/bin/rm -f square.geo"
echo "      $command"
eval $command
exit $status

