///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// P2 approximation
//
#include "rheolef/rheostream.h"
#include "basis_symbolic.h"
#include "basis_symbolic.h"
using namespace rheolef;
using namespace std;
using namespace GiNaC;

class Pk_symbolic : public basis_symbolic_nodal
{
    typedef basis_symbolic_nodal::size_type size_type;
public:
    Pk_symbolic (size_type k);
};
Pk_symbolic::Pk_symbolic (size_type degree)
: basis_symbolic_nodal("P"+itos(degree),degree)
{
  typedef point_basic<size_type> ilat;
  std::vector<point_basic<ex> >  hat_xnod;
  // ------------------------------------
  on('p') << node(0) << poly (1) << end;
  // ------------------------------------
  hat_xnod.resize (reference_element::n_node(reference_element::e, degree));
  for (size_type i = 0; i <= degree; i++) { 
    on('e') << poly (pow(x,i));
    size_type loc_idof = reference_element_e::ilat2loc_inod (degree, ilat(i));
    hat_xnod [loc_idof] = point_basic<ex> ((ex(i))/ex(degree));
  }
  for (size_type loc_idof = 0, loc_ndof = hat_xnod.size(); loc_idof < loc_ndof; loc_idof++) { 
    on('e') << hat_xnod [loc_idof];
  }
  on('e') << end;
  // ------------------------------------
  hat_xnod.resize (reference_element::n_node(reference_element::t, degree));
  for (size_type j = 0; j <= degree; j++) { 
    for (size_type i = 0; i+j <= degree; i++) { 
      on('t') << poly (pow(x,i)*pow(y,j));
      size_type loc_idof = reference_element_t::ilat2loc_inod (degree, ilat(i,j));
      hat_xnod [loc_idof] = point_basic<ex> ((ex(i))/ex(degree), ex(j)/ex(degree));
    }
  }
  for (size_type loc_idof = 0, loc_ndof = hat_xnod.size(); loc_idof < loc_ndof; loc_idof++) { 
    on('t') << hat_xnod [loc_idof];
  }
  on('t') << end;
  // ------------------------------------
  hat_xnod.resize (reference_element::n_node(reference_element::q, degree));
  for (size_type j = 0; j <= degree; j++) { 
    for (size_type i = 0; i <= degree; i++) { 
      on('q') << poly (pow(x,i)*pow(y,j));
      size_type loc_idof = reference_element_q::ilat2loc_inod (degree, ilat(i,j));
      hat_xnod [loc_idof] = point_basic<ex> (-1+2*(ex(i))/ex(degree), -1+2*ex(j)/ex(degree));
    }
  }
  for (size_type loc_idof = 0, loc_ndof = hat_xnod.size(); loc_idof < loc_ndof; loc_idof++) { 
    on('q') << hat_xnod [loc_idof];
  }
  on('q') << end;
  // -----------------------------------------
  if (degree >= 5) return; // too big: not yet
  // ------------------------------------
  hat_xnod.resize (reference_element::n_node(reference_element::T, degree));
  for (size_type k = 0; k <= degree; k++) {
    for (size_type j = 0; j+k <= degree; j++) {
      for (size_type i = 0; i+j+k <= degree; i++) { 
        on('T') << poly (pow(x,i)*pow(y,j)*pow(z,k));
        size_type loc_idof = reference_element_T::ilat2loc_inod (degree, ilat(i,j,k));
        hat_xnod [loc_idof] = point_basic<ex> ((ex(i))/ex(degree), ex(j)/ex(degree), ex(k)/ex(degree));
      }
    }
  }
  for (size_type loc_idof = 0, loc_ndof = hat_xnod.size(); loc_idof < loc_ndof; loc_idof++) { 
    on('T') << hat_xnod [loc_idof];
  }
  on('T') << end;
  // -----------------------------------------
  hat_xnod.resize (reference_element::n_node(reference_element::P, degree));
  for (size_type k = 0; k <= degree; k++) { 
    for (size_type j = 0; j <= degree; j++) { 
      for (size_type i = 0; i+j <= degree; i++) { 
        on('P') << poly (pow(x,i)*pow(y,j)*pow(z,k));
        size_type loc_idof = reference_element_P::ilat2loc_inod (degree, ilat(i,j,k));
        hat_xnod [loc_idof] = point_basic<ex> ((ex(i))/ex(degree), ex(j)/ex(degree), -1+2*ex(k)/ex(degree));
      }
    }
  }
  for (size_type loc_idof = 0, loc_ndof = hat_xnod.size(); loc_idof < loc_ndof; loc_idof++) { 
    on('P') << hat_xnod [loc_idof];
  }
  on('P') << end;
  // ------------------------------------
  hat_xnod.resize (reference_element::n_node(reference_element::H, degree));
  for (size_type k = 0; k <= degree; k++) { 
    for (size_type j = 0; j <= degree; j++) { 
      for (size_type i = 0; i <= degree; i++) { 
        on('H') << poly (pow(x,i)*pow(y,j)*pow(z,k));
        size_type loc_idof = reference_element_H::ilat2loc_inod (degree, ilat(i,j,k));
        hat_xnod [loc_idof] = point_basic<ex> (-1+2*(ex(i))/ex(degree), -1+2*ex(j)/ex(degree), -1+2*ex(k)/ex(degree));
      }
    }
  }
  for (size_type loc_idof = 0, loc_ndof = hat_xnod.size(); loc_idof < loc_ndof; loc_idof++) { 
    on('H') << hat_xnod [loc_idof];
  }
  on('H') << end;
}
int main (int argc, char **argv) {
        if (argc < 3) {
	   cerr << "Pk_symbolic: usage: Pk_symbolic [-h|-c] degree" << endl;
           exit (1);
        }
        size_t degree = atoi (argv[2]);
	Pk_symbolic Pk (degree);
	Pk.put_cxx_main (argc,argv);
}
