///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// diagonal form(X,Y,"A") : L2 scalar product, ect...
//
// authors: Pierre.Saramito@imag.fr
//
// date: 15 july 1997
//
# include "rheolef/form_diag.h"
# include "rheolef/field.h"
# include "rheolef/skit.h"

# include "form_diag_assembly.h"
using namespace std;
namespace rheolef { 
//
// symbol to function handler
// for elementary matrix funtions
//
static 
string
form_diag_symbol (
    const string& name, 
    const string& approx,
    const string& coord_sys)
{
    string symbol = "lumped_" + name;
    return symbol;
}
// shared with form.c:
string get_form_approx_name (const space&  X);

form_diag::form_diag (const space& X, const char* name)
: X_(X), uu(), bb()
{
  X_.freeze();
  string x_approx_name = get_form_approx_name(X);
  string coord_sys = X.coordinate_system();
  form_element
   form_e (form_diag_symbol(name, x_approx_name, coord_sys));

  form_diag_assembly (*this, form_e);
}
form_diag::form_diag (const field& dh)
: X_(dh.get_space()), uu(dh.u), bb(dh.b)
{
}

ostream& 
operator << (ostream& s, const form_diag& m)
{
    s << "M_U\n" << vec<Float>(m.uu);
    s << "M_B\n" << vec<Float>(m.bb);
    return s;
}

field
operator * (const form_diag& m, const field& x)
{
    field y(m.get_space());
    y.u = m.uu*x.u;
    y.b = m.bb*x.b;
    return y;
}

form_diag 
operator / (const Float& lambda, const form_diag& m)
{
  form_diag m0(m.get_space()) ;
  m0.uu = Float(1)/m.uu ;
  m0.bb = Float(1)/m.bb ;
  return m0 ;
}
form_diag
operator * (const form_diag& m1, const form_diag& m2)
{
  form_diag m(m1.get_space());
  m.uu = basic_diag<Float>(m1.uu * m2.uu);
  m.bb = basic_diag<Float>(m1.bb * m2.bb);
  return m;
}

//new
form_diag
operator - (const form_diag& m)
{
  form_diag g(m.get_space());
  g.uu = basic_diag<Float>(-1*m.uu) ; 
  g.bb = basic_diag<Float>(-1*m.bb) ;
  return g ;
}
form_diag
operator - (const form_diag& m1, const form_diag& m2)
{
  form_diag m(m1.get_space());
  m.uu = basic_diag<Float>(m1.uu - m2.uu);
  m.bb = basic_diag<Float>(m1.bb - m2.bb);
  return m;
}
form_diag
operator + (const form_diag& m1, const form_diag& m2)
{
  form_diag m(m1.get_space());
  m.uu = basic_diag<Float>(m1.uu + m2.uu);
  m.bb = basic_diag<Float>(m1.bb + m2.bb);
  return m;
}
form_diag
operator * (const Float& lambda, const form_diag& m)
{
  form_diag g(m.get_space());
  g.uu = basic_diag<Float>(lambda*m.uu) ; 
  g.bb = basic_diag<Float>(lambda*m.bb) ;
  return g ;
} 
}// namespace rheolef
