#include "rheolef.h"
using namespace rheolef;
using namespace std;

size_t N;
Float f (const point& x) { return 1.0*N*sin(x[0]+x[1]+x[2]); }
Float g (const point& x) { return sin(x[0]+x[1]+x[2]); }

int main(int argc, char**argv) {
  geo omega (argv[1]);
  N = omega.dimension();
  space Vh (omega, argv[2]);
  Vh.block ("boundary");
  form a(Vh, Vh, "grad_grad");
  form m(Vh, Vh, "mass");
  field uh (Vh);
  field fh = interpolate(Vh, f);
  const domain& boundary = omega["boundary"];
  space Wh (omega, boundary, argv[2]);
  uh["boundary"] = interpolate(Wh, g);
  if (omega.dimension() < 3) {
    ssk<Float> fact = ldlt(a.uu);
    uh.u = fact.solve (m.uu*fh.u + m.ub*fh.b - a.ub*uh.b);
  } else {
    size_t max_iter = 10000;
    Float tol = 1e-15;
    uh.u = 0;
    int status = pcg (a.uu, uh.u, m.uu*fh.u + m.ub*fh.b - a.ub*uh.b,
                  ic0(a.uu), max_iter, tol, &cerr);
  }
  cout << uh;
  return 0;
}
