
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Computational Engine                                                  *
 *                                                                        *
 *  Copyright (c) 1999-2014, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,       *
 *  MA 02110-1301, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

#include "triangulation/nedge.h"

namespace regina {

const int edgeNumber[4][4] = {
    { -1, 0, 1, 2 },
    {  0,-1, 3, 4 },
    {  1, 3,-1, 5 },
    {  2, 4, 5,-1 }};

const int edgeStart[6] =
    { 0, 0, 0, 1, 1, 2 };

const int edgeEnd[6] =
    { 1, 2, 3, 2, 3, 3 };

const int NEdge::edgeNumber[4][4] = {
    { -1, 0, 1, 2 },
    {  0,-1, 3, 4 },
    {  1, 3,-1, 5 },
    {  2, 4, 5,-1 }};

const int NEdge::edgeVertex[6][2] = {
    { 0, 1 },
    { 0, 2 },
    { 0, 3 },
    { 1, 2 },
    { 1, 3 },
    { 2, 3 }};

const NPerm4 NEdge::ordering[6] = {
    NPerm4(0, 1, 2, 3),
    NPerm4(0, 2, 3, 1),
    NPerm4(0, 3, 1, 2),
    NPerm4(1, 2, 0, 3),
    NPerm4(1, 3, 2, 0),
    NPerm4(2, 3, 0, 1)
};

void NEdge::writeTextLong(std::ostream& out) const {
    writeTextShort(out);
    out << std::endl;

    out << "Appears as:" << std::endl;
    std::deque<NEdgeEmbedding>::const_iterator it;
    for (it = embeddings_.begin(); it != embeddings_.end(); ++it)
        out << "  " << it->getTetrahedron()->markedIndex()
            << " (" << it->getVertices().trunc2() << ')' << std::endl;
}

} // namespace regina

